/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CommitAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final IResource[] resources = this.getSelectedResources();
        final RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        final String[] comment = new String[1];
        final IResource[][] resourcesToBeAdded = new IResource[1][];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    IResource[] unadded = CommitAction.this.getUnaddedResources(resources, monitor);
                    resourcesToBeAdded[0] = CommitAction.this.promptForResourcesToBeAdded(manager, unadded);
                    if (resourcesToBeAdded[0] == null) {
                        return;
                    }
                    comment[0] = CommitAction.this.promptForComment(manager, resources);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 2);
        if (comment[0] == null) {
            return;
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()).run(new ICVSRunnable(this, resourcesToBeAdded, manager, resources, comment){
                            private final /* synthetic */ IResource[][] val$resourcesToBeAdded;
                            private final /* synthetic */ RepositoryManager val$manager;
                            private final /* synthetic */ IResource[] val$resources;
                            private final /* synthetic */ 2 this$1;
                            private final /* synthetic */ String[] val$comment;
                            {
                                this.this$1 = var1_1;
                                this.val$resourcesToBeAdded = iResourceArray;
                                this.val$manager = repositoryManager;
                                this.val$resources = iResourceArray2;
                                this.val$comment = stringArray;
                            }

                            public void run(IProgressMonitor monitor) throws CVSException {
                                try {
                                    IResource[] shared;
                                    int ticks = 100;
                                    monitor.beginTask(null, ticks);
                                    if (this.val$resourcesToBeAdded[0].length > 0) {
                                        int addTicks = 20;
                                        this.val$manager.add(this.val$resourcesToBeAdded[0], Policy.subMonitorFor(monitor, addTicks));
                                        ticks -= addTicks;
                                    }
                                    if ((shared = CommitAction.access$2(2.access$0(this.this$1), this.val$resources)).length == 0) {
                                        return;
                                    }
                                    this.val$manager.commit(shared, this.val$comment[0], Policy.subMonitorFor(monitor, ticks));
                                }
                                catch (TeamException e) {
                                    throw CVSException.wrapException((TeamException)e);
                                }
                            }
                        }, monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }

            static /* synthetic */ CommitAction access$0(2 var0) {
                return var0.CommitAction.this;
            }
        }, true, 1);
    }

    private IResource[] getUnaddedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws CVSException {
        final ArrayList unadded = new ArrayList();
        final CVSException[] exception = new CVSException[1];
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                        try {
                            if (cvsResource.isIgnored()) {
                                return false;
                            }
                            if (cvsResource.isManaged()) {
                                return true;
                            }
                            if (cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
                                return true;
                            }
                        }
                        catch (CVSException e) {
                            exception[0] = e;
                        }
                        if (resource.getType() == 2) {
                            return true;
                        }
                        unadded.add(resource);
                        return false;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
            if (exception[0] != null) {
                throw exception[0];
            }
            ++i;
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    private IResource[] getSharedResources(IResource[] resources) throws CVSException {
        ArrayList<IResource> shared = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isManaged() || cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
                shared.add(resource);
            }
            ++i;
        }
        return shared.toArray(new IResource[shared.size()]);
    }

    protected String promptForComment(RepositoryManager manager, IResource[] resourcesToCommit) {
        return manager.promptForComment(this.getShell(), resourcesToCommit);
    }

    private IResource[] promptForResourcesToBeAdded(RepositoryManager manager, IResource[] unadded) {
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    static /* synthetic */ IResource[] access$2(CommitAction commitAction, IResource[] iResourceArray) {
        return commitAction.getSharedResources(iResourceArray);
    }
}

