/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagetLocationSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.AddToWorkspaceAction;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CheckoutAsAction
extends AddToWorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSRemoteFolder[] folders = this.getSelectedRemoteFolders();
        if (folders.length == 1) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)folders[0].forTag(folders[0].getTag());
            this.checkoutSingleProject(folder);
        } else {
            this.checkoutMultipleProjects(folders);
        }
    }

    private void checkoutMultipleProjects(final ICVSRemoteFolder[] folders) throws InvocationTargetException, InterruptedException {
        IProject[] targetProjects = new IProject[folders.length];
        int i = 0;
        while (i < folders.length) {
            ICVSRemoteFolder remoteFolder = folders[i];
            targetProjects[i] = ResourcesPlugin.getWorkspace().getRoot().getProject(remoteFolder.getName());
            ++i;
        }
        TagetLocationSelectionDialog dialog = new TagetLocationSelectionDialog(this.getShell(), Policy.bind("CheckoutAsAction.enterLocationTitle", new Integer(targetProjects.length).toString()), targetProjects);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        String targetParentLocation = dialog.getTargetLocation();
        if (targetParentLocation == null) {
            this.checkoutSelectionIntoWorkspaceDirectory();
            return;
        }
        IProjectDescription[] descriptions = new IProjectDescription[targetProjects.length];
        int i2 = 0;
        while (i2 < targetProjects.length) {
            String projectName = targetProjects[i2].getName();
            descriptions[i2] = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            descriptions[i2].setLocation(new Path(targetParentLocation).append(projectName));
            ++i2;
        }
        PromptingDialog prompt = new PromptingDialog(this.getShell(), (IResource[])targetProjects, this.getOverwriteLocalAndFileSystemPrompt(descriptions), Policy.bind("ReplaceWithAction.confirmOverwrite"));
        IResource[] projectsToCheckout = prompt.promptForMultiple();
        if (projectsToCheckout.length == 0) {
            return;
        }
        final IProject[] projects = new IProject[projectsToCheckout.length];
        int i3 = 0;
        while (i3 < projects.length) {
            projects[i3] = projectsToCheckout[i3].getProject();
            ++i3;
        }
        final IProjectDescription[] newDescriptions = descriptions;
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        monitor.setTaskName(Policy.bind("CheckoutAsAction.multiCheckout", new Integer(projects.length).toString()));
                        CheckoutAsAction.this.createAndOpenProjects(projects, newDescriptions, Policy.subMonitorFor(monitor, 5));
                        CheckoutAsAction.this.checkoutProjects(folders, projects, Policy.subMonitorFor(monitor, 95));
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        }, true, 1);
    }

    private void checkoutSingleProject(final ICVSRemoteFolder remoteFolder) throws InvocationTargetException, InterruptedException {
        final String remoteFolderName = remoteFolder.getName();
        final boolean[] hasProjectMetaFile = new boolean[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    remoteFolder.members(monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
                try {
                    remoteFolder.getFile(".project");
                    hasProjectMetaFile[0] = true;
                }
                catch (TeamException teamException) {
                    hasProjectMetaFile[0] = false;
                }
                if (!hasProjectMetaFile[0]) {
                    try {
                        remoteFolder.getFile(".vcm_meta");
                        hasProjectMetaFile[0] = true;
                    }
                    catch (TeamException teamException) {
                        hasProjectMetaFile[0] = false;
                    }
                }
            }
        }, true, 1);
        IProject newProject = null;
        IProjectDescription newDesc = null;
        if (hasProjectMetaFile[0]) {
            IProjectDescription[] iProjectDescriptionArray;
            newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(remoteFolderName);
            TagetLocationSelectionDialog dialog = new TagetLocationSelectionDialog(this.getShell(), Policy.bind("CheckoutAsAction.enterProjectTitle", remoteFolderName), newProject);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            String targetLocation = dialog.getTargetLocation();
            String targetName = dialog.getNewProjectName();
            if (targetLocation != null) {
                newDesc = ResourcesPlugin.getWorkspace().newProjectDescription(newProject.getName());
                newDesc.setLocation((IPath)new Path(targetLocation));
            }
            newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(targetName);
            Shell shell = this.getShell();
            IResource[] iResourceArray = new IResource[]{newProject};
            if (newDesc == null) {
                iProjectDescriptionArray = new IProjectDescription[]{};
            } else {
                IProjectDescription[] iProjectDescriptionArray2 = new IProjectDescription[1];
                iProjectDescriptionArray = iProjectDescriptionArray2;
                iProjectDescriptionArray2[0] = newDesc;
            }
            PromptingDialog prompt = new PromptingDialog(shell, iResourceArray, this.getOverwriteLocalAndFileSystemPrompt(iProjectDescriptionArray), Policy.bind("ReplaceWithAction.confirmOverwrite"));
            if (prompt.promptForMultiple().length == 0) {
                return;
            }
        } else {
            newProject = this.getNewProject(remoteFolderName);
            if (newProject == null) {
                return;
            }
        }
        final IProject project = newProject;
        final IProjectDescription desc = newDesc;
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        monitor.setTaskName(Policy.bind("CheckoutAsAction.taskname", remoteFolderName, project.getName()));
                        int used = 0;
                        if (hasProjectMetaFile[0]) {
                            used = 5;
                            CheckoutAsAction.this.createAndOpenProject(project, desc, Policy.subMonitorFor(monitor, used));
                        }
                        CheckoutAsAction.this.checkoutProjects(new ICVSRemoteFolder[]{remoteFolder}, new IProject[]{project}, Policy.subMonitorFor(monitor, 100 - used));
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_6 = null;
                monitor.done();
            }
        }, true, 1);
    }

    private void createAndOpenProjects(IProject[] projects, IProjectDescription[] descriptions, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, projects.length * 100);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IProjectDescription desc = this.findDescription(descriptions, (IResource)project);
            this.createAndOpenProject(project, desc, Policy.subMonitorFor(monitor, 100));
            ++i;
        }
        monitor.done();
    }

    private void createAndOpenProject(IProject project, IProjectDescription desc, IProgressMonitor monitor) throws CVSException {
        try {
            try {
                monitor.beginTask(null, 5);
                if (project.exists()) {
                    if (desc != null) {
                        project.move(desc, true, Policy.subMonitorFor(monitor, 3));
                    }
                } else if (desc == null) {
                    project.create(Policy.subMonitorFor(monitor, 3));
                } else {
                    project.create(desc, Policy.subMonitorFor(monitor, 3));
                }
                if (!project.isOpen()) {
                    project.open(Policy.subMonitorFor(monitor, 2));
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.done();
    }

    private void checkoutProjects(ICVSRemoteFolder[] folders, IProject[] projects, IProgressMonitor monitor) throws TeamException {
        CVSWorkspaceRoot.checkout((ICVSRemoteFolder[])folders, (IProject[])projects, (IProgressMonitor)monitor);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length > 0;
    }

    private IProject getNewProject(String suggestedName) {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        if (project == null) {
            return null;
        }
        try {
            IResource[] members = project.members();
            if (members.length == 0 || members.length == 1 && members[0].getName().equals(".project")) {
                return project;
            }
            PromptingDialog prompt = new PromptingDialog(this.getShell(), (IResource[])new IProject[]{project}, this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
            try {
                if (prompt.promptForMultiple().length == 1) {
                    return project;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
        return null;
    }

    protected String getErrorTitle() {
        return Policy.bind("CheckoutAsAction.checkoutFailed");
    }

    protected IPromptCondition getOverwriteLocalAndFileSystemPrompt(final IProjectDescription[] descriptions) {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                IProjectDescription desc = CheckoutAsAction.this.findDescription(descriptions, resource);
                if (desc != null) {
                    File localLocation = desc.getLocation().toFile();
                    return localLocation.exists();
                }
                if (resource.exists()) {
                    return true;
                }
                File localLocation = this.getFileLocation(resource);
                return localLocation.exists();
            }

            public String promptMessage(IResource resource) {
                IProjectDescription desc = CheckoutAsAction.this.findDescription(descriptions, resource);
                if (desc != null) {
                    return Policy.bind("AddToWorkspaceAction.thisExternalFileExists", desc.getLocation().toString());
                }
                if (resource.exists()) {
                    return Policy.bind("AddToWorkspaceAction.thisResourceExists", resource.getName());
                }
                File localLocation = this.getFileLocation(resource);
                return Policy.bind("AddToWorkspaceAction.thisExternalFileExists", localLocation.toString());
            }

            private File getFileLocation(IResource resource) {
                return new File(resource.getParent().getLocation().toFile(), resource.getName());
            }
        };
    }

    private IProjectDescription findDescription(IProjectDescription[] descriptions, IResource resource) {
        IProject project = resource.getProject();
        int i = 0;
        while (i < descriptions.length) {
            IProjectDescription description = descriptions[i];
            if (description.getName().equals(project.getName())) {
                return description;
            }
            ++i;
        }
        return null;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

