/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.PromptingDialog;

public class CheckoutAction
extends CVSAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ICVSRemoteFolder[] remoteFolders = this.getSelectedRemoteFolders();
        final String[][] expansions = new String[1][0];
        expansions[0] = null;
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    expansions[0] = CVSWorkspaceRoot.getExpansions((ICVSRemoteFolder[])remoteFolders, (IProgressMonitor)monitor);
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
        if (expansions[0] == null) {
            return;
        }
        HashSet<IProject> targetProjects = new HashSet<IProject>();
        int i = 0;
        while (i < expansions[0].length) {
            String string = expansions[0][i];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(string).segment(0));
            targetProjects.add(project);
            ++i;
        }
        IResource[] projects = targetProjects.toArray(new IResource[targetProjects.size()]);
        PromptingDialog prompt = new PromptingDialog(this.getShell(), projects, this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
        if (prompt.promptForMultiple().length != projects.length) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(CheckoutAction.getTaskName(remoteFolders), 100);
                        monitor.setTaskName(CheckoutAction.getTaskName(remoteFolders));
                        CVSWorkspaceRoot.checkout((ICVSRemoteFolder[])remoteFolders, null, (IProgressMonitor)Policy.subMonitorFor(monitor, 100));
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        }, true, 1);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length == 1;
    }

    protected static String getTaskName(ICVSRemoteFolder[] remoteFolders) {
        if (remoteFolders.length == 1) {
            ICVSRemoteFolder folder = remoteFolders[0];
            String label = folder.getRepositoryRelativePath();
            if (label.equals("CVSROOT/Emptydir")) {
                label = folder.getName();
            }
            return Policy.bind("AddToWorkspace.taskName1", label);
        }
        return Policy.bind("AddToWorkspace.taskNameN", new Integer(remoteFolders.length).toString());
    }

    protected IPromptCondition getOverwriteLocalAndFileSystemPrompt() {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                File localLocation = this.getFileLocation(resource);
                return resource.exists() || localLocation.exists();
            }

            public String promptMessage(IResource resource) {
                this.getFileLocation(resource);
                if (resource.exists()) {
                    return Policy.bind("AddToWorkspaceAction.thisResourceExists", resource.getName());
                }
                return Policy.bind("AddToWorkspaceAction.thisExternalFileExists", resource.getName());
            }

            private File getFileLocation(IResource resource) {
                return new File(resource.getParent().getLocation().toFile(), resource.getName());
            }
        };
    }
}

