/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CheckoutAction;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AddToWorkspaceAction
extends CheckoutAction {
    protected ICVSRemoteFolder[] getSelectedRemoteFolders() {
        ICVSRemoteFolder[] allFolders = super.getSelectedRemoteFolders();
        if (allFolders.length == 0) {
            return allFolders;
        }
        ArrayList<ICVSRemoteFolder> resources = new ArrayList<ICVSRemoteFolder>();
        int i = 0;
        while (i < allFolders.length) {
            ICVSRemoteFolder folder = allFolders[i];
            if (!Checkout.ALIAS.isElementOf((Command.Option[])folder.getLocalOptions())) {
                resources.add(folder);
            }
            ++i;
        }
        return resources.toArray(new ICVSRemoteFolder[resources.size()]);
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.checkoutSelectionIntoWorkspaceDirectory();
    }

    protected void checkoutSelectionIntoWorkspaceDirectory() throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        ICVSRemoteFolder[] folders = AddToWorkspaceAction.this.getSelectedRemoteFolders();
                        ArrayList<IProject> targetProjects = new ArrayList<IProject>();
                        HashMap<String, ICVSRemoteFolder> targetFolders = new HashMap<String, ICVSRemoteFolder>();
                        int i = 0;
                        while (i < folders.length) {
                            String name = folders[i].getName();
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                            targetFolders.put(name, folders[i]);
                            targetProjects.add(project);
                            ++i;
                        }
                        IResource[] projects = targetProjects.toArray(new IResource[targetProjects.size()]);
                        PromptingDialog prompt = new PromptingDialog(AddToWorkspaceAction.this.getShell(), projects, AddToWorkspaceAction.this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
                        projects = prompt.promptForMultiple();
                        monitor.beginTask(null, 100);
                        if (projects.length != 0) {
                            IProject[] localFolders = new IProject[projects.length];
                            ICVSRemoteFolder[] remoteFolders = new ICVSRemoteFolder[projects.length];
                            int i2 = 0;
                            while (i2 < projects.length) {
                                localFolders[i2] = (IProject)projects[i2];
                                remoteFolders[i2] = (ICVSRemoteFolder)targetFolders.get(projects[i2].getName());
                                ++i2;
                            }
                            monitor.setTaskName(CheckoutAction.getTaskName(remoteFolders));
                            CVSWorkspaceRoot.checkout((ICVSRemoteFolder[])remoteFolders, (IProject[])localFolders, (IProgressMonitor)Policy.subMonitorFor(monitor, 100));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var10_14 = null;
                monitor.done();
            }
        }, true, 1);
    }

    protected boolean isEnabled() throws TeamException {
        ICVSRemoteFolder[] resources = this.getSelectedRemoteFolders();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof ICVSRepositoryLocation) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getErrorTitle() {
        return Policy.bind("AddToWorkspaceAction.checkoutFailed");
    }
}

