/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AddAction
extends WorkspaceAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (!this.promptForAddOfIgnored()) {
            return;
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        Hashtable table = AddAction.this.getProviderMapping();
                        Set keySet = table.keySet();
                        monitor.beginTask("", keySet.size() * 1000);
                        monitor.setTaskName(Policy.bind("AddAction.adding"));
                        Iterator iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 1000);
                            CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
                            List list = (List)table.get(provider);
                            IResource[] providerResources = list.toArray(new IResource[list.size()]);
                            provider.add(providerResources, 2, subMonitor);
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var9_12 = null;
                monitor.done();
            }
        }, true, 1);
    }

    private boolean promptForAddOfIgnored() {
        IResource[] resources = this.getSelectedResources();
        boolean prompt = false;
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
            try {
                if (resource.isIgnored()) {
                    prompt = true;
                    break;
                }
            }
            catch (CVSException e) {
                this.handle((Exception)((Object)e));
            }
            ++i;
        }
        if (prompt) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("AddAction.addIgnoredTitle"), (String)Policy.bind("AddAction.addIgnoredQuestion"));
        }
        return true;
    }

    protected String getErrorTitle() {
        return Policy.bind("AddAction.addFailed");
    }

    protected boolean isEnabledForManagedResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForIgnoredResources() {
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        IResource resource = cvsResource.getIResource();
        if (resource.isLinked()) {
            return false;
        }
        return super.isEnabledForCVSResource(cvsResource);
    }
}

