/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.ui.AlternateUserValidationDialog;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.UserValidationDialog;

public class WorkbenchUserAuthenticator
implements IUserAuthenticator {
    public static boolean USE_ALTERNATE_PROMPTER = false;

    public WorkbenchUserAuthenticator() {
        IIgnoreInfo[] ignores = Team.getAllIgnores();
        boolean found = false;
        int i = 0;
        while (i < ignores.length) {
            if (ignores[i].getPattern().equals("*.notes")) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            return;
        }
        IFileTypeInfo[] types = Team.getAllTypes();
        int i2 = 0;
        while (i2 < types.length) {
            if (types[i2].getExtension().equals("notes")) {
                USE_ALTERNATE_PROMPTER = true;
                return;
            }
            ++i2;
        }
        USE_ALTERNATE_PROMPTER = false;
    }

    public void promptForUserInfo(final ICVSRepositoryLocation location, final IUserInfo userinfo, final String message) throws CVSException {
        if (!userinfo.isUsernameMutable() && USE_ALTERNATE_PROMPTER) {
            this.alternatePromptForUserInfo(userinfo);
            return;
        }
        final String[] result = new String[2];
        Display display = Display.getCurrent();
        if (display != null) {
            this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    WorkbenchUserAuthenticator.this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Policy.bind("WorkbenchUserAuthenticator.cancelled"));
        }
        if (userinfo.isUsernameMutable()) {
            userinfo.setUsername(result[0]);
        }
        userinfo.setPassword(result[1]);
    }

    private void promptForPassword(ICVSRepositoryLocation location, String username, String message, boolean userMutable, String[] result) {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        UserValidationDialog dialog = new UserValidationDialog(shell, location.getLocation(), username == null ? "" : username, message);
        dialog.setUsernameMutable(userMutable);
        dialog.open();
        shell.dispose();
        result[0] = dialog.getUsername();
        result[1] = dialog.getPassword();
    }

    private String alternatePromptForPassword(String username) {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        AlternateUserValidationDialog dialog = new AlternateUserValidationDialog(shell, username == null ? "" : username);
        dialog.setUsername(username);
        int result = dialog.open();
        shell.dispose();
        if (result == 1) {
            return null;
        }
        return dialog.getPassword();
    }

    public void alternatePromptForUserInfo(final IUserInfo userinfo) throws CVSException {
        final String[] result = new String[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.alternatePromptForPassword(userinfo.getUsername());
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this.alternatePromptForPassword(userinfo.getUsername());
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Policy.bind("WorkbenchUserAuthenticator.The_operation_was_canceled_by_the_user_1"));
        }
        userinfo.setPassword(result[0]);
    }
}

