/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagSelectionDialog
extends Dialog {
    private ICVSFolder[] folders;
    private int includeFlags;
    private CVSTag result;
    private String helpContext;
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_ALL_TAGS = 15;
    private TreeViewer tagTree;
    private Button okButton;
    private String title;
    private String message;
    private boolean recurse = true;
    private boolean showRecurse;
    private static final int SIZING_DIALOG_WIDTH = 400;
    private static final int SIZING_DIALOG_HEIGHT = 250;

    public static CVSTag getTagToCompareWith(Shell shell, IProject[] projects) {
        return TagSelectionDialog.getTagToCompareWith(shell, TagSelectionDialog.getCVSFoldersFor(projects));
    }

    public static CVSTag getTagToCompareWith(Shell shell, ICVSFolder[] folders) {
        TagSelectionDialog dialog = new TagSelectionDialog(shell, folders, Policy.bind("CompareWithTagAction.message"), Policy.bind("TagSelectionDialog.Select_a_Tag_1"), 15, false, "org.eclipse.team.cvs.ui.compare_tag_selection_dialog_context");
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getResult();
    }

    public TagSelectionDialog(Shell parentShell, IProject[] projects, String title, String message, int includeFlags, boolean showRecurse, String helpContext) {
        this(parentShell, TagSelectionDialog.getCVSFoldersFor(projects), title, message, includeFlags, showRecurse, helpContext);
    }

    private static ICVSFolder[] getCVSFoldersFor(IProject[] projects) {
        ICVSFolder[] folders = new ICVSFolder[projects.length];
        int i = 0;
        while (i < projects.length) {
            folders[i] = CVSWorkspaceRoot.getCVSFolderFor((IContainer)projects[i]);
            ++i;
        }
        return folders;
    }

    public TagSelectionDialog(Shell parentShell, ICVSFolder[] folders, String title, String message, int includeFlags, boolean showRecurse, String helpContext) {
        super(parentShell);
        this.folders = folders;
        this.title = title;
        this.message = message;
        this.includeFlags = includeFlags;
        this.showRecurse = showRecurse;
        this.helpContext = helpContext;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void create() {
        super.create();
        this.initialize();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        if (this.helpContext != null) {
            WorkbenchHelp.setHelp((Control)top, (String)this.helpContext);
        }
        Composite inner = new Composite(top, 0);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 250;
        inner.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        Label l = new Label(inner, 0);
        l.setText(this.message);
        this.tagTree = this.createTree(inner);
        this.tagTree.setInput((Object)new ProjectElement(this.folders[0], this.includeFlags));
        this.tagTree.setSorter((ViewerSorter)new ProjectElement.ProjectElementSorter());
        Runnable refresh = new Runnable(){

            public void run() {
                TagSelectionDialog.this.getShell().getDisplay().syncExec(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TagSelectionDialog.access$0(1.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ TagSelectionDialog access$0(1 var0) {
                return var0.TagSelectionDialog.this;
            }
        };
        if (this.showRecurse) {
            final Button recurseCheck = new Button(top, 32);
            recurseCheck.setText(Policy.bind("TagSelectionDialog.recurseOption"));
            recurseCheck.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TagSelectionDialog.this.recurse = recurseCheck.getSelection();
                }
            });
            recurseCheck.setSelection(true);
        }
        TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), top, this.folders, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), refresh, refresh);
        Label seperator = new Label(top, 258);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        this.updateEnablement();
        return top;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2052);
        tree.setLayoutData((Object)new GridData(1808));
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagSelectionDialog.this.updateEnablement();
            }
        });
        result.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TagSelectionDialog.this.tagTree.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof TagElement) {
                    TagSelectionDialog.this.okPressed();
                }
            }
        });
        result.setSorter((ViewerSorter)new RepositorySorter());
        return result;
    }

    public CVSTag getResult() {
        return this.result;
    }

    public boolean getRecursive() {
        return this.recurse;
    }

    protected void initialize() {
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tagTree.getSelection();
        Object o = selection.getFirstElement();
        TagElement element = (TagElement)o;
        this.result = element.getTag();
        super.okPressed();
    }

    protected void updateEnablement() {
        if (this.okButton != null) {
            IStructuredSelection selection = (IStructuredSelection)this.tagTree.getSelection();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof TagElement)) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }
}

