/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSFileElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSFolderElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSRootFolderElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagConfigurationDialog
extends Dialog {
    private TreeViewer cvsResourceTree;
    private CheckboxTableViewer cvsTagTree;
    private TreeViewer cvsDefinedTagsTree;
    private ProjectElement cvsDefinedTagsRootElement;
    private List autoRefreshFileList;
    private ICVSFolder[] roots;
    private ICVSFolder root;
    private boolean allowSettingAutoRefreshFiles = true;
    private final String ALLOWREFRESH_WIDTH_KEY = "AllowRefreshWidth";
    private final String ALLOWREFRESH_HEIGHT_KEY = "AllowRefreshHeight";
    private final String NOREFRESH_WIDTH_KEY = "NoRefreshWidth";
    private final String NOREFRESH_HEIGHT_KEY = "NoRefreshHeight";
    private Button addSelectedTagsButton;
    private Button addSelectedFilesButton;
    private Button removeFileButton;
    private Button removeTagButton;
    private IDialogSettings settings;

    public TagConfigurationDialog(Shell shell, ICVSFolder[] roots) {
        super(shell);
        this.setShellStyle(65616);
        this.roots = roots;
        this.root = roots[0];
        if (roots.length > 1) {
            this.allowSettingAutoRefreshFiles = false;
        }
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("TagConfigurationDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("TagConfigurationDialog");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.roots.length == 1) {
            newShell.setText(Policy.bind("TagConfigurationDialog.1", this.roots[0].getName()));
        } else {
            newShell.setText(Policy.bind("TagConfigurationDialog.2", Integer.toString(this.roots.length)));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite shell = new Composite(parent, 0);
        GridData data = new GridData(1808);
        shell.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        shell.setLayout((Layout)gridLayout);
        Composite comp = new Composite(shell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label cvsResourceTreeLabel = new Label(comp, 0);
        cvsResourceTreeLabel.setText(Policy.bind("TagConfigurationDialog.5"));
        data = new GridData();
        data.horizontalSpan = 1;
        cvsResourceTreeLabel.setLayoutData((Object)data);
        Tree tree = new Tree(comp, 2050);
        this.cvsResourceTree = new TreeViewer(tree);
        this.cvsResourceTree.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.cvsResourceTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 1;
        this.cvsResourceTree.getTree().setLayoutData((Object)data);
        if (this.roots.length == 1) {
            this.cvsResourceTree.setInput((Object)new CVSFolderElement(this.roots[0], false));
        } else {
            this.cvsResourceTree.setInput((Object)new CVSRootFolderElement(this.roots));
        }
        this.cvsResourceTree.setSorter((ViewerSorter)new FileSorter());
        this.cvsResourceTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateShownTags();
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        comp = new Composite(shell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label cvsTagTreeLabel = new Label(comp, 0);
        cvsTagTreeLabel.setText(Policy.bind("TagConfigurationDialog.6"));
        data = new GridData();
        data.horizontalSpan = 1;
        cvsTagTreeLabel.setLayoutData((Object)data);
        final Table table = new Table(comp, 68386);
        data = new GridData(1808);
        data.heightHint = 150;
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        this.cvsTagTree = new CheckboxTableViewer(table);
        this.cvsTagTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.cvsTagTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.cvsTagTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        Composite selectComp = new Composite(comp, 0);
        GridLayout selectLayout = new GridLayout(2, true);
        selectLayout.marginWidth = 0;
        selectLayout.marginHeight = 0;
        selectComp.setLayout((Layout)selectLayout);
        selectComp.setLayoutData((Object)new GridData(768));
        Button selectAllButton = new Button(selectComp, 8);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText(Policy.bind("ReleaseCommentDialog.selectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nItems = table.getItemCount();
                int j = 0;
                while (j < nItems) {
                    table.getItem(j).setChecked(true);
                    ++j;
                }
            }
        });
        Button deselectAllButton = new Button(selectComp, 8);
        deselectAllButton.setLayoutData((Object)new GridData(768));
        deselectAllButton.setText(Policy.bind("ReleaseCommentDialog.deselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nItems = table.getItemCount();
                int j = 0;
                while (j < nItems) {
                    table.getItem(j).setChecked(false);
                    ++j;
                }
            }
        });
        this.cvsTagTree.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof TagElement) || !(e2 instanceof TagElement)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = ((TagElement)e1).getTag();
                CVSTag tag2 = ((TagElement)e2).getTag();
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type1 - type2;
                }
                return -tag1.compareTo(tag2);
            }
        });
        Composite rememberedTags = new Composite(shell, 0);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        rememberedTags.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rememberedTags.setLayout((Layout)gridLayout);
        Label rememberedTagsLabel = new Label(rememberedTags, 0);
        rememberedTagsLabel.setText(Policy.bind("TagConfigurationDialog.7"));
        data = new GridData();
        data.horizontalSpan = 2;
        rememberedTagsLabel.setLayoutData((Object)data);
        tree = new Tree(rememberedTags, 2050);
        this.cvsDefinedTagsTree = new TreeViewer(tree);
        this.cvsDefinedTagsTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.cvsDefinedTagsTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.cvsDefinedTagsTree.getTree().setLayoutData((Object)data);
        this.cvsDefinedTagsRootElement = new ProjectElement(this.roots[0], 12);
        this.cvsDefinedTagsRootElement.getBranches().add(CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(this.root, 1));
        this.cvsDefinedTagsRootElement.getVersions().add(CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(this.root, 2));
        this.cvsDefinedTagsTree.setInput((Object)this.cvsDefinedTagsRootElement);
        this.cvsDefinedTagsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagConfigurationDialog.this.updateEnablements();
            }
        });
        this.cvsDefinedTagsTree.setSorter((ViewerSorter)new ProjectElement.ProjectElementSorter());
        Composite buttonComposite = new Composite(rememberedTags, 0);
        data = new GridData();
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        this.addSelectedTagsButton = new Button(buttonComposite, 8);
        this.addSelectedTagsButton.setText(Policy.bind("TagConfigurationDialog.8"));
        data = this.getStandardButtonData(this.addSelectedTagsButton);
        data.horizontalAlignment = 4;
        this.addSelectedTagsButton.setLayoutData((Object)data);
        this.addSelectedTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.rememberCheckedTags();
            }
        });
        this.removeTagButton = new Button(buttonComposite, 8);
        this.removeTagButton.setText(Policy.bind("TagConfigurationDialog.9"));
        data = this.getStandardButtonData(this.removeTagButton);
        data.horizontalAlignment = 4;
        this.removeTagButton.setLayoutData((Object)data);
        this.removeTagButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.deleteSelected();
            }
        });
        Button removeAllTags = new Button(buttonComposite, 8);
        removeAllTags.setText(Policy.bind("TagConfigurationDialog.10"));
        data = this.getStandardButtonData(removeAllTags);
        data.horizontalAlignment = 4;
        removeAllTags.setLayoutData((Object)data);
        removeAllTags.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog.this.removeAllKnownTags();
            }
        });
        if (this.allowSettingAutoRefreshFiles) {
            Label explanation = new Label(rememberedTags, 64);
            explanation.setText(Policy.bind("TagConfigurationDialog.11"));
            data = new GridData();
            data.horizontalSpan = 2;
            explanation.setLayoutData((Object)data);
            this.autoRefreshFileList = new List(rememberedTags, 2050);
            data = new GridData();
            data.heightHint = 45;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.autoRefreshFileList.setLayoutData((Object)data);
            try {
                this.autoRefreshFileList.setItems(CVSUIPlugin.getPlugin().getRepositoryManager().getAutoRefreshFiles(this.roots[0]));
            }
            catch (CVSException e) {
                this.autoRefreshFileList.setItems(new String[0]);
                CVSUIPlugin.log((TeamException)((Object)e));
            }
            this.autoRefreshFileList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TagConfigurationDialog.this.updateEnablements();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TagConfigurationDialog.this.updateEnablements();
                }
            });
            Composite buttonComposite2 = new Composite(rememberedTags, 0);
            data = new GridData();
            data.verticalAlignment = 1;
            buttonComposite2.setLayoutData((Object)data);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonComposite2.setLayout((Layout)gridLayout);
            this.addSelectedFilesButton = new Button(buttonComposite2, 8);
            this.addSelectedFilesButton.setText(Policy.bind("TagConfigurationDialog.12"));
            data = this.getStandardButtonData(this.addSelectedFilesButton);
            data.horizontalAlignment = 4;
            this.addSelectedFilesButton.setLayoutData((Object)data);
            this.addSelectedFilesButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TagConfigurationDialog.this.addSelectionToAutoRefreshList();
                }
            });
            this.removeFileButton = new Button(buttonComposite2, 8);
            this.removeFileButton.setText(Policy.bind("TagConfigurationDialog.13"));
            data = this.getStandardButtonData(this.removeFileButton);
            data.horizontalAlignment = 4;
            this.removeFileButton.setLayoutData((Object)data);
            this.removeFileButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String[] selected = TagConfigurationDialog.this.autoRefreshFileList.getSelection();
                    int i = 0;
                    while (i < selected.length) {
                        TagConfigurationDialog.this.autoRefreshFileList.remove(selected[i]);
                        TagConfigurationDialog.this.autoRefreshFileList.setFocus();
                        ++i;
                    }
                }
            });
            WorkbenchHelp.setHelp((Control)this.autoRefreshFileList, (String)"org.eclipse.team.cvs.ui.tag_configuration_refreshlist");
        }
        Label seperator = new Label(shell, 258);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.team.cvs.ui.tag_configuration_overview");
        this.updateEnablements();
        return shell;
    }

    private void updateShownTags() {
        final CVSFileElement[] filesSelection = this.getSelectedFiles();
        final HashSet tags = new HashSet();
        if (filesSelection.length != 0) {
            try {
                CVSUIPlugin.runWithProgress(this.getShell(), true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Policy.bind("TagConfigurationDialog.22"), filesSelection.length);
                        try {
                            try {
                                int i = 0;
                                while (i < filesSelection.length) {
                                    ICVSFile file = filesSelection[i].getCVSFile();
                                    tags.addAll(Arrays.asList(TagConfigurationDialog.this.getTagsFor(file, Policy.subMonitorFor(monitor, 1))));
                                    ++i;
                                }
                            }
                            catch (TeamException teamException) {}
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            monitor.done();
                            throw throwable;
                        }
                        Object var4_6 = null;
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            this.cvsTagTree.getTable().removeAll();
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                CVSTag tag = (CVSTag)it.next();
                ArrayList<CVSTag> knownTags = new ArrayList<CVSTag>();
                knownTags.addAll(Arrays.asList(this.cvsDefinedTagsRootElement.getBranches().getTags()));
                knownTags.addAll(Arrays.asList(this.cvsDefinedTagsRootElement.getVersions().getTags()));
                if (knownTags.contains(tag)) continue;
                TagElement tagElem = new TagElement(tag);
                this.cvsTagTree.add((Object)tagElem);
                this.cvsTagTree.setChecked((Object)tagElem, true);
            }
        }
    }

    private CVSFileElement[] getSelectedFiles() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsResourceTree.getSelection();
        if (!selection.isEmpty()) {
            ArrayList filesSelection = new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof CVSFileElement)) continue;
                filesSelection.add(o);
            }
            return filesSelection.toArray(new CVSFileElement[filesSelection.size()]);
        }
        return new CVSFileElement[0];
    }

    private void addSelectionToAutoRefreshList() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsResourceTree.getSelection();
        if (!selection.isEmpty()) {
            ArrayList filesSelection = new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof CVSFileElement)) continue;
                filesSelection.add(o);
            }
            if (!filesSelection.isEmpty()) {
                it = filesSelection.iterator();
                while (it.hasNext()) {
                    try {
                        ICVSFile file = ((CVSFileElement)it.next()).getCVSFile();
                        ICVSFolder fileParent = file.getParent();
                        String filePath = new Path(fileParent.getFolderSyncInfo().getRepository()).append(file.getRelativePath(fileParent)).toString();
                        if (this.autoRefreshFileList.indexOf(filePath) != -1) continue;
                        this.autoRefreshFileList.add(filePath);
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.openError(this.getShell(), null, null, e);
                    }
                }
            }
        }
    }

    private CVSTag[] getTagsFor(ICVSFile file, IProgressMonitor monitor) throws TeamException {
        HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
        ILogEntry[] entries = file.getLogEntries(monitor);
        int j = 0;
        while (j < entries.length) {
            CVSTag[] tags = entries[j].getTags();
            int k = 0;
            while (k < tags.length) {
                tagSet.add(tags[k]);
                ++k;
            }
            ++j;
        }
        return tagSet.toArray(new CVSTag[tagSet.size()]);
    }

    private void rememberCheckedTags() {
        Object[] checked = this.cvsTagTree.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            CVSTag tag = ((TagElement)checked[i]).getTag();
            if (tag.getType() == 1) {
                this.cvsDefinedTagsRootElement.getBranches().add(new CVSTag[]{tag});
            } else {
                this.cvsDefinedTagsRootElement.getVersions().add(new CVSTag[]{tag});
            }
            ++i;
        }
        this.cvsDefinedTagsTree.refresh();
    }

    private void deleteSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsDefinedTagsTree.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof TagElement)) continue;
                CVSTag tag = ((TagElement)o).getTag();
                if (tag.getType() == 1) {
                    this.cvsDefinedTagsRootElement.getBranches().remove(tag);
                    continue;
                }
                if (tag.getType() != 2) continue;
                this.cvsDefinedTagsRootElement.getVersions().remove(tag);
            }
        }
        this.cvsDefinedTagsTree.refresh();
        this.cvsDefinedTagsTree.getTree().setFocus();
    }

    private boolean isTagSelectedInKnownTagTree() {
        IStructuredSelection selection = (IStructuredSelection)this.cvsDefinedTagsTree.getSelection();
        if (!selection.isEmpty()) {
            new ArrayList();
            new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof TagElement)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeAllKnownTags() {
        this.cvsDefinedTagsRootElement.getBranches().removeAll();
        this.cvsDefinedTagsRootElement.getVersions().removeAll();
        this.cvsDefinedTagsTree.refresh();
    }

    private void updateEnablements() {
        Object[] checked = this.cvsTagTree.getCheckedElements();
        this.addSelectedTagsButton.setEnabled(checked.length != 0);
        this.removeTagButton.setEnabled(this.isTagSelectedInKnownTagTree());
        if (this.allowSettingAutoRefreshFiles) {
            this.addSelectedFilesButton.setEnabled(this.getSelectedFiles().length != 0);
            this.removeFileButton.setEnabled(this.autoRefreshFileList.getSelection().length != 0);
        }
    }

    protected void okPressed() {
        try {
            RepositoryManager manager;
            if (this.allowSettingAutoRefreshFiles) {
                manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                manager.setAutoRefreshFiles(this.root, this.autoRefreshFileList.getItems());
            }
            manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            manager.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CVSTag[] branches = TagConfigurationDialog.this.cvsDefinedTagsRootElement.getBranches().getTags();
                    CVSTag[] versions = TagConfigurationDialog.this.cvsDefinedTagsRootElement.getVersions().getTags();
                    try {
                        int i = 0;
                        while (i < TagConfigurationDialog.this.roots.length) {
                            CVSTag[] oldTags = manager.getKnownTags(TagConfigurationDialog.this.roots[i]);
                            manager.removeTags(TagConfigurationDialog.this.roots[i], oldTags);
                            if (branches.length > 0) {
                                manager.addTags((ICVSResource)TagConfigurationDialog.this.roots[i], branches);
                            }
                            if (versions.length > 0) {
                                manager.addTags((ICVSResource)TagConfigurationDialog.this.roots[i], versions);
                            }
                            ++i;
                        }
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
            super.okPressed();
        }
        catch (CVSException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static Button createTagRefreshButton(final Shell shell, Composite composite, String title, final ICVSFolder folder, final Runnable runnable) {
        Button refreshButton = new Button(composite, 8);
        refreshButton.setText(title);
        refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    CVSUIPlugin.runWithProgress(shell, true, new IRunnableWithProgress(folder, runnable){
                        private final /* synthetic */ ICVSFolder val$folder;
                        private final /* synthetic */ Runnable val$runnable;
                        {
                            this.val$folder = iCVSFolder;
                            this.val$runnable = runnable;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                CVSUIPlugin.getPlugin().getRepositoryManager().refreshDefinedTags(this.val$folder, false, true, monitor);
                                this.val$runnable.run();
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError(shell, Policy.bind("TagConfigurationDialog.14"), null, e);
                }
            }
        });
        TagConfigurationDialog.updateEnablementOnRefreshButton(refreshButton, folder);
        return refreshButton;
    }

    public static void createTagDefinitionButtons(final Shell shell, Composite composite, final ICVSFolder[] folders, int hHint, int wHint, Runnable afterRefresh, final Runnable afterConfigure) {
        Composite buttonComp = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        buttonComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        final Button refreshButton = TagConfigurationDialog.createTagRefreshButton(shell, buttonComp, Policy.bind("TagConfigurationDialog.20"), folders[0], afterRefresh);
        data = new GridData();
        if (hHint != 0 && wHint != 0) {
            data.heightHint = hHint;
            int widthHint = wHint;
            data.widthHint = Math.max(widthHint, refreshButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        }
        data.horizontalAlignment = 3;
        data.horizontalSpan = 1;
        refreshButton.setLayoutData((Object)data);
        Button addButton = new Button(buttonComp, 8);
        addButton.setText(Policy.bind("TagConfigurationDialog.21"));
        data = new GridData();
        if (hHint != 0 && wHint != 0) {
            data.heightHint = hHint;
            int widthHint = wHint;
            data.widthHint = Math.max(widthHint, addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        }
        data.horizontalAlignment = 3;
        data.horizontalSpan = 1;
        addButton.setLayoutData((Object)data);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog d = new TagConfigurationDialog(shell, folders);
                d.open();
                TagConfigurationDialog.updateEnablementOnRefreshButton(refreshButton, folders[0]);
                afterConfigure.run();
            }
        });
        WorkbenchHelp.setHelp((Control)refreshButton, (String)"org.eclipse.team.cvs.ui.tag_configuration_refreshaction");
        WorkbenchHelp.setHelp((Control)addButton, (String)"org.eclipse.team.cvs.ui.tag_configuration_overview");
    }

    private static void updateEnablementOnRefreshButton(Button refreshButton, ICVSFolder project) {
        try {
            String[] files = CVSUIPlugin.getPlugin().getRepositoryManager().getAutoRefreshFiles(project);
            refreshButton.setEnabled(files.length != 0);
        }
        catch (CVSException e) {
            refreshButton.setEnabled(false);
            CVSUIPlugin.log((TeamException)((Object)e));
        }
    }

    protected Point getInitialSize() {
        int width;
        int height;
        if (this.allowSettingAutoRefreshFiles) {
            try {
                height = this.settings.getInt("AllowRefreshHeight");
                width = this.settings.getInt("AllowRefreshWidth");
            }
            catch (NumberFormatException numberFormatException) {
                return super.getInitialSize();
            }
        }
        try {
            height = this.settings.getInt("NoRefreshHeight");
            width = this.settings.getInt("NoRefreshWidth");
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
        return new Point(width, height);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private GridData getStandardButtonData(Button button) {
        GridData data = new GridData();
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return data;
    }

    public boolean close() {
        Rectangle bounds = this.getShell().getBounds();
        if (this.allowSettingAutoRefreshFiles) {
            this.settings.put("AllowRefreshHeight", bounds.height);
            this.settings.put("AllowRefreshWidth", bounds.width);
        } else {
            this.settings.put("NoRefreshHeight", bounds.height);
            this.settings.put("NoRefreshWidth", bounds.width);
        }
        return super.close();
    }

    class FileSorter
    extends ViewerSorter {
        FileSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean oneIsFile = e1 instanceof CVSFileElement;
            boolean twoIsFile = e2 instanceof CVSFileElement;
            if (oneIsFile != twoIsFile) {
                return oneIsFile ? 1 : -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

