/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.WorkingSetSelectionArea;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

public class SynchronizeProjectsDialog
extends Dialog {
    private Button outgoingChangesButton;
    private static final String SYNC_OUTGOING_CHANGES = "SyncOutgoingChanges";
    IWorkingSet workingSet;
    boolean syncOutgoingChanges;
    private IDialogSettings settings;
    private WorkingSetSelectionArea workingSetArea;

    public SynchronizeProjectsDialog(Shell parentShell) {
        super(parentShell);
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("SynchronizeProjectsDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("SynchronizeProjectsDialog");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.workingSetArea = new WorkingSetSelectionArea(this, Policy.bind("SynchronizeProjectsDialog.allSharedProjects"), Policy.bind("SynchronizeProjectsDialog.sharedWorkingSetProjects"), this.settings);
        this.setWorkingSet(this.workingSet);
        this.workingSetArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SynchronizeProjectsDialog.this.workingSet = (IWorkingSet)event.getNewValue();
            }
        });
        this.workingSetArea.createArea(composite);
        this.outgoingChangesButton = this.createCheckbox(composite, Policy.bind("SynchronizeProjectsDialog.syncOutgoingChanges"));
        this.outgoingChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeProjectsDialog.this.syncOutgoingChanges = SynchronizeProjectsDialog.this.outgoingChangesButton.getSelection();
            }
        });
        if (this.settings != null) {
            this.syncOutgoingChanges = this.settings.getBoolean(SYNC_OUTGOING_CHANGES);
            this.outgoingChangesButton.setSelection(this.syncOutgoingChanges);
        }
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.sychronize_projects_dialog_context");
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Policy.bind("SynchronizeProjectsDialog.title"));
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    protected void okPressed() {
        this.workingSet = this.workingSetArea.getWorkingSet();
        if (this.workingSet != null) {
            this.workingSetArea.useSelectedWorkingSet();
        }
        if (this.settings != null) {
            this.settings.put(SYNC_OUTGOING_CHANGES, this.outgoingChangesButton.getSelection());
        }
        super.okPressed();
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        if (this.workingSetArea != null) {
            this.workingSetArea.setWorkingSet(workingSet);
        }
    }

    protected Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setFont(composite.getFont());
        return label;
    }

    public boolean isSyncOutgoingChanges() {
        return this.syncOutgoingChanges;
    }
}

