/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ccvs.ui.DialogArea;
import org.eclipse.team.internal.ccvs.ui.Policy;

public class ListSelectionArea
extends DialogArea {
    private Object inputElement;
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private String message;
    private List initialSelections;
    private CheckboxTableViewer listViewer;
    private Object[] previousCheckedElements;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    public static final String LIST_SELECTION = "ListSelection";

    public ListSelectionArea(Dialog parentDialog, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentDialog, null);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.message = message;
        this.initialSelections = new ArrayList();
    }

    public Control createArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        if (this.message != null) {
            this.createWrappingLabel(composite, this.message, 1);
        }
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.getControl().setFont(composite.getFont());
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checkedElements = ListSelectionArea.this.getViewer().getCheckedElements();
                ListSelectionArea.this.firePropertyChangeChange(ListSelectionArea.LIST_SELECTION, ListSelectionArea.this.previousCheckedElements, checkedElements);
                ListSelectionArea.this.previousCheckedElements = checkedElements;
            }
        });
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        return composite;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        buttonComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, Policy.bind("ListSelectionArea.selectAll"), 256);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionArea.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, Policy.bind("ListSelectionArea.deselectAll"), 256);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListSelectionArea.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.initialSelections.add(selectedElements[i]);
            ++i;
        }
    }

    public void setInitialElementSelections(List selectedElements) {
        this.initialSelections = selectedElements;
    }

    public CheckboxTableViewer getViewer() {
        return this.listViewer;
    }
}

