/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryDropAdapter;
import org.eclipse.team.internal.ccvs.ui.HistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.SimpleContentProvider;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.OpenLogEntryAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class HistoryView
extends ViewPart {
    private IFile file;
    private ILogEntry[] entries;
    private CVSTeamProvider provider;
    private HistoryTableProvider historyTableProvider;
    private TableViewer tableViewer;
    private TextViewer textViewer;
    private TableViewer tagViewer;
    private OpenLogEntryAction openAction;
    private IAction toggleTextAction;
    private IAction toggleListAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private Action tagWithExistingAction;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private Image branchImage;
    private Image versionImage;
    private ILogEntry currentSelection;
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.HistoryView";
    static /* synthetic */ Class class$0;

    protected void contributeActions() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(Policy.bind("HistoryView.refreshLabel"), plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                HistoryView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Policy.bind("HistoryView.refresh"));
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/refresh.gif"));
        this.openAction = new OpenLogEntryAction();
        this.tableViewer.getTable().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                HistoryView.this.openAction.selectionChanged(null, HistoryView.this.tableViewer.getSelection());
                HistoryView.this.openAction.run(null);
            }
        });
        this.getContentsAction = this.getContextMenuAction(Policy.bind("HistoryView.getContentsAction"), new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = HistoryView.this.currentSelection.getRemoteFile();
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (HistoryView.this.confirmOverwrite()) {
                            InputStream in = remoteFile.getContents((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            HistoryView.this.file.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var4_7 = null;
                monitor.done();
            }
        });
        WorkbenchHelp.setHelp((IAction)this.getContentsAction, (String)"org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(Policy.bind("HistoryView.getRevisionAction"), new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = HistoryView.this.currentSelection.getRemoteFile();
                try {
                    if (HistoryView.this.confirmOverwrite()) {
                        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)HistoryView.this.file.getProject());
                        CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                        if (CVSAction.checkForMixingTags(HistoryView.this.getSite().getShell(), new IResource[]{HistoryView.this.file}, revisionTag)) {
                            provider.update(new IResource[]{HistoryView.this.file}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag, true, monitor);
                            HistoryView.this.historyTableProvider.setFile((ICVSFile)remoteFile);
                            HistoryView.this.tableViewer.refresh();
                        }
                    }
                }
                catch (TeamException e) {
                    throw new CoreException(e.getStatus());
                }
            }
        });
        WorkbenchHelp.setHelp((IAction)this.getRevisionAction, (String)"org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    if (!this.selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        Iterator elements = this.selection.iterator();
                        while (elements.hasNext()) {
                            Object adapter;
                            Object next = elements.next();
                            if (next instanceof ILogEntry) {
                                logEntrieFiles.add(((ILogEntry)next).getRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable)) continue;
                            IAdaptable a = (IAdaptable)next;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(Policy.bind("HistoryView.tagWithExistingAction"), new IWorkspaceRunnable((IActionDelegate)tagActionDelegate){
            private final /* synthetic */ IActionDelegate val$tagActionDelegate;
            {
                this.val$tagActionDelegate = iActionDelegate;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                this.val$tagActionDelegate.selectionChanged((IAction)HistoryView.this.tagWithExistingAction, HistoryView.this.tableViewer.getSelection());
                this.val$tagActionDelegate.run((IAction)HistoryView.this.tagWithExistingAction);
                HistoryView.this.refresh();
            }
        });
        WorkbenchHelp.setHelp((IAction)this.getRevisionAction, (String)"org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.toggleTextAction = new Action(Policy.bind("HistoryView.showComment")){

            public void run() {
                HistoryView.this.setViewerVisibility();
                store.setValue("pref_show_comments", HistoryView.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean("pref_show_comments"));
        WorkbenchHelp.setHelp((IAction)this.toggleTextAction, (String)"org.eclipse.team.cvs.ui.show_comment_in_history_action_context");
        this.toggleListAction = new Action(Policy.bind("HistoryView.showTags")){

            public void run() {
                HistoryView.this.setViewerVisibility();
                store.setValue("pref_show_tags", HistoryView.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean("pref_show_tags"));
        WorkbenchHelp.setHelp((IAction)this.toggleListAction, (String)"org.eclipse.team.cvs.ui.show_tag_in_history_action_context");
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                HistoryView.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add(this.toggleTextAction);
        actionBarsMenu.add(this.toggleListAction);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.refreshAction);
        tbm.update(false);
        this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
        this.copyAction.setText(Policy.bind("HistoryView.copy"));
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
        this.selectAllAction.setText(Policy.bind("HistoryView.selectAll"));
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
        actionBars.updateActionBars();
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                HistoryView.this.fillTextMenu(menuMgr);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        if (showText && showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (showText) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.sashForm.setMaximizedControl(this.tableViewer.getControl());
        }
    }

    public void createPartControl(Composite parent) {
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.tableViewer = this.createTable((Composite)this.sashForm);
        this.innerSashForm = new SashForm((Composite)this.sashForm, 256);
        this.tagViewer = this.createTagTable((Composite)this.innerSashForm);
        this.textViewer = this.createText((Composite)this.innerSashForm);
        this.sashForm.setWeights(new int[]{70, 30});
        this.innerSashForm.setWeights(new int[]{50, 50});
        this.contributeActions();
        this.setViewerVisibility();
        WorkbenchHelp.setHelp((Control)this.sashForm, (String)"org.eclipse.team.cvs.ui.resource_history_view_context");
        this.initDragAndDrop();
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    protected TableViewer createTable(Composite parent) {
        this.historyTableProvider = new HistoryTableProvider();
        TableViewer viewer = this.historyTableProvider.createTable(parent);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (HistoryView.this.entries != null) {
                    return HistoryView.this.entries;
                }
                if (!(inputElement instanceof ICVSRemoteFile)) {
                    return null;
                }
                ICVSRemoteFile remoteFile = (ICVSRemoteFile)inputElement;
                Object[][] result = new Object[1][];
                try {
                    new ProgressMonitorDialog(HistoryView.this.getViewer().getTable().getShell()).run(true, true, new IRunnableWithProgress(this, remoteFile, result){
                        private final /* synthetic */ ICVSRemoteFile val$remoteFile;
                        private final /* synthetic */ 11 this$1;
                        private final /* synthetic */ Object[][] val$result;
                        {
                            this.this$1 = var1_1;
                            this.val$remoteFile = iCVSRemoteFile;
                            this.val$result = objectArray;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                HistoryView.access$14(11.access$0(this.this$1), this.val$remoteFile.getLogEntries(monitor));
                                this.val$result[0] = HistoryView.access$13(11.access$0(this.this$1));
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    result[0] = new Object[0];
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError(HistoryView.this.getViewSite().getShell(), null, null, e);
                    result[0] = new Object[0];
                }
                return result[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                HistoryView.this.entries = null;
            }

            static /* synthetic */ HistoryView access$0(11 var0) {
                return var0.HistoryView.this;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    HistoryView.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryView.this.tagViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    HistoryView.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryView.this.tagViewer.setInput(null);
                    return;
                }
                ILogEntry entry = (ILogEntry)ss.getFirstElement();
                HistoryView.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                HistoryView.this.tagViewer.setInput((Object)entry.getTags());
            }
        });
        return viewer;
    }

    private TableViewer createTagTable(Composite parent) {
        Table table = new Table(parent, 68352);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (CVSTag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                CVSTag tag = (CVSTag)element;
                switch (tag.getType()) {
                    case 0: 
                    case 1: {
                        return HistoryView.this.branchImage;
                    }
                    case 2: {
                        return HistoryView.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((CVSTag)element).getName();
            }
        });
        result.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof CVSTag) || !(e2 instanceof CVSTag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                return super.compare(viewer, (Object)tag1, (Object)tag2);
            }
        });
        return result;
    }

    protected TextViewer createText(Composite parent) {
        TextViewer result = new TextViewer(parent, 2826);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistoryView.this.copyAction.update();
            }
        });
        return result;
    }

    public void dispose() {
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
    }

    protected TableViewer getViewer() {
        return this.tableViewer;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        this.tableViewer.addDropSupport(ops, transfers, (DropTargetListener)new HistoryDropAdapter((StructuredViewer)this.tableViewer, this));
    }

    private void fillTableMenu(IMenuManager manager) {
        ISelection sel;
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !(sel = this.tableViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            manager.add((IAction)this.getRevisionAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.tagWithExistingAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    public static HistoryView openInActivePerspective() {
        try {
            return (HistoryView)CVSUIPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void setFocus() {
        Table control;
        if (this.tableViewer != null && (control = this.tableViewer.getTable()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public void showHistory(IResource resource) {
        if (resource instanceof IFile) {
            IFile file;
            this.file = file = (IFile)resource;
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)file.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (teamProvider != null) {
                this.provider = (CVSTeamProvider)teamProvider;
                try {
                    ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
                    this.historyTableProvider.setFile((ICVSFile)remoteFile);
                    this.tableViewer.setInput((Object)remoteFile);
                    this.setTitle(Policy.bind("HistoryView.titleWithArgument", remoteFile.getName()));
                }
                catch (TeamException e) {
                    CVSUIPlugin.openError(this.getViewSite().getShell(), null, null, e);
                }
            }
            return;
        }
        this.file = null;
        this.tableViewer.setInput(null);
        this.setTitle(Policy.bind("HistoryView.title"));
    }

    public void showHistory(ICVSRemoteFile remoteFile, String currentRevision) {
        try {
            if (remoteFile == null) {
                this.tableViewer.setInput(null);
                this.setTitle(Policy.bind("HistoryView.title"));
                return;
            }
            this.file = null;
            this.historyTableProvider.setFile((ICVSFile)remoteFile);
            this.tableViewer.setInput((Object)remoteFile);
            this.setTitle(Policy.bind("HistoryView.titleWithArgument", remoteFile.getName()));
        }
        catch (CVSException e) {
            CVSUIPlugin.openError(this.getViewSite().getShell(), null, null, e);
        }
    }

    private Action getContextMenuAction(String title, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                try {
                    if (HistoryView.this.file == null) {
                        return;
                    }
                    ISelection selection = HistoryView.this.tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object o = ss.getFirstElement();
                    HistoryView.this.currentSelection = (ILogEntry)o;
                    new ProgressMonitorDialog(HistoryView.this.getViewSite().getShell()).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(action){
                        private final /* synthetic */ IWorkspaceRunnable val$action;
                        {
                            this.val$action = iWorkspaceRunnable;
                        }

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                this.val$action.run(monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError(HistoryView.this.getViewSite().getShell(), null, null, e, 12);
                }
                catch (InterruptedException interruptedException) {}
            }

            public boolean isEnabled() {
                ISelection selection = HistoryView.this.tableViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.exists()) {
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)this.file);
            try {
                if (cvsFile.isModified(null)) {
                    String title = Policy.bind("HistoryView.overwriteTitle");
                    String msg = Policy.bind("HistoryView.overwriteMsg");
                    final MessageDialog dialog = new MessageDialog(this.getViewSite().getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    this.getViewSite().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log(e.getStatus());
            }
        }
        return true;
    }

    private void refresh() {
        this.entries = null;
        BusyIndicator.showWhile((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                HistoryView.this.tableViewer.refresh();
            }
        });
    }
}

