/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.EditorsAction;

public class FileModificationValidator
implements ICVSFileModificationValidator {
    public static final IStatus OK = new Status(0, "org.eclipse.team.cvs.ui", 0, Policy.bind("ok"), null);
    private static final int HIGHJACK = 1;

    public IStatus validateEdit(IFile[] files, Object context) {
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return OK;
        }
        return this.edit(readOnlyFiles, this.getShell(context));
    }

    public IStatus validateSave(IFile file) {
        if (!this.needsCheckout(file)) {
            return OK;
        }
        return this.edit(new IFile[]{file}, (Shell)null);
    }

    public IStatus validateMoveDelete(IFile[] files, IProgressMonitor monitor) {
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return OK;
        }
        try {
            this.edit(readOnlyFiles, monitor);
            return OK;
        }
        catch (CVSException e) {
            return e.getStatus();
        }
    }

    private IFile[] getManagedReadOnlyFiles(IFile[] files) {
        ArrayList<IFile> readOnlys = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            IFile iFile = files[i];
            if (this.needsCheckout(iFile)) {
                readOnlys.add(iFile);
            }
            ++i;
        }
        return readOnlys.toArray(new IFile[readOnlys.size()]);
    }

    private boolean needsCheckout(IFile file) {
        try {
            if (file.isReadOnly()) {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                return cvsFile.isManaged();
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((TeamException)((Object)e));
        }
        return false;
    }

    private CVSTeamProvider getProvider(IFile[] files) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)files[0].getProject(), (String)CVSProviderPlugin.getTypeId());
        return provider;
    }

    private Shell getShell(Object context) {
        if (context instanceof Shell) {
            return (Shell)context;
        }
        return null;
    }

    private IStatus getStatus(InvocationTargetException e) {
        Throwable target = e.getTargetException();
        if (target instanceof TeamException) {
            return ((TeamException)target).getStatus();
        }
        if (target instanceof CoreException) {
            return ((CoreException)target).getStatus();
        }
        return new Status(4, "org.eclipse.team.cvs.ui", 0, Policy.bind("internal"), target);
    }

    private IStatus edit(final IFile[] files, Shell shell) {
        try {
            if (!this.promptToEditFiles(files, shell)) {
                return OK;
            }
        }
        catch (InvocationTargetException e) {
            return this.getStatus(e);
        }
        catch (InterruptedException interruptedException) {
            return OK;
        }
        try {
            this.run(shell, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        FileModificationValidator.this.edit(files, monitor);
                    }
                    catch (CVSException e) {
                        new InvocationTargetException(e);
                    }
                }
            });
            return OK;
        }
        catch (InvocationTargetException e) {
            return this.getStatus(e);
        }
        catch (InterruptedException interruptedException) {
            return new Status(4, "org.eclipse.team.cvs.ui", 0, Policy.bind("FileModificationValidator.vetoMessage"), null);
        }
    }

    private boolean promptToEditFiles(IFile[] files, Shell shell) throws InvocationTargetException, InterruptedException {
        if (files.length == 0) {
            return true;
        }
        EditorsAction editors = new EditorsAction(this.getProvider(files), (IResource[])files);
        if (editors.isPerformEdit()) {
            this.run(shell, editors);
            return editors.promptToEdit(shell);
        }
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            file.setReadOnly(false);
            ++i;
        }
        return false;
    }

    private void run(Shell shell, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        InvocationTargetException[] cfr_ignored_0 = new InvocationTargetException[1];
        CVSUIPlugin.runWithProgress(shell, false, runnable, 1);
    }

    private void edit(IFile[] files, IProgressMonitor monitor) throws CVSException {
        this.getProvider(files).edit((IResource[])files, false, true, 0, monitor);
    }
}

