/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConsolePreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.createLabel(composite, Policy.bind("ConsolePreferencePage.consoleColorSettings"));
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_color", Policy.bind("ConsolePreferencePage.commandColor"), composite);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_color", Policy.bind("ConsolePreferencePage.messageColor"), composite);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_color", Policy.bind("ConsolePreferencePage.errorColor"), composite);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.console_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPreferencePage((PreferencePage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    private void initializeValues() {
        this.getPreferenceStore();
        this.commandColorEditor.load();
        this.messageColorEditor.load();
        this.errorColorEditor.load();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore();
        this.commandColorEditor.store();
        this.messageColorEditor.store();
        this.errorColorEditor.store();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore();
        this.commandColorEditor.loadDefault();
        this.messageColorEditor.loadDefault();
        this.errorColorEditor.loadDefault();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }
}

