/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;

public class ConsoleDocument
extends AbstractDocument {
    public static final int COMMAND = 0;
    public static final int MESSAGE = 1;
    public static final int ERROR = 2;
    public static final int STATUS = 3;
    public static final int DELIMITER = 4;
    private int[] lineTypes = null;
    private int currentLine = 0;

    public ConsoleDocument() {
        this.setTextStore((ITextStore)new GapTextStore(512, 1024));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    public void clear() {
        this.lineTypes = null;
        this.currentLine = 0;
        this.set("");
    }

    public int getLineType(int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            if (line < this.currentLine) {
                return this.lineTypes[line];
            }
        }
        catch (BadLocationException e) {
            CVSProviderPlugin.log((TeamException)((Object)CVSException.wrapException((Exception)((Object)e))));
        }
        return 0;
    }

    public void appendConsoleLine(int type, String line) {
        if (this.lineTypes == null) {
            this.lineTypes = new int[16];
        } else if (this.currentLine >= this.lineTypes.length) {
            int[] oldLineTypes = this.lineTypes;
            this.lineTypes = new int[oldLineTypes.length * 2];
            System.arraycopy(oldLineTypes, 0, this.lineTypes, 0, oldLineTypes.length);
        }
        this.lineTypes[this.currentLine++] = type;
        try {
            this.replace(this.getLength(), 0, String.valueOf(line) + "\n");
        }
        catch (BadLocationException e) {
            CVSProviderPlugin.log((TeamException)((Object)CVSException.wrapException((Exception)((Object)e))));
        }
    }

    private int[] getCommandLines() {
        ArrayList<Integer> commandLineList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.currentLine) {
            if (this.lineTypes[i] == 0) {
                commandLineList.add(new Integer(i));
            }
            ++i;
        }
        int[] commandLines = new int[commandLineList.size()];
        int i2 = 0;
        Iterator iter = commandLineList.iterator();
        while (iter.hasNext()) {
            commandLines[i2++] = (Integer)iter.next();
        }
        return commandLines;
    }
}

