/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.util.AddDeleteMoveListener;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSPreferencesPage;
import org.eclipse.team.internal.ccvs.ui.Console;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.CVSAdapterFactory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CVSUIPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui";
    public static final String DECORATOR_ID = "org.eclipse.team.cvs.ui.decorator";
    private Hashtable imageDescriptors = new Hashtable(20);
    private static final int TIMEOUT = 2000;
    private static CVSUIPlugin plugin;
    private RepositoryManager repositoryManager;
    public static final String EDIT = "edit";
    public static final String HIGHJACK = "highjack";
    IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(TeamUI.GLOBAL_IGNORES_CHANGED)) {
                CVSLightweightDecorator.refresh();
            }
        }
    };
    public static final int PERFORM_SYNC_EXEC = 1;
    public static final int LOG_TEAM_EXCEPTIONS = 2;
    public static final int LOG_CORE_EXCEPTIONS = 4;
    public static final int LOG_OTHER_EXCEPTIONS = 8;
    public static final int LOG_NONTEAM_EXCEPTIONS = 12;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CVSUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void createImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/full/" + id);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.imageDescriptors.put(id, desc);
    }

    public static IWorkbenchPage getActivePage() {
        return TeamUIPlugin.getActivePage();
    }

    public static TeamException asTeamException(InvocationTargetException e) {
        Throwable exception = e.getTargetException();
        if (exception instanceof TeamException) {
            return (TeamException)exception;
        }
        if (exception instanceof CoreException) {
            return new TeamException(((CoreException)exception).getStatus());
        }
        return new TeamException((IStatus)new Status(4, ID, 0, Policy.bind("internal"), exception));
    }

    public static void runWithRefresh(Shell parent, IResource[] resources, IRunnableWithProgress runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        InvocationTargetException e2;
        block11: {
            boolean firstTime = true;
            while (true) {
                try {
                    runnable.run(monitor);
                    return;
                }
                catch (InvocationTargetException e2) {
                    if (!firstTime) {
                        throw e2;
                    }
                    IStatus status = null;
                    if (e2.getTargetException() instanceof CoreException) {
                        status = ((CoreException)e2.getTargetException()).getStatus();
                    } else if (e2.getTargetException() instanceof TeamException) {
                        status = ((TeamException)e2.getTargetException()).getStatus();
                    } else {
                        throw e2;
                    }
                    if (status.getCode() != 274) break block11;
                    if (!CVSUIPlugin.promptToRefresh(parent, resources, status)) break;
                    try {
                        int i = 0;
                        while (i < resources.length) {
                            resources[i].refreshLocal(2, null);
                            ++i;
                        }
                    }
                    catch (CoreException coreEx) {
                        CVSUIPlugin.log(coreEx.getStatus());
                        throw e2;
                    }
                }
                firstTime = false;
            }
            throw new InterruptedException();
        }
        throw e2;
    }

    private static boolean promptToRefresh(final Shell shell, final IResource[] resources, final IStatus status) {
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                Shell shellToUse = shell;
                if (shell == null) {
                    shellToUse = new Shell(Display.getCurrent());
                }
                String question = resources.length == 1 ? Policy.bind("CVSUIPlugin.refreshQuestion", status.getMessage(), resources[0].getFullPath().toString()) : Policy.bind("CVSUIPlugin.refreshMultipleQuestion", status.getMessage());
                result[0] = MessageDialog.openQuestion((Shell)shellToUse, (String)Policy.bind("CVSUIPlugin.refreshTitle"), (String)question);
            }
        };
        Display.getDefault().syncExec(runnable);
        return result[0];
    }

    public static void runWithProgress(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        TeamUIPlugin.runWithProgress((Shell)parent, (boolean)cancelable, (IRunnableWithProgress)runnable);
    }

    public static void runWithProgress(final Shell parent, final boolean cancelable, final IRunnableWithProgress runnable, int flags) throws InvocationTargetException, InterruptedException {
        if ((flags & 1) > 0) {
            Display display;
            final Exception[] exception = new Exception[1];
            Runnable outerRunnable = new Runnable(){

                public void run() {
                    try {
                        TeamUIPlugin.runWithProgress((Shell)parent, (boolean)cancelable, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        exception[1] = e;
                    }
                    catch (InterruptedException e) {
                        exception[1] = e;
                    }
                }
            };
            if (parent == null) {
                display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
            } else {
                display = parent.getDisplay();
            }
            display.syncExec(outerRunnable);
            if (exception[0] != null) {
                Exception e = exception[0];
                if (e instanceof InvocationTargetException) {
                    throw (InvocationTargetException)e;
                }
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                throw new InvocationTargetException(e);
            }
        } else {
            TeamUIPlugin.runWithProgress((Shell)parent, (boolean)cancelable, (IRunnableWithProgress)runnable);
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    public static CVSUIPlugin getPlugin() {
        while (plugin == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return plugin;
    }

    public synchronized RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager();
            try {
                this.repositoryManager.startup();
            }
            catch (TeamException e) {
                CVSUIPlugin.log(e.getStatus());
            }
        }
        return this.repositoryManager;
    }

    private void initializeImages() {
        URL baseURL = this.getDescriptor().getInstallURL();
        this.createImageDescriptor("obj16/repository_rep.gif", baseURL);
        this.createImageDescriptor("clcl16/refresh.gif", baseURL);
        this.createImageDescriptor("elcl16/refresh.gif", baseURL);
        this.createImageDescriptor("dlcl16/refresh.gif", baseURL);
        this.createImageDescriptor("clcl16/collapseall.gif", baseURL);
        this.createImageDescriptor("elcl16/collapseall.gif", baseURL);
        this.createImageDescriptor("wizards/newlocation_wiz.gif", baseURL);
        this.createImageDescriptor("obj16/tag.gif", baseURL);
        this.createImageDescriptor("obj16/module_rep.gif", baseURL);
        this.createImageDescriptor("clcl16/clear_co.gif", baseURL);
        this.createImageDescriptor("elcl16/clear_co.gif", baseURL);
        this.createImageDescriptor("dlcl16/clear_co.gif", baseURL);
        this.createImageDescriptor("obj16/branches_rep.gif", baseURL);
        this.createImageDescriptor("obj16/versions_rep.gif", baseURL);
        this.createImageDescriptor("obj16/prjversions_rep.gif", baseURL);
        this.createImageDescriptor("wizban/mergestream_wizban.gif", baseURL);
        this.createImageDescriptor("wizban/newconnect_wizban.gif", baseURL);
        this.createImageDescriptor("wizban/createpatch_wizban.gif", baseURL);
        this.createImageDescriptor("wizban/keywordsub_wizban.gif", baseURL);
        this.createImageDescriptor("wizban/newlocation_wizban.gif", baseURL);
        this.createImageDescriptor("ovr16/confauto_ov.gif", baseURL);
        this.createImageDescriptor("ovr16/question_ov.gif", baseURL);
        this.createImageDescriptor("ovr16/merged_ov.gif", baseURL);
        this.createImageDescriptor("ovr16/edited_ov.gif", baseURL);
        this.createImageDescriptor("ovr16/no_remotedir_ov.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph1.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph2.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph3.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph4.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph5.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph6.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph7.gif", baseURL);
        this.createImageDescriptor("glyphs/glyph8.gif", baseURL);
    }

    public static void log(IStatus status) {
        CVSUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(TeamException e) {
        CVSUIPlugin.getPlugin().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ID, 0, Policy.bind("simpleInternal"), (Throwable)e));
    }

    public static IStatus openError(Shell shell, String title, String message, Throwable exception) {
        return CVSUIPlugin.openError(shell, title, message, exception, 8);
    }

    public static IStatus openError(Shell providedShell, String title, String message, Throwable exception, int flags) {
        if (exception instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)exception).getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            return CVSUIPlugin.openError(providedShell, title, message, target, flags);
        }
        IStatus status = null;
        boolean log = false;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
            log = (flags & 4) > 0;
        } else if (exception instanceof TeamException) {
            status = ((TeamException)exception).getStatus();
            log = (flags & 2) > 0;
        } else {
            if (exception instanceof InterruptedException) {
                return new CVSStatus(0, Policy.bind("ok"));
            }
            if (exception != null) {
                status = new CVSStatus(4, Policy.bind("internal"), exception);
                boolean bl = log = (flags & 8) > 0;
                if (title == null) {
                    title = Policy.bind("SimpleInternal");
                }
            }
        }
        if (status.getCode() == 75) {
            message = Policy.bind("buildError");
            log = true;
        }
        if (status.isMultiStatus() && status.getChildren().length == 1) {
            status = status.getChildren()[0];
        }
        if (status.isOK()) {
            return status;
        }
        if (log) {
            CVSUIPlugin.log(status);
        }
        final String displayTitle = title;
        final String displayMessage = message;
        final IStatus displayStatus = status;
        IOpenableInShell openable = new IOpenableInShell(){

            public void open(Shell shell) {
                if (displayStatus.getSeverity() == 1 && !displayStatus.isMultiStatus()) {
                    MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)displayStatus.getMessage());
                } else {
                    ErrorDialog.openError((Shell)shell, (String)displayTitle, (String)displayMessage, (IStatus)displayStatus);
                }
            }
        };
        CVSUIPlugin.openDialog(providedShell, openable, flags);
        return status;
    }

    public static void openDialog(Shell providedShell, final IOpenableInShell openable, int flags) {
        IWorkbenchWindow window;
        if (providedShell == null && (window = CVSUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow()) != null) {
            providedShell = window.getShell();
            flags |= 1;
        }
        final Shell shell = providedShell;
        Runnable outerRunnable = new Runnable(){

            public void run() {
                Shell displayShell;
                if (shell == null) {
                    Display display = Display.getCurrent();
                    displayShell = new Shell(display);
                } else {
                    displayShell = shell;
                }
                openable.open(displayShell);
                if (shell == null) {
                    displayShell.dispose();
                }
            }
        };
        if (shell == null || (flags & 1) > 0) {
            Display display;
            if (shell == null) {
                display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
            } else {
                display = shell.getDisplay();
            }
            display.syncExec(outerRunnable);
        } else {
            outerRunnable.run();
        }
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences corePrefs = CVSProviderPlugin.getPlugin().getPluginPreferences();
        store.setDefault("pref_repositories_are_binary", false);
        store.setDefault("pref_show_comments", true);
        store.setDefault("pref_show_tags", true);
        store.setDefault("pref_prune_empty_directories", true);
        store.setDefault("pref_timeout", 60);
        store.setDefault("pref_consider_contents", false);
        store.setDefault("pref_show_markers", true);
        store.setDefault("pref_compression_level", 0);
        store.setDefault("pref_text_ksubst", CVSProviderPlugin.DEFAULT_TEXT_KSUBST_OPTION.toMode());
        store.setDefault("pref_replace_unmanaged", true);
        store.setDefault("pref_cvs_rsh", "ssh");
        store.setDefault("pref_cvs_rsh_parameters", "{host} -l {user}");
        store.setDefault("pref_cvs_server", "cvs");
        store.setDefault("pref_prompt_on_change_granularity", true);
        store.setDefault("pref_determine_server_version", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_command_color", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_message_color", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_error_color", (RGB)new RGB(255, 0, 0));
        store.setDefault("pref_filetext_decoration", "{dirty_flag}{name}  {revision} {tag} ({keyword})");
        store.setDefault("pref_foldertext_decoration", "{dirty_flag}{name}  {tag}");
        store.setDefault("pref_projecttext_decoration", "{dirty_flag}{name}  {tag} [{host}]");
        store.setDefault("pref_added_flag", "*");
        store.setDefault("pref_dirty_flag", ">");
        store.setDefault("pref_show_added", true);
        store.setDefault("pref_show_hasremote", true);
        store.setDefault("pref_show_overlaydirty", false);
        store.setDefault("pref_show_newresource", true);
        store.setDefault("pref_calculate_dirty", true);
        store.setDefault("pref_show_syncinfo_as_text", false);
        store.setDefault("pref_prompt_on_mixed_tags", true);
        store.setDefault("pref_prompt_on_saving_in_sync", true);
        store.setDefault("pref_save_dirty_editors", 2);
        store.setDefault("pref_checkout_read_only", corePrefs.getDefaultBoolean("cvs.read.only"));
        store.setDefault("pref_edit_action", EDIT);
        store.setValue("pref_checkout_read_only", corePrefs.getBoolean("cvs.read.only"));
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(store.getBoolean("pref_prune_empty_directories"));
        CVSProviderPlugin.getPlugin().setTimeout(store.getInt("pref_timeout"));
        CVSProviderPlugin.getPlugin().setCvsRshCommand(store.getString("pref_cvs_rsh"));
        CVSProviderPlugin.getPlugin().setCvsRshParameters(store.getString("pref_cvs_rsh_parameters"));
        CVSProviderPlugin.getPlugin().setCvsServer(store.getString("pref_cvs_server"));
        CVSProviderPlugin.getPlugin().setQuietness(CVSPreferencesPage.getQuietnessOptionFor(store.getInt("pref_quietness")));
        CVSProviderPlugin.getPlugin().setShowTasksOnAddAndDelete(store.getBoolean("pref_show_markers"));
        CVSProviderPlugin.getPlugin().setCompressionLevel(store.getInt("pref_compression_level"));
        CVSProviderPlugin.getPlugin().setReplaceUnmanaged(store.getBoolean("pref_replace_unmanaged"));
        CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSubstOption.fromMode((String)store.getString("pref_text_ksubst")));
        CVSProviderPlugin.getPlugin().setRepositoriesAreBinary(store.getBoolean("pref_repositories_are_binary"));
        CVSProviderPlugin.getPlugin().setDetermineVersionEnabled(store.getBoolean("pref_determine_server_version"));
    }

    public void startup() throws CoreException {
        super.startup();
        Policy.localize("org.eclipse.team.internal.ccvs.ui.messages");
        CVSAdapterFactory factory = new CVSAdapterFactory();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRemoteFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)factory, (Class)clazz);
        IAdapterManager iAdapterManager2 = Platform.getAdapterManager();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager2.registerAdapters((IAdapterFactory)factory, (Class)clazz2);
        IAdapterManager iAdapterManager3 = Platform.getAdapterManager();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager3.registerAdapters((IAdapterFactory)factory, (Class)clazz3);
        IAdapterManager iAdapterManager4 = Platform.getAdapterManager();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager4.registerAdapters((IAdapterFactory)factory, (Class)clazz4);
        this.initializeImages();
        this.initializePreferences();
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        Console.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this.listener);
        try {
            if (this.repositoryManager != null) {
                this.repositoryManager.shutdown();
            }
        }
        catch (TeamException e) {
            throw new CoreException(e.getStatus());
        }
        Console.shutdown();
    }

    public void propertyChange(PropertyChangeEvent event) {
        try {
            String property = event.getProperty();
            if (property.equals("pref_show_markers")) {
                boolean b = this.getPreferenceStore().getBoolean("pref_show_markers");
                if (b) {
                    AddDeleteMoveListener.refreshAllMarkers();
                } else {
                    AddDeleteMoveListener.clearAllCVSMarkers();
                }
            }
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e.getStatus());
        }
    }

    public interface IOpenableInShell {
        public void open(Shell var1);
    }
}

