/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSAbstractResolutionGenerator;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IMarkerResolution;

public class CVSRemoveResolutionGenerator
extends CVSAbstractResolutionGenerator {
    IMarkerResolution commitDeletion = new IMarkerResolution(){

        public String getLabel() {
            return Policy.bind("CVSRemoveResloutionGenerator.Commit_Deletion_to_CVS_1");
        }

        public void run(IMarker marker) {
            try {
                IContainer parent = (IContainer)marker.getResource();
                String childName = (String)marker.getAttribute("name");
                CVSWorkspaceRoot.getCVSFileFor((IFile)parent.getFile((IPath)new Path(childName)));
                TeamException[] exception = new TeamException[1];
                CVSRemoveResolutionGenerator.this.run(new IRunnableWithProgress(parent, childName, exception){
                    private final /* synthetic */ IContainer val$parent;
                    private final /* synthetic */ String val$childName;
                    private final /* synthetic */ TeamException[] val$exception;
                    {
                        this.val$parent = iContainer;
                        this.val$childName = string;
                        this.val$exception = teamExceptionArray;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ((CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.val$parent.getProject())).checkin(new IResource[]{this.val$parent.getFile((IPath)new Path(this.val$childName))}, 0, monitor);
                        }
                        catch (TeamException e) {
                            this.val$exception[0] = e;
                        }
                    }
                });
                if (exception[0] != null) {
                    throw exception[0];
                }
                marker.delete();
            }
            catch (TeamException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (CoreException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (InvocationTargetException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (InterruptedException interruptedException) {}
        }
    };
    IMarkerResolution undoDeletionLocal = new IMarkerResolution(){

        public String getLabel() {
            return Policy.bind("CVSRemoveResloutionGenerator.Undo_Deletion_from_Local_History_2");
        }

        public void run(IMarker marker) {
            block7: {
                try {
                    IContainer parent = (IContainer)marker.getResource();
                    String childName = (String)marker.getAttribute("name");
                    IFile file = parent.getFile((IPath)new Path(childName));
                    ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor((IFile)parent.getFile((IPath)new Path(childName)));
                    boolean recreated = false;
                    IFileState[] history = file.getHistory(null);
                    int i = 0;
                    while (i < history.length) {
                        IFileState state = history[i];
                        if (state.exists()) {
                            file.create(state.getContents(), false, null);
                            mFile.setTimeStamp(new Date(state.getModificationTime()));
                            recreated = true;
                            break;
                        }
                        ++i;
                    }
                    if (recreated) {
                        ResourceSyncInfo info;
                        if (mFile.isManaged() && (info = mFile.getSyncInfo()).isDeleted()) {
                            MutableResourceSyncInfo deletedInfo = info.cloneMutable();
                            deletedInfo.setDeleted(false);
                            mFile.setSyncInfo((ResourceSyncInfo)deletedInfo, 0);
                        }
                        marker.delete();
                        break block7;
                    }
                    throw new CVSException(Policy.bind("CVSRemoveResloutionGenerator.No_local_history_available._Try_undoing_from_the_server_3"));
                }
                catch (TeamException e) {
                    CVSRemoveResolutionGenerator.this.handle(e, null, null);
                }
                catch (CoreException e) {
                    CVSRemoveResolutionGenerator.this.handle(e, null, null);
                }
            }
        }
    };
    IMarkerResolution undoDeletion = new IMarkerResolution(){

        public String getLabel() {
            return Policy.bind("CVSRemoveResloutionGenerator.Undo_Deletion_from_CVS_Server_4");
        }

        public void run(IMarker marker) {
            try {
                ResourceSyncInfo info;
                IContainer parent = (IContainer)marker.getResource();
                String childName = (String)marker.getAttribute("name");
                parent.getFile((IPath)new Path(childName));
                ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor((IFile)parent.getFile((IPath)new Path(childName)));
                if (mFile.isManaged() && (info = mFile.getSyncInfo()).isDeleted()) {
                    MutableResourceSyncInfo deletedInfo = info.cloneMutable();
                    deletedInfo.setDeleted(false);
                    mFile.setSyncInfo((ResourceSyncInfo)deletedInfo, 0);
                }
                TeamException[] exception = new TeamException[1];
                CVSRemoveResolutionGenerator.this.run(new IRunnableWithProgress(parent, childName, exception){
                    private final /* synthetic */ IContainer val$parent;
                    private final /* synthetic */ String val$childName;
                    private final /* synthetic */ TeamException[] val$exception;
                    {
                        this.val$parent = iContainer;
                        this.val$childName = string;
                        this.val$exception = teamExceptionArray;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.val$parent.getProject());
                            provider.update(new IResource[]{this.val$parent.getFile((IPath)new Path(this.val$childName))}, Command.NO_LOCAL_OPTIONS, null, true, monitor);
                        }
                        catch (TeamException e) {
                            this.val$exception[0] = e;
                        }
                    }
                });
                if (exception[0] != null) {
                    throw exception[0];
                }
                marker.delete();
            }
            catch (TeamException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (CoreException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (InvocationTargetException e) {
                CVSRemoveResolutionGenerator.this.handle(e, null, null);
            }
            catch (InterruptedException interruptedException) {}
        }
    };

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{this.commitDeletion, this.undoDeletionLocal, this.undoDeletion};
    }
}

