/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSFolderPropertiesPage
extends CVSPropertiesPage {
    IFolder folder;
    private Label root;
    private Label repository;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        try {
            ICVSFolder cvsResource = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            if (!cvsResource.isManaged()) {
                if (cvsResource.isIgnored()) {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.ignored"), 2);
                } else {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.notManaged"), 2);
                }
            } else if (!cvsResource.isCVSFolder()) {
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.notCVSFolder"), 2);
            } else {
                FolderSyncInfo syncInfo = cvsResource.getFolderSyncInfo();
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.root"));
                this.root = this.createLabel(composite, syncInfo.getRoot());
                this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.repository"));
                this.repository = this.createLabel(composite, syncInfo.getRepository());
                this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.tag"));
                CVSEntryLineTag tag = syncInfo.getTag();
                if (tag != null && tag.getType() == 1) {
                    tag = Util.getAccurateFolderTag((IResource)this.folder, (CVSTag)tag);
                }
                this.createLabel(composite, CVSPropertiesPage.getTagLabel((CVSTag)tag));
                if (syncInfo.getIsStatic()) {
                    this.createLabel(composite, Policy.bind("CVSFolderPropertiesPage.static"));
                    this.createLabel(composite, syncInfo.getIsStatic() ? Policy.bind("yes") : Policy.bind("no"));
                }
                this.createLabel(composite, "", 2);
                final Button disconnect = new Button(composite, 0);
                disconnect.setText(Policy.bind("CVSFolderPropertiesPage.disconnect"));
                GridData data = new GridData(128);
                data.heightHint = this.convertVerticalDLUsToPixels(14);
                int widthHint = this.convertHorizontalDLUsToPixels(61);
                data.widthHint = Math.max(widthHint, disconnect.computeSize((int)-1, (int)-1, (boolean)true).x);
                disconnect.setLayoutData((Object)data);
                disconnect.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (CVSFolderPropertiesPage.this.disconnectFolder()) {
                            CVSFolderPropertiesPage.this.root.setText(Policy.bind("CVSFilePropertiesPage.none"));
                            CVSFolderPropertiesPage.this.repository.setText(Policy.bind("CVSFilePropertiesPage.none"));
                            disconnect.setEnabled(false);
                        }
                    }
                });
            }
        }
        catch (TeamException teamException) {
            this.createLabel(composite, Policy.bind("CVSFilePropertiesPage.error"), 2);
        }
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.folder_property_page_context");
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    private void initialize() {
        this.folder = null;
        IAdaptable element = this.getElement();
        if (element instanceof IFolder) {
            this.folder = (IFolder)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof IFolder) {
                this.folder = (IFolder)adapter;
            }
        }
    }

    private boolean disconnectFolder() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CVSFolderPropertiesPage.disconnectTitle"), (String)Policy.bind("CVSFolderPropertiesPage.disconnectQuestion"))) {
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.folder);
            try {
                cvsFolder.unmanage(null);
            }
            catch (CVSException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
                return false;
            }
            return true;
        }
        return false;
    }
}

