/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSCompareRevisionsInput
extends CompareEditorInput {
    IFile resource;
    ILogEntry[] editions;
    TableViewer viewer;
    Action getContentsAction;
    Action getRevisionAction;
    Shell shell;
    private HistoryTableProvider historyTableProvider;

    public CVSCompareRevisionsInput(IFile resource, ILogEntry[] editions) {
        super(new CompareConfiguration());
        this.resource = resource;
        this.editions = editions;
        this.updateCurrentEdition();
        this.initializeActions();
    }

    public Viewer createDiffViewer(Composite parent) {
        this.shell = parent.getShell();
        this.viewer = this.getHistoryTableProvider().createTable(parent);
        Table table = this.viewer.getTable();
        table.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Policy.bind("CVSCompareRevisionsInput.structureCompare"));
        this.viewer.setContentProvider((IContentProvider)new VersionCompareContentProvider());
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mm) {
                mm.add((IAction)CVSCompareRevisionsInput.this.getContentsAction);
                mm.add((IAction)CVSCompareRevisionsInput.this.getRevisionAction);
            }
        });
        table.setMenu(mm.createContextMenu((Control)table));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    CVSCompareRevisionsInput.this.getContentsAction.setEnabled(false);
                    CVSCompareRevisionsInput.this.getRevisionAction.setEnabled(false);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                CVSCompareRevisionsInput.this.getContentsAction.setEnabled(ss.size() == 1);
                CVSCompareRevisionsInput.this.getRevisionAction.setEnabled(ss.size() == 1);
            }
        });
        WorkbenchHelp.setHelp((Control)table, (String)"org.eclipse.team.cvs.ui.compare_revision_view_context");
        WorkbenchHelp.setHelp((IAction)this.getContentsAction, (String)"org.eclipse.team.cvs.ui.get_file_contents_action_context");
        WorkbenchHelp.setHelp((IAction)this.getRevisionAction, (String)"org.eclipse.team.cvs.ui.get_file_revision_action_context");
        return this.viewer;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("CVSCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(true);
        cc.setRightEditable(false);
        String leftLabel = Policy.bind("CVSCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String rightLabel = Policy.bind("CVSCompareRevisionsInput.repository", new Object[]{resourceName});
        cc.setRightLabel(rightLabel);
    }

    private void initializeActions() {
        this.getContentsAction = new Action(Policy.bind("HistoryView.getContentsAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(CVSCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IStructuredSelection selection = (IStructuredSelection)4.access$0(this.this$1).viewer.getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ICVSRemoteResource edition = right.getRemoteResource();
                            try {
                                try {
                                    monitor.beginTask(null, 100);
                                    InputStream in = edition.getContents((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    4.access$0(this.this$1).resource.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                monitor.done();
                                throw throwable;
                            }
                            Object var7_11 = null;
                            monitor.done();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    CVSCompareRevisionsInput.this.handle(e);
                }
                CVSCompareRevisionsInput.this.updateCurrentEdition();
                CVSCompareRevisionsInput.this.viewer.refresh();
            }

            static /* synthetic */ CVSCompareRevisionsInput access$0(4 var0) {
                return var0.CVSCompareRevisionsInput.this;
            }
        };
        this.getRevisionAction = new Action(Policy.bind("HistoryView.getRevisionAction"), null){

            public void run() {
                try {
                    new ProgressMonitorDialog(CVSCompareRevisionsInput.this.shell).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IStructuredSelection selection = (IStructuredSelection)6.access$0(this.this$1).viewer.getSelection();
                            if (selection.size() != 1) {
                                return;
                            }
                            VersionCompareDiffNode node = (VersionCompareDiffNode)((Object)selection.getFirstElement());
                            ResourceEditionNode right = (ResourceEditionNode)node.getRight();
                            ICVSRemoteResource edition = right.getRemoteResource();
                            try {
                                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)6.access$0(this.this$1).resource.getProject());
                                CVSTag revisionTag = new CVSTag(((ICVSRemoteFile)edition).getRevision(), 2);
                                if (CVSAction.checkForMixingTags(6.access$0(this.this$1).shell, new IResource[]{6.access$0(this.this$1).resource}, revisionTag)) {
                                    provider.update(new IResource[]{6.access$0(this.this$1).resource}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag, true, monitor);
                                    6.access$0(this.this$1).getHistoryTableProvider().setFile((ICVSFile)edition);
                                }
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    CVSCompareRevisionsInput.this.handle(e);
                }
                CVSCompareRevisionsInput.this.viewer.refresh();
            }

            static /* synthetic */ CVSCompareRevisionsInput access$0(6 var0) {
                return var0.CVSCompareRevisionsInput.this;
            }
        };
    }

    public boolean isSaveNeeded() {
        return false;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.initLabels();
        DiffNode diffRoot = new DiffNode(0);
        int i = 0;
        while (i < this.editions.length) {
            TypedBufferedContent left = new TypedBufferedContent(this.resource);
            ResourceRevisionNode right = new ResourceRevisionNode(this.editions[i]);
            diffRoot.add((IDiffElement)new VersionCompareDiffNode((ITypedElement)left, right));
            ++i;
        }
        return diffRoot;
    }

    private void updateCurrentEdition() {
        try {
            this.getHistoryTableProvider().setFile((ICVSFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)this.resource));
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
    }

    private void handle(Exception e) {
        this.setMessage(CVSUIPlugin.openError(this.shell, null, null, e, 12).getMessage());
    }

    public HistoryTableProvider getHistoryTableProvider() {
        if (this.historyTableProvider == null) {
            this.historyTableProvider = new HistoryTableProvider();
        }
        return this.historyTableProvider;
    }

    class TypedBufferedContent
    extends ResourceNode {
        public TypedBufferedContent(IFile resource) {
            super((IResource)resource);
        }

        protected InputStream createStream() throws CoreException {
            return ((IFile)this.getResource()).getContents();
        }

        public void setContent(byte[] contents) {
            if (contents == null) {
                contents = new byte[]{};
            }
            ByteArrayInputStream is = new ByteArrayInputStream(contents);
            IRunnableWithProgress runnable = new IRunnableWithProgress(this, is){
                private final /* synthetic */ TypedBufferedContent this$1;
                private final /* synthetic */ InputStream val$is;
                {
                    this.this$1 = typedBufferedContent;
                    this.val$is = inputStream;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IFile file = TypedBufferedContent.access$0((TypedBufferedContent)this.this$1).resource;
                        if (this.val$is != null) {
                            if (!file.exists()) {
                                file.create(this.val$is, false, monitor);
                            } else {
                                file.setContents(this.val$is, false, true, monitor);
                            }
                        } else {
                            file.delete(false, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(CVSCompareRevisionsInput.this.shell).run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(CVSUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", CVSCompareRevisionsInput.this.resource.getName()), null, e);
            }
            catch (InterruptedException interruptedException) {}
            this.fireContentChanged();
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            return null;
        }

        static /* synthetic */ CVSCompareRevisionsInput access$0(TypedBufferedContent typedBufferedContent) {
            return typedBufferedContent.CVSCompareRevisionsInput.this;
        }
    }

    class ResourceRevisionNode
    extends ResourceEditionNode {
        ILogEntry entry;

        public ResourceRevisionNode(ILogEntry entry) {
            super((ICVSRemoteResource)entry.getRemoteFile());
            this.entry = entry;
        }

        public ILogEntry getLogEntry() {
            return this.entry;
        }

        public String getName() {
            this.getRemoteResource();
            String revisionName = this.entry.getRevision();
            if (revisionName != null) {
                IFile resource = CVSCompareRevisionsInput.this.resource;
                try {
                    ICVSRemoteFile currentEdition = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource);
                    if (currentEdition == null || !currentEdition.getRevision().equals(revisionName)) {
                        return revisionName;
                    }
                    Policy.bind("currentRevision", revisionName);
                }
                catch (TeamException e) {
                    CVSCompareRevisionsInput.this.handle((Exception)((Object)e));
                }
            }
            return super.getName();
        }
    }

    class VersionCompareDiffNode
    extends DiffNode
    implements IAdaptable {
        static /* synthetic */ Class class$0;

        public VersionCompareDiffNode(ITypedElement left, ITypedElement right) {
            super(left, right);
        }

        public String getName() {
            return this.getRight().getName();
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ILogEntry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return ((ResourceRevisionNode)this.getRight()).getLogEntry();
            }
            return null;
        }
    }

    class VersionCompareContentProvider
    implements IStructuredContentProvider {
        VersionCompareContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DiffContainer) {
                return ((DiffContainer)inputElement).getChildren();
            }
            return null;
        }
    }
}

