/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;

public class CVSCompareEditorInput
extends CompareEditorInput {
    private ITypedElement left;
    private ITypedElement right;
    private ITypedElement ancestor;
    private Image leftImage;
    private Image rightImage;
    private Image ancestorImage;
    private static final int NODE_EQUAL = 0;
    private static final int NODE_NOT_EQUAL = 1;
    private static final int NODE_UNKNOWN = 2;

    public CVSCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right) {
        this(left, right, null);
    }

    public CVSCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right, ResourceEditionNode ancestor) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
        if (left != null) {
            this.leftImage = left.getImage();
        }
        if (right != null) {
            this.rightImage = right.getImage();
        }
        if (ancestor != null) {
            this.ancestorImage = ancestor.getImage();
        }
    }

    private String getLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ICVSRemoteResource edition = ((ResourceEditionNode)element).getRemoteResource();
            ICVSResource resource = (ICVSResource)edition;
            if (edition instanceof ICVSRemoteFile) {
                try {
                    return Policy.bind("nameAndRevision", resource.getName(), ((ICVSRemoteFile)edition).getRevision());
                }
                catch (TeamException teamException) {}
            }
            try {
                if (edition.isContainer()) {
                    CVSTag tag = ((ICVSRemoteFolder)edition).getTag();
                    if (tag == null) {
                        return Policy.bind("CVSCompareEditorInput.inHead", edition.getName());
                    }
                    if (tag.getType() == 1) {
                        return Policy.bind("CVSCompareEditorInput.inBranch", new Object[]{edition.getName(), tag.getName()});
                    }
                    return Policy.bind("CVSCompareEditorInput.repository", new Object[]{edition.getName(), tag.getName()});
                }
                return Policy.bind("CVSCompareEditorInput.repository", new Object[]{edition.getName(), resource.getSyncInfo().getRevision()});
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
            }
        }
        return element.getName();
    }

    private String getVersionLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ICVSRemoteResource edition = ((ResourceEditionNode)element).getRemoteResource();
            ICVSResource resource = (ICVSResource)edition;
            try {
                if (edition.isContainer()) {
                    CVSTag tag = ((ICVSRemoteFolder)resource).getTag();
                    if (tag == null) {
                        return Policy.bind("CVSCompareEditorInput.headLabel");
                    }
                    if (tag.getType() == 1) {
                        return Policy.bind("CVSCompareEditorInput.branchLabel", tag.getName());
                    }
                    return tag.getName();
                }
                return resource.getSyncInfo().getRevision();
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
            }
        }
        return element.getName();
    }

    private String guessResourceName() {
        if (this.left != null) {
            return this.left.getName();
        }
        if (this.right != null) {
            return this.right.getName();
        }
        if (this.ancestor != null) {
            return this.ancestor.getName();
        }
        return "";
    }

    private void handle(Exception e) {
        Throwable t = e;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        Object error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.cvs.ui", 1, Policy.bind("internal"), t));
        this.setMessage(error.getMessage());
        if (!(t instanceof TeamException)) {
            CVSUIPlugin.log(error);
        }
    }

    private void initLabels() {
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        this.setLabels(cc, (IStructuredSelection)new StructuredSelection());
        if (this.ancestor != null) {
            title = Policy.bind("CVSCompareEditorInput.titleAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(this.ancestor), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
        } else {
            String leftName = null;
            if (this.left != null) {
                leftName = this.left.getName();
            }
            String rightName = null;
            if (this.right != null) {
                rightName = this.right.getName();
            }
            title = leftName != null && !leftName.equals(rightName) ? Policy.bind("CVSCompareEditorInput.titleNoAncestorDifferent", new Object[]{leftName, this.getVersionLabel(this.left), rightName, this.getVersionLabel(this.right)}) : Policy.bind("CVSCompareEditorInput.titleNoAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
        }
        this.setTitle(title);
    }

    private void setLabels(CompareConfiguration cc, IStructuredSelection selection) {
        ITypedElement left = this.left;
        ITypedElement right = this.right;
        ITypedElement ancestor = this.ancestor;
        if (left != null) {
            cc.setLeftLabel(this.getLabel(left));
            cc.setLeftImage(this.leftImage);
        }
        if (right != null) {
            cc.setRightLabel(this.getLabel(right));
            cc.setRightImage(this.rightImage);
        }
        if (ancestor != null) {
            cc.setAncestorLabel(this.getLabel(ancestor));
            cc.setAncestorImage(this.ancestorImage);
        }
    }

    public boolean isSaveNeeded() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Object object;
        boolean threeWay;
        boolean bl = threeWay = this.ancestor != null;
        if (this.right == null || this.left == null) {
            this.setMessage(Policy.bind("CVSCompareEditorInput.different"));
            return null;
        }
        this.initLabels();
        final Differencer d = new Differencer(){

            protected boolean contentsEqual(Object input1, Object input2) {
                int compare = CVSCompareEditorInput.this.teamEqual(input1, input2);
                if (compare == 0) {
                    return true;
                }
                if (compare == 1) {
                    return false;
                }
                return super.contentsEqual(input1, input2);
            }

            protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
                if (node instanceof ITypedElement) {
                    ITypedElement element = (ITypedElement)node;
                    progressMonitor.subTask(Policy.bind("CompareEditorInput.fileProgress", new String[]{element.getName()}));
                    progressMonitor.worked(1);
                }
            }

            protected Object[] getChildren(Object input) {
                Object[] children;
                if (input instanceof IStructureComparator && (children = ((IStructureComparator)input).getChildren()) != null) {
                    return children;
                }
                return null;
            }

            protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                return new DiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        try {
            try {
                final Object[] result = new Object[1];
                Session.run(null, null, (boolean)false, (ICVSRunnable)new ICVSRunnable(){

                    public void run(IProgressMonitor monitor) throws CVSException {
                        monitor.beginTask(Policy.bind("CVSCompareEditorInput.comparing"), 30);
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
                        sub.beginTask(Policy.bind("CVSCompareEditorInput.comparing"), 100);
                        try {
                            result[0] = d.findDifferences(threeWay, (IProgressMonitor)sub, null, (Object)CVSCompareEditorInput.this.ancestor, (Object)CVSCompareEditorInput.this.left, (Object)CVSCompareEditorInput.this.right);
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            sub.done();
                            throw throwable;
                        }
                        Object var3_5 = null;
                        sub.done();
                    }
                }, (IProgressMonitor)monitor);
                object = result[0];
                Object var5_9 = null;
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (RuntimeException e) {
                this.handle(e);
                Object var5_10 = null;
                monitor.done();
                return null;
            }
            catch (CVSException e) {
                this.handle((Exception)((Object)e));
                Object var5_11 = null;
                monitor.done();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return object;
    }

    protected int teamEqual(Object left, Object right) {
        String rightLocation;
        ICVSRemoteResource leftEdition = null;
        if (left instanceof ResourceEditionNode) {
            leftEdition = ((ResourceEditionNode)left).getRemoteResource();
        }
        ICVSRemoteResource rightEdition = null;
        if (right instanceof ResourceEditionNode) {
            rightEdition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (leftEdition == null || rightEdition == null) {
            return 2;
        }
        if (leftEdition.isContainer() && rightEdition.isContainer()) {
            return 0;
        }
        if (leftEdition.isContainer() != rightEdition.isContainer()) {
            return 1;
        }
        String leftLocation = leftEdition.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = rightEdition.getRepository().getLocation())) {
            return 2;
        }
        try {
            ResourceSyncInfo leftInfo = ((ICVSResource)leftEdition).getSyncInfo();
            ResourceSyncInfo rightInfo = ((ICVSResource)rightEdition).getSyncInfo();
            if (leftEdition.getRepositoryRelativePath().equals(rightEdition.getRepositoryRelativePath()) && leftInfo.getRevision().equals(rightInfo.getRevision())) {
                return 0;
            }
            if (this.considerContentIfRevisionOrPathDiffers()) {
                return 2;
            }
            return 1;
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
            return 2;
        }
    }

    private boolean considerContentIfRevisionOrPathDiffers() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_consider_contents");
    }

    public Viewer createDiffViewer(Composite parent) {
        Viewer viewer = super.createDiffViewer(parent);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompareConfiguration cc = CVSCompareEditorInput.this.getCompareConfiguration();
                CVSCompareEditorInput.this.setLabels(cc, (IStructuredSelection)event.getSelection());
            }
        });
        return viewer;
    }
}

