/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ui.DetailsDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BranchPromptDialog
extends DetailsDialog {
    private ICVSFolder folder;
    private String branchTag = "";
    private String versionTag = "";
    private String versionName = "";
    private boolean allStickyResources;
    private boolean update;
    private Text versionText;
    private Text branchText;
    private static final int TABLE_HEIGHT_HINT = 150;
    private TreeViewer tagTree;

    public BranchPromptDialog(Shell parentShell, String title, ICVSFolder folder, boolean allResourcesSticky, String versionName) {
        super(parentShell, title);
        this.folder = folder;
        this.allStickyResources = allResourcesSticky;
        this.versionName = versionName;
    }

    protected void createMainDialogArea(Composite composite) {
        Label label = new Label(composite, 64);
        String message = this.allStickyResources ? Policy.bind("BranchWizardPage.pageDescriptionVersion") : Policy.bind("BranchWizardPage.pageDescription");
        label.setText(message);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(composite.getFont());
        CVSWizardPage.createLabel(composite, Policy.bind("BranchWizardPage.branchName"));
        this.branchText = CVSWizardPage.createTextField(composite);
        this.branchText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                BranchPromptDialog.this.branchTag = BranchPromptDialog.this.branchText.getText();
                BranchPromptDialog.this.updateEnablements();
                BranchPromptDialog.this.updateVersionName(BranchPromptDialog.this.branchTag);
            }
        });
        final Button check = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        check.setLayoutData((Object)data);
        check.setText(Policy.bind("BranchWizardPage.startWorking"));
        check.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BranchPromptDialog.this.update = check.getSelection();
            }
        });
        check.setSelection(true);
        this.update = true;
        label = new Label(composite, 64);
        label.setText(Policy.bind("BranchWizardPage.specifyVersion"));
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 350;
        label.setLayoutData((Object)data);
        CVSWizardPage.createLabel(composite, Policy.bind("BranchWizardPage.versionName"));
        this.versionText = CVSWizardPage.createTextField(composite);
        this.versionText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                BranchPromptDialog.this.versionTag = BranchPromptDialog.this.versionText.getText();
                BranchPromptDialog.this.updateEnablements();
            }
        });
        if (this.allStickyResources) {
            this.versionText.setEditable(false);
            this.versionText.setText(this.versionName);
        }
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.branch_dialog_context");
        this.branchText.setFocus();
    }

    protected void updateVersionName(String branchName) {
        if (this.versionText != null && !this.allStickyResources) {
            this.versionText.setText(String.valueOf(Policy.bind("BranchWizardPage.versionPrefix")) + branchName);
        }
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(Policy.bind("BranchWizardPage.existingVersionsAndBranches"));
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(composite.getFont());
        this.tagTree = this.createTree(composite);
        this.tagTree.setInput((Object)new ProjectElement(this.folder, 12));
        Runnable refresh = new Runnable(){

            public void run() {
                BranchPromptDialog.this.getShell().getDisplay().syncExec(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        BranchPromptDialog.access$6(4.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ BranchPromptDialog access$0(4 var0) {
                return var0.BranchPromptDialog.this;
            }
        };
        TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), composite, new ICVSFolder[]{this.folder}, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), refresh, refresh);
        return composite;
    }

    protected TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2052);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        tree.setLayoutData((Object)data);
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        result.setSorter((ViewerSorter)new RepositorySorter());
        return result;
    }

    protected void updateEnablements() {
        String message = null;
        if (this.branchTag.length() == 0) {
            message = "";
        } else {
            IStatus status = CVSTag.validateTagName((String)this.branchTag);
            if (!status.isOK()) {
                message = Policy.bind("BranchWizard.branchNameWarning", status.getMessage());
            } else if (this.versionText != null) {
                status = CVSTag.validateTagName((String)this.versionText.getText());
                if (!status.isOK()) {
                    message = Policy.bind("BranchWizard.versionNameWarning", status.getMessage());
                } else if (this.versionTag.length() != 0 && this.versionTag.equals(this.branchTag)) {
                    message = Policy.bind("BranchWizard.branchAndVersionMustBeDifferent");
                }
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public String getBranchTagName() {
        return this.branchTag;
    }

    public String getVersionTagName() {
        return this.versionTag;
    }

    public boolean getUpdate() {
        return this.update;
    }

    static /* synthetic */ TreeViewer access$6(BranchPromptDialog branchPromptDialog) {
        return branchPromptDialog.tagTree;
    }
}

