/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect.compiler;

import com.togethersoft.sca.internal.plugin.detect.MeasureException;
import com.togethersoft.sca.internal.plugin.detect.compiler.Context;
import com.togethersoft.sca.internal.plugin.detect.compiler.Expr;
import java.io.PrintStream;
import java.util.HashSet;

class MetricExpr
extends Expr {
    public static final int HIGHER_THAN = 0;
    public static final int LOWER_THAN = 1;
    public static final int TOP_VALUES = 2;
    public static final int BOTTOM_VALUES = 3;
    public static final int BOX_PLOTS = 4;
    int kind;
    String metric;
    int value;

    MetricExpr(int kind, String metric, String value) {
        this.kind = kind;
        this.metric = metric;
        this.value = Integer.parseInt(value);
    }

    public void eval(Context context) throws MeasureException {
        switch (this.kind) {
            case 0: {
                context.getTable().markHigherThan(this.metric, this.value);
                break;
            }
            case 1: {
                context.getTable().markLowerThan(this.metric, this.value);
                break;
            }
            case 2: {
                context.getTable().markTopValues(this.metric, this.value);
                break;
            }
            case 3: {
                context.getTable().markBottomValues(this.metric, this.value);
            }
        }
    }

    public void getMetrics(HashSet metrics) {
        metrics.add(this.metric);
    }

    public void print(PrintStream out) {
        out.println("#" + this.getId() + "(MetricExpr): " + this.metric + " " + this.kind + " " + this.value);
    }
}

