/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect.compiler;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.detect.MeasureException;
import com.togethersoft.sca.internal.plugin.detect.MeasureTable;
import com.togethersoft.sca.internal.plugin.detect.compiler.CompilerException;
import com.togethersoft.sca.internal.plugin.detect.compiler.Context;
import com.togethersoft.sca.internal.plugin.detect.compiler.Expr;
import com.togethersoft.sca.internal.plugin.detect.compiler.StrategyLexer;
import com.togethersoft.sca.internal.plugin.detect.compiler.StrategyParser;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.HashSet;

public class Compiler {
    private IAnalyzerDescriptor desc;
    private Expr root;
    private MeasureTable table;

    public Compiler(IAnalyzerDescriptor desc) throws CompilerException {
        this.desc = desc;
        try {
            StrategyLexer lexer = new StrategyLexer(new StringReader(desc.getImplementation()));
            lexer.setFilename("<Strategy>");
            StrategyParser parser = new StrategyParser(lexer);
            parser.setFilename("<Strategy>");
            this.root = parser.detectionRule();
        }
        catch (TokenStreamException e) {
            throw new CompilerException(e.toString());
        }
        catch (RecognitionException e) {
            throw new CompilerException(e.toString());
        }
    }

    public IAnalyzerDescriptor getAnalyzer() {
        return this.desc;
    }

    public void setTable(MeasureTable table) {
        this.table = table;
    }

    public MeasureTable getTable() {
        return this.table;
    }

    public String[] getMetrics() {
        HashSet metrics = new HashSet();
        this.root.getMetrics(metrics);
        return ((AbstractCollection)metrics).toArray(new String[metrics.size()]);
    }

    public void execute() throws MeasureException {
        Context context = new Context(this.table);
        this.root.eval(context);
    }
}

