/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect.compiler;

import com.togethersoft.sca.internal.plugin.detect.MeasureException;
import com.togethersoft.sca.internal.plugin.detect.compiler.Context;
import com.togethersoft.sca.internal.plugin.detect.compiler.Expr;
import java.io.PrintStream;
import java.util.HashSet;

class BinaryExpr
extends Expr {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int SUB = 2;
    private int kind;
    private Expr left;
    private Expr right;

    BinaryExpr(int kind, Expr left, Expr right) {
        this.kind = kind;
        this.left = left;
        this.right = right;
    }

    public void eval(Context context) throws MeasureException {
        this.left.eval(context);
        this.right.eval(context);
        switch (this.kind) {
            case 0: {
                context.getTable().intersect();
                break;
            }
            case 1: {
                context.getTable().union();
                break;
            }
            case 2: {
                context.getTable().subtract();
            }
        }
    }

    public void getMetrics(HashSet metrics) {
        this.left.getMetrics(metrics);
        this.right.getMetrics(metrics);
    }

    public void print(PrintStream out) {
        out.println("#" + this.getId() + "(BinaryExpr): #" + this.left.getId() + " " + this.getOperator() + " " + "#" + this.right.getId());
        this.left.print(out);
        this.right.print(out);
    }

    public String getOperator() {
        switch (this.kind) {
            case 0: {
                return "and";
            }
            case 1: {
                return "or";
            }
            case 2: {
                return "butnotin";
            }
        }
        return null;
    }
}

