/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.plugin.TemplateManager;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.internal.plugin.detect.DetectPlugin;
import com.togethersoft.sca.internal.plugin.detect.MeasureTable;
import com.togethersoft.sca.internal.plugin.detect.compiler.Compiler;
import java.util.ArrayList;

class ProblemInfo {
    private Compiler strategy;
    private AstMember element;
    private IAnalyzerDescriptor[] metrics;
    private IMetricResult[] results;
    private MeasureTable.RowValue rval;

    ProblemInfo(AstMember element, IAnalyzerDescriptor[] metrics, IMetricResult[] results, Compiler strategy, MeasureTable.RowValue rval) {
        this.element = element;
        this.strategy = strategy;
        this.rval = rval;
        String[] metricIds = strategy.getMetrics();
        this.metrics = new IAnalyzerDescriptor[metricIds.length];
        this.results = new IMetricResult[metricIds.length];
        int i = 0;
        while (i < metricIds.length) {
            String id = metricIds[i];
            int j = 0;
            while (j < metrics.length) {
                if (id.equals(metrics[j].getId())) {
                    this.metrics[i] = metrics[j];
                    this.results[i] = results[j];
                }
                ++j;
            }
            ++i;
        }
    }

    public Object[] getProblemValues() {
        String metricName = null;
        int i = 0;
        while (i < this.metrics.length) {
            if (this.rval.metricId.equals(this.metrics[i].getId())) {
                metricName = this.metrics[i].getName();
            }
            ++i;
        }
        String text = "TopValues".equals(this.rval.filter) || "BottomValues".equals(this.rval.filter) ? "%" : "";
        return new Object[]{metricName, this.rval.metricId, this.rval.filter, new Integer(this.rval.rangeValue), text};
    }

    public String getExplainMessage() {
        TemplateManager templateManager = DetectPlugin.getTemplateManager();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this.strategy.getAnalyzer());
        int realValue = -1;
        int i = 0;
        while (i < this.metrics.length) {
            if (this.rval.metricId.equals(this.metrics[i].getId())) {
                realValue = this.results[i].getValue();
            }
            objects.add(new Object[]{this.metrics[i], this.results[i]});
            ++i;
        }
        objects.add(new Object[]{new Integer(realValue), this.rval, this.strategy.getAnalyzer()});
        return templateManager.formatTemplateFile("com.togethersoft.sca.internal.plugin.detect." + this.strategy.getAnalyzer().getId(), DetectPlugin.getClassLoader(), objects.toArray(new Object[0]));
    }

    public IAnalyzerDescriptor getAnalyzer() {
        return this.strategy.getAnalyzer();
    }

    public AstMember getElement() {
        return this.element;
    }

    public IMetricResult[] getResults() {
        return this.results;
    }

    public String toString(boolean isXML) {
        StringBuffer sbuf;
        if (isXML) {
            AstMember element = null;
            sbuf = new StringBuffer("<testresult>\n");
            sbuf.append("\t<property name=\"id\" value=\"");
            sbuf.append(this.strategy.getAnalyzer().getId()).append("\" />\n");
            sbuf.append("\t<property name=\"message\" value=\"");
            sbuf.append(this.strategy.getAnalyzer().getName()).append(" (");
            int i = 0;
            while (i < this.metrics.length) {
                if (i > 0) {
                    sbuf.append(", ");
                } else {
                    element = this.results[i].getSubject();
                }
                sbuf.append("").append(this.metrics[i].getId());
                sbuf.append("=").append(this.results[i].getValue());
                ++i;
            }
            sbuf.append(")\" />\n\t<property name=\"package\" value=\"");
            sbuf.append(element.getPackage().getQualifiedName());
            AstSourcePosition pos = element.getPosition();
            String filename = "";
            int line = 0;
            int col = 0;
            if (pos != null) {
                filename = pos.getFileName();
                line = pos.getStartLine();
                col = pos.getStartColumn();
            }
            sbuf.append("\" />\n\t<property name=\"url\" file=\"").append(filename);
            sbuf.append("\" line=\"").append(line);
            sbuf.append("\" col=\"").append(col).append("\" />\n");
            sbuf.append("</testresult>");
        } else {
            sbuf = new StringBuffer(this.strategy.getAnalyzer().getName()).append(" (");
            int i = 0;
            while (i < this.metrics.length) {
                sbuf.append(this.metrics[i].getId()).append(" = ");
                sbuf.append(this.results[i].getValue());
                if (i < this.metrics.length - 1) {
                    sbuf.append(", ");
                } else {
                    sbuf.append(")");
                }
                ++i;
            }
        }
        return sbuf.toString();
    }
}

