/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.plugin.metric.IMetric;
import com.togethersoft.sca.core.plugin.metric.IMetricPlugin;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.core.plugin.metric.IMetricSurvey;
import com.togethersoft.sca.internal.plugin.detect.MeasureException;
import com.togethersoft.sca.internal.plugin.detect.ProblemInfo;
import com.togethersoft.sca.internal.plugin.detect.compiler.Compiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;

public class MeasureTable {
    public static final String filterHigherThan = "HigherThan";
    public static final String filterLowerThan = "LowerThan";
    public static final String filterTopValues = "TopValues";
    public static final String filterBottomValues = "BottomValues";
    public static final String filterBoxPlots = "BoxPlots";
    private RowInfo[] table;
    private IAnalyzerDescriptor[] columns;
    private IMetricPlugin plugin;
    private ArrayList metrics;
    private int kind;

    MeasureTable(IMetricPlugin plugin, int kind) {
        this.plugin = plugin;
        this.metrics = new ArrayList();
        this.kind = kind;
    }

    void addMetric(IMetric metric) {
        this.metrics.add(metric);
    }

    void runMetrics(IProject project, JobControl jobControl) throws MeasureException {
        if (this.metrics.size() < 1) {
            if (jobControl != null) {
                jobControl.update(1.0);
            }
            return;
        }
        IMetric[] arrMetrics = this.metrics.toArray(new IMetric[this.metrics.size()]);
        int i = 0;
        while (i < arrMetrics.length) {
            IParameterStringEnum iParameterStringEnum = (IParameterStringEnum)arrMetrics[i].getDescriptor().getParameterRegistry().getParameter("kind", 4);
            if (iParameterStringEnum != null) {
                iParameterStringEnum.setValue(this.kind);
            }
            ++i;
        }
        IMetricSurvey[] measures = this.plugin.measure(project, arrMetrics, jobControl);
        if (measures.length != arrMetrics.length) {
            throw new MeasureException("Failed to measure all required metrics");
        }
        int i2 = 0;
        while (i2 < measures.length) {
            IMetricSurvey survey = measures[i2];
            IMetricResult[] results = this.gatherResults(survey);
            if (i2 == 0) {
                this.columns = new IAnalyzerDescriptor[arrMetrics.length];
                this.table = new RowInfo[results.length];
            }
            this.columns[i2] = survey.getMetric().getDescriptor();
            if (results.length != this.table.length) {
                this.cleanup();
                throw new MeasureException("Metric " + survey.getMetric().getDescriptor().getName() + " is not compatible with other metrics");
            }
            int j = 0;
            while (j < results.length) {
                IMetricResult result = results[j];
                if (i2 == 0) {
                    this.table[j] = new RowInfo(result.getSubject(), this.columns.length);
                } else if (this.table[j].getElement() != result.getSubject()) {
                    this.cleanup();
                    throw new MeasureException("Metric " + survey.getMetric().getDescriptor().getName() + " is not compatible with other metrics");
                }
                this.table[j].measures[i2] = result;
                ++j;
            }
            ++i2;
        }
    }

    private void cleanup() {
        this.table = null;
        this.columns = null;
    }

    private IMetricResult[] gatherResults(IMetricSurvey survey) {
        int astKind = -1;
        switch (this.kind) {
            case 1: {
                astKind = 7;
                break;
            }
            case 2: {
                astKind = 8;
                break;
            }
            case 3: {
                astKind = 6;
            }
        }
        ArrayList ret = new ArrayList();
        this.gatherResults(astKind, survey.getResults()[0].getResults(), ret);
        return ret.toArray(new IMetricResult[ret.size()]);
    }

    private void gatherResults(int kind, IMetricResult[] results, ArrayList ret) {
        int i = 0;
        while (i < results.length) {
            if (results[i].getSubject().getObjectKind() == kind) {
                ret.add(results[i]);
            }
            this.gatherResults(kind, results[i].getResults(), ret);
            ++i;
        }
    }

    private void sortTable(final int col) {
        Arrays.sort(this.table, new Comparator(){

            public int compare(Object o1, Object o2) {
                int val2;
                int val1 = ((RowInfo)o1).measures[col].getValue();
                if (val1 < (val2 = ((RowInfo)o2).measures[col].getValue())) {
                    return 1;
                }
                if (val1 > val2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void markTopValues(String metricId, int percent) throws MeasureException {
        int col = this.getMetricColumn(metricId);
        this.sortTable(col);
        int numSelect = this.table.length * percent / 100;
        int row = 0;
        while (numSelect-- > 0) {
            this.selectElement(row++, true, metricId, percent, filterTopValues);
        }
        while (row < this.table.length) {
            this.selectElement(row++, false, metricId, percent, filterTopValues);
        }
    }

    public void markBottomValues(String metricId, int percent) throws MeasureException {
        int col = this.getMetricColumn(metricId);
        this.sortTable(col);
        int numSelect = this.table.length * percent / 100;
        int row = this.table.length - 1;
        while (numSelect-- > 0) {
            this.selectElement(row--, true, metricId, percent, filterBottomValues);
        }
        while (row >= 0) {
            this.selectElement(row--, false, metricId, percent, filterBottomValues);
        }
    }

    public void markHigherThan(String metricId, int value) throws MeasureException {
        int col = this.getMetricColumn(metricId);
        int row = 0;
        while (row < this.table.length) {
            this.selectElement(row, this.table[row].measures[col].getValue() > value, metricId, value, filterHigherThan);
            ++row;
        }
    }

    public void markLowerThan(String metricId, int value) throws MeasureException {
        int col = this.getMetricColumn(metricId);
        int row = 0;
        while (row < this.table.length) {
            this.selectElement(row, this.table[row].measures[col].getValue() < value, metricId, value, filterLowerThan);
            ++row;
        }
    }

    public void union() throws MeasureException {
        int i = 0;
        while (i < this.table.length) {
            RowValue rval2 = this.table[i].pop();
            RowValue rval1 = this.table[i].pop();
            boolean op2 = rval2.value;
            boolean op1 = rval1.value;
            RowValue rval = rval1;
            if (op2) {
                rval = rval2;
            }
            rval.value = op1 || op2;
            this.table[i].push(rval);
            ++i;
        }
    }

    public void intersect() throws MeasureException {
        int i = 0;
        while (i < this.table.length) {
            RowValue rval2 = this.table[i].pop();
            RowValue rval1 = this.table[i].pop();
            boolean op2 = rval2.value;
            boolean op1 = rval1.value;
            RowValue rval = rval1;
            rval.value = op1 && op2;
            this.table[i].push(rval);
            ++i;
        }
    }

    public void subtract() throws MeasureException {
        int i = 0;
        while (i < this.table.length) {
            RowValue rval2 = this.table[i].pop();
            RowValue rval1 = this.table[i].pop();
            boolean op2 = rval2.value;
            boolean op1 = rval1.value;
            RowValue rval = rval1;
            rval.value = op1 && !op2;
            this.table[i].push(rval);
            ++i;
        }
    }

    ProblemInfo[] getProblems(Compiler strategy) {
        if (this.table == null) {
            return new ProblemInfo[0];
        }
        ArrayList<ProblemInfo> problems = new ArrayList<ProblemInfo>();
        int row = 0;
        while (row < this.table.length) {
            RowInfo el = this.table[row];
            if (!el.empty()) {
                RowValue rval = el.pop();
                if (rval.value) {
                    problems.add(new ProblemInfo(el.getElement(), this.columns, el.measures, strategy, rval));
                }
            }
            ++row;
        }
        return problems.toArray(new ProblemInfo[problems.size()]);
    }

    private void selectElement(int row, boolean flag, String metricId, int rangeValue, String filter) {
        RowValue rval = new RowValue(flag, metricId, rangeValue, filter);
        this.table[row].push(rval);
    }

    private int getMetricColumn(String metricId) throws MeasureException {
        if (this.columns != null) {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i].getId().equals(metricId)) {
                    return i;
                }
                ++i;
            }
        }
        throw new MeasureException("Metric " + metricId + " not found");
    }

    private static class RowInfo {
        private AstMember element;
        private Stack stack;
        IMetricResult[] measures;

        RowInfo(AstMember element, int numMeasures) {
            this.element = element;
            this.stack = new Stack();
            this.measures = new IMetricResult[numMeasures];
        }

        AstMember getElement() {
            return this.element;
        }

        void push(RowValue rval) {
            this.stack.push(rval);
        }

        RowValue pop() {
            return (RowValue)this.stack.pop();
        }

        boolean empty() {
            return this.stack.empty();
        }
    }

    class RowValue {
        String metricId;
        int rangeValue;
        String filter;
        boolean value;

        RowValue(boolean value, String metricId, int rangeValue, String filter) {
            this.value = value;
            this.metricId = metricId;
            this.rangeValue = rangeValue;
            this.filter = filter;
        }
    }
}

