/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect;

import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.plugin.HTMLTemplateFormatter;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.internal.plugin.detect.DetectPlugin;
import com.togethersoft.sca.internal.plugin.detect.MeasureTable;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

public class DetectTemplateFormatter
extends HTMLTemplateFormatter
implements ITemplateFormatter {
    private static CharToByteConverter ctb;

    public String format(boolean isQualified, char key, Object printObject) {
        String result = "";
        switch (key) {
            case 'M': {
                IAnalyzerDescriptor metric = (IAnalyzerDescriptor)((Object[])printObject)[0];
                IMetricResult results = (IMetricResult)((Object[])printObject)[1];
                String docPath = this.getDocPath(metric);
                if (docPath != null) {
                    result = "<A HREF=\"" + docPath + "\">";
                }
                result = result + "<span title=\"" + this.getUTFString(DetectPlugin.getResourceBundle().getString("DetectTemplateFormatter.metricValue")) + " " + results.getValue() + "\">" + metric.getName() + " (" + metric.getId() + ") = " + results.getValue() + "</span>";
                if (docPath != null) {
                    result = result + "</a>";
                }
                return result;
            }
            case 'R': {
                Integer realValue = (Integer)((Object[])printObject)[0];
                MeasureTable.RowValue rval = (MeasureTable.RowValue)((Object[])printObject)[1];
                IAnalyzerDescriptor detect = (IAnalyzerDescriptor)((Object[])printObject)[2];
                String impl = detect.getImplementation();
                String implName = this.getUTFString(detect.getName());
                String text = "TopValues".equals(rval.filter) || "BottomValues".equals(rval.filter) ? "%" : "";
                String str = "(" + rval.metricId + ", " + rval.filter + "(" + rval.rangeValue + text + "))";
                int i = impl.indexOf(str);
                result = "<font color=\"blue\">" + implName + " := ";
                if (i >= 0) {
                    result = result + impl.substring(0, i);
                    result = result + "<font color=\"red\"><span title=\"" + this.getUTFString(DetectPlugin.getResourceBundle().getString("DetectTemplateFormatter.metricValue")) + " " + realValue + text + "\">" + str + "</span></font>";
                    result = result + impl.substring(i + str.length());
                } else {
                    result = result + impl;
                }
                result = result + "</font>";
                return result;
            }
        }
        return super.format(isQualified, key, printObject);
    }

    private String getUTFString(String str) {
        if (ctb != null) {
            try {
                return new String(ctb.convertAll(str.toCharArray()));
            }
            catch (MalformedInputException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    static {
        try {
            ctb = CharToByteConverter.getConverter((String)"UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

