/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.detect;

import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.IStaticAnalyzer;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.core.plugin.TemplateManager;
import com.togethersoft.sca.core.plugin.metric.IMetric;
import com.togethersoft.sca.core.plugin.metric.IMetricPlugin;
import com.togethersoft.sca.internal.plugin.detect.DetectMessage;
import com.togethersoft.sca.internal.plugin.detect.DetectTemplateFormatter;
import com.togethersoft.sca.internal.plugin.detect.MeasureException;
import com.togethersoft.sca.internal.plugin.detect.MeasureTable;
import com.togethersoft.sca.internal.plugin.detect.ProblemInfo;
import com.togethersoft.sca.internal.plugin.detect.compiler.Compiler;
import com.togethersoft.sca.internal.plugin.detect.compiler.CompilerException;
import java.util.ResourceBundle;

public class DetectPlugin
implements ICodeInspectorExecutable {
    private MeasureTable packageTable;
    private MeasureTable classTable;
    private MeasureTable methodTable;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.internal.plugin.detect.DetectPluginMessages");
    private static final TemplateManager templateManager = new TemplateManager((ITemplateFormatter)new DetectTemplateFormatter());
    private static final ClassLoader myClassLoader = (class$com$togethersoft$sca$internal$plugin$detect$DetectPlugin == null ? (class$com$togethersoft$sca$internal$plugin$detect$DetectPlugin = DetectPlugin.class$("com.togethersoft.sca.internal.plugin.detect.DetectPlugin")) : class$com$togethersoft$sca$internal$plugin$detect$DetectPlugin).getClassLoader();
    private static final int DEFAULT_KIND = 0;
    static /* synthetic */ Class class$com$togethersoft$sca$internal$plugin$detect$DetectPlugin;

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static TemplateManager getTemplateManager() {
        return templateManager;
    }

    public static ClassLoader getClassLoader() {
        return myClassLoader;
    }

    public void setParameters(IParameterRegistry registry) {
    }

    public void configureRegistry(IAnalyzerRegistry registry) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProject project, IAnalyzerDescriptor[] analyzers, JobControl jobControl) {
        ILog log = project.getLog();
        IStaticAnalyzer platform = Factory.getStaticAnalyzer();
        ICodeInspector inspector = platform.getCodeInspector("Metric");
        if (inspector == null) {
            log.log(resourceBundle.getString("DetectPlugin.1"));
            return;
        }
        IMetricPlugin plugin = (IMetricPlugin)inspector.createExecutableCodeInspector();
        if (plugin == null) {
            return;
        }
        Compiler[] strategies = new Compiler[analyzers.length];
        this.packageTable = new MeasureTable(plugin, 1);
        this.classTable = new MeasureTable(plugin, 2);
        this.methodTable = new MeasureTable(plugin, 3);
        int i = 0;
        while (i < analyzers.length) {
            IAnalyzerDescriptor desc = analyzers[i];
            try {
                Compiler s = new Compiler(desc);
                MeasureTable table = this.getTable(plugin, inspector.getRegistry(), s.getMetrics(), this.getAnalyzerKind(desc));
                s.setTable(table);
                strategies[i] = s;
            }
            catch (CompilerException e) {
                log.log(desc.getName() + ": " + e.getMessage());
            }
            catch (MeasureException e) {
                log.log(desc.getName() + ": " + e.getMessage());
            }
            ++i;
        }
        try {
            block15: {
                try {
                    if (jobControl != null) {
                        jobControl.setScale(0.3333333333333333);
                    }
                    this.packageTable.runMetrics(project, jobControl);
                    this.classTable.runMetrics(project, jobControl);
                    this.methodTable.runMetrics(project, jobControl);
                    if (log.isXML()) {
                        log.log("<audit>");
                    }
                    int i2 = 0;
                    while (i2 < strategies.length) {
                        if (strategies[i2] != null) {
                            strategies[i2].execute();
                            ProblemInfo[] problems = strategies[i2].getTable().getProblems(strategies[i2]);
                            int j = 0;
                            while (j < problems.length) {
                                ProblemInfo pi = problems[j];
                                DetectMessage msg = new DetectMessage(null, pi);
                                msg.setProperty("MetricResults", pi.getResults());
                                log.log((IMessage)msg);
                                ++j;
                            }
                        }
                        ++i2;
                    }
                    if (!log.isXML()) break block15;
                    log.log("</audit>");
                }
                catch (MeasureException e) {
                    log.log((IMessage)new Message(2, e.getMessage(), null));
                    Object var16_22 = null;
                    if (jobControl == null) return;
                    jobControl.setScale(3.0);
                    return;
                }
            }
            Object var16_21 = null;
            if (jobControl == null) return;
            jobControl.setScale(3.0);
            return;
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            if (jobControl == null) throw throwable;
            jobControl.setScale(3.0);
            throw throwable;
        }
    }

    private int getAnalyzerKind(IAnalyzerDescriptor desc) {
        IParameterStringEnum param = (IParameterStringEnum)desc.getParameterRegistry().getParameter("kind", 4);
        if (param != null) {
            return param.getOrdinalValue();
        }
        return 0;
    }

    private MeasureTable getTable(IMetricPlugin plugin, IAnalyzerRegistry registry, String[] metricIds, int analyzerKind) throws MeasureException {
        IMetric[] metrics = new IMetric[metricIds.length];
        int i = 0;
        while (i < metricIds.length) {
            IMetric mc = null;
            String id = metricIds[i];
            IAnalyzerDescriptor desc = registry.getDescriptor(id);
            if (desc != null) {
                mc = plugin.getMetric(desc);
            }
            if (mc == null) {
                throw new MeasureException("metric " + id + " not found");
            }
            metrics[i] = mc;
            ++i;
        }
        int i2 = 0;
        while (i2 < metrics.length - 1) {
            if (metrics[i2].getKind() != metrics[i2 + 1].getKind()) {
                throw new MeasureException("metrics are not compatible");
            }
            ++i2;
        }
        MeasureTable table = null;
        int kind = analyzerKind == 0 ? metrics[0].getKind() : analyzerKind;
        switch (kind) {
            case 1: {
                table = this.packageTable;
                break;
            }
            case 2: {
                table = this.classTable;
                break;
            }
            case 3: {
                table = this.methodTable;
            }
        }
        int i3 = 0;
        while (i3 < metrics.length) {
            table.addMetric(metrics[i3]);
            ++i3;
        }
        return table;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

