/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.proxygenerator;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ComponentScopedRefsDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ServiceRefDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.IDEProxyResolver;
import com.sap.ide.ws.proxygenerator.InternalHelperFunctions;
import com.sap.ide.ws.proxygenerator.LoadedWsdl;
import com.sap.ide.ws.proxygenerator.LogicalPortsAppender;
import com.sap.ide.ws.proxygenerator.LpDescriptor;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorException;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorWrapper;
import com.sap.ide.ws.proxygenerator.WsdlDescriptor;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.EntityResolver;

public class ProxyHelperFunctions {
    public static final String PROXYGENERATOR_PLUGIN_ID = "com.sap.ide.ws.proxygenerator";
    public static final String WEBSERVICE_LIBS_PLUGIN_ID = "com.sap.engine.webservices";
    public static final String EXCEPTION_PLUGIN_JAR = "com.sap.exception";
    public static final String WEBSERVICES_EXTLIBS_PLUGIN_ID = "com.sap.ext.libs.webservices";
    public static final String XML_PLUGIN_ID = "com.tssap.sap.libs.xmltoolkit";

    public static LoadedWsdl loadWsdl(String wsdlURL) throws Exception {
        return ProxyHelperFunctions.loadWsdl(wsdlURL, null, null);
    }

    public static LoadedWsdl loadWsdl(String wsdlURL, String proxyHost, String proxyPort) throws Exception {
        try {
            WSDLDOMLoader loader = new WSDLDOMLoader();
            WSDLDownloadResolver resolver = new WSDLDownloadResolver();
            resolver.setHTTPProxyResolver((HTTPProxyResolver)new IDEProxyResolver());
            loader.setWSDLResolver((EntityResolver)resolver);
            return new LoadedWsdl(wsdlURL, loader.loadWSDLDocument(wsdlURL));
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static String createSapWsdl(String wsdlURL) throws Exception {
        return ProxyHelperFunctions.createSapWsdlURL(wsdlURL, null, null);
    }

    public static String createSapWsdlURL(String wsdlURL, String proxyHost, String proxyPort) throws Exception {
        return ProxyHelperFunctions.createSapWsdlURL(ProxyHelperFunctions.loadWsdl(wsdlURL, proxyHost, proxyPort));
    }

    public static String createSapWsdlURL(LoadedWsdl loadedWsdl) {
        String wsdlURL = loadedWsdl.getUrl();
        if (!wsdlURL.startsWith("http://") && !wsdlURL.startsWith("https://")) {
            return wsdlURL;
        }
        if (loadedWsdl.isSapWsdl()) {
            return wsdlURL;
        }
        StringBuffer buf = new StringBuffer(wsdlURL);
        if (wsdlURL.indexOf("?") == -1) {
            buf.append("?");
        } else {
            buf.append("&");
        }
        buf.append("mode=sap_wsdl");
        return buf.toString();
    }

    public static Properties createNamespacePackageMappingFile(String wsdlURL, String outputPackage) throws Exception {
        return ProxyHelperFunctions.createNamespacePackageMappingFile(wsdlURL, null, null, outputPackage);
    }

    public static Properties createNamespacePackageMappingFile(String wsdlURL, String proxyHost, String proxyPort, String outputPackage) throws Exception {
        try {
            ProxyGenerator generator = new ProxyGenerator();
            ProxyGeneratorConfig config = new ProxyGeneratorConfig(wsdlURL, null, outputPackage);
            if (proxyHost != null && proxyHost.length() > 0) {
                config.setProxy(proxyHost, proxyPort);
            }
            generator.getDefaultSchemaMapping(config);
            return config.getUriToPackageMapping();
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static String[] getDefaultClasspath() {
        Vector librariesVect = new Vector();
        librariesVect.addAll(InternalHelperFunctions.getLibrariesFromPlugin(PROXYGENERATOR_PLUGIN_ID));
        librariesVect.addAll(InternalHelperFunctions.getLibrariesFromPlugin(WEBSERVICE_LIBS_PLUGIN_ID));
        librariesVect.addAll(InternalHelperFunctions.getLibrariesFromPlugin(EXCEPTION_PLUGIN_JAR));
        librariesVect.addAll(InternalHelperFunctions.getLibrariesFromPlugin(WEBSERVICES_EXTLIBS_PLUGIN_ID));
        librariesVect.addAll(InternalHelperFunctions.getLibrariesFromPlugin(XML_PLUGIN_ID));
        String[] libs = new String[librariesVect.size()];
        int i = 0;
        while (i < libs.length) {
            libs[i] = librariesVect.elementAt(i).toString();
            ++i;
        }
        return libs;
    }

    public static void changeProxyJNDIName(String[] descriptorFiles, String newJNDIName) throws Exception {
        try {
            int i = 0;
            while (i < descriptorFiles.length) {
                String file = descriptorFiles[i];
                file = file.replace('/', '\\');
                String fileName = (file = file.replace('\\', File.separatorChar)).substring(file.lastIndexOf(File.separatorChar) + 1);
                if (fileName.startsWith("ws-client")) {
                    ProxyHelperFunctions.changeProxyJNDIName(file, newJNDIName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static void changeProxyJNDIName(File[] descriptorFiles, String newJNDIName) throws Exception {
        try {
            int i = 0;
            while (i < descriptorFiles.length) {
                File file = descriptorFiles[i];
                if (file.getName().startsWith("ws-client")) {
                    ProxyHelperFunctions.changeProxyJNDIName(file.getAbsolutePath(), newJNDIName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    private static void changeProxyJNDIName(String descriptorLocation, String newJNDIName) throws Exception {
        try {
            WSClientDeploymentDescriptor desc = WSClientsParser.loadWSClientsDeploymentDescriptor((String)descriptorLocation);
            ComponentScopedRefsDescriptor[] components = desc.getComponentScopedRefs();
            ServiceRefDescriptor[] services = components.length > 0 ? components[0].getServiceRef() : desc.getServiceRef();
            if (services.length > 0) {
                services[0].setServiceRefName(newJNDIName);
            }
            WSClientsParser.saveWSClientsDeploymentDescriptor((WSClientDeploymentDescriptor)desc, (String)descriptorLocation);
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static void makeDefault(String lpPath) throws Exception {
        try {
            LogicalPortType port = InternalHelperFunctions.getLPType(lpPath);
            port.setDefault(true);
            InternalHelperFunctions.saveLogicalPort(port, lpPath, port.getName());
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static boolean isDefault(String lpPath) throws Exception {
        try {
            LogicalPortType port = InternalHelperFunctions.getLPType(lpPath);
            return port.getDefault();
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static void removeLP(String lpPath) throws Exception {
        try {
            InternalHelperFunctions.removeLPType(lpPath);
            new File(lpPath).delete();
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static LpDescriptor newLPFromExisting(String lpPath) throws Exception {
        try {
            return InternalHelperFunctions.newLPFromExisting(lpPath);
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw e;
        }
    }

    public static FileDescriptor[] createNewLPs(String srcDir, String newWsdlURL, FileDescriptor[] oldDescriptors) throws ProxyGeneratorException {
        return ProxyHelperFunctions.createNewLPs(srcDir, newWsdlURL, oldDescriptors, false);
    }

    public static FileDescriptor[] createNewLPs(String srcDir, String newWsdlURL, FileDescriptor[] oldDescriptors, boolean sldMode) throws ProxyGeneratorException {
        return ProxyHelperFunctions.createNewLPs(srcDir, newWsdlURL, oldDescriptors, null, null, sldMode);
    }

    public static FileDescriptor[] createNewLPs(String srcFullDir, String newWsdlURL, FileDescriptor[] oldDescriptors, String proxyHost, String proxyPort) throws ProxyGeneratorException {
        return ProxyHelperFunctions.createNewLPs(srcFullDir, newWsdlURL, oldDescriptors, proxyHost, proxyPort, false);
    }

    public static FileDescriptor[] createNewLPs(String srcFullDir, String newWsdlURL, FileDescriptor[] oldDescriptors, String proxyHost, String proxyPort, boolean sldMode) throws ProxyGeneratorException {
        try {
            LogicalPortsAppender appender;
            FileDescriptor[] descriptors;
            String sourceFolderName = null;
            String rootDir = null;
            String metaInfSubDir = null;
            int i = 0;
            while (i < oldDescriptors.length) {
                if (oldDescriptors[i] instanceof WsdlDescriptor) {
                    String relativePath = oldDescriptors[i].path;
                    String metaInfDir = new File(srcFullDir, relativePath).getCanonicalPath();
                    int index = metaInfDir.lastIndexOf("META-INF");
                    if (index > -1) {
                        rootDir = metaInfDir.substring(0, index - 1);
                        sourceFolderName = new File(srcFullDir).getCanonicalPath().substring(rootDir.length());
                        metaInfSubDir = new File(rootDir, ProxyGeneratorWrapper.META_INF_SUBDIR).getAbsolutePath() + File.separatorChar;
                    } else {
                        rootDir = srcFullDir;
                        sourceFolderName = "";
                        metaInfSubDir = new File(srcFullDir, "wsdls").getAbsolutePath() + File.separatorChar;
                    }
                }
                ++i;
            }
            if (sourceFolderName == null) {
                throw new ProxyGeneratorException("Cannot find any WSDL from the specified descriptors");
            }
            if (sourceFolderName.startsWith("\\") || sourceFolderName.startsWith("/")) {
                sourceFolderName = sourceFolderName.substring(1);
            }
            if ((descriptors = (appender = new LogicalPortsAppender(srcFullDir, sourceFolderName, rootDir, metaInfSubDir, newWsdlURL, oldDescriptors, proxyHost, proxyPort)).createNewLPs(sldMode)) == null) {
                return oldDescriptors;
            }
            return descriptors;
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw new ProxyGeneratorException("Cannot create new LPs", e);
        }
    }

    public static boolean isSLDLogicalPort(File lp) throws ProxyGeneratorException {
        try {
            return InternalHelperFunctions.isSLDLogicalPort(InternalHelperFunctions.getLogicalPortType(lp));
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            throw new ProxyGeneratorException("Cannot determine if this is an SLD Port", e);
        }
    }
}

