/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.proxygenerator;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ServiceRefDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.HelperClassDescriptor;
import com.sap.ide.ws.proxygenerator.HelperMetaDescriptor;
import com.sap.ide.ws.proxygenerator.InternalHelperFunctions;
import com.sap.ide.ws.proxygenerator.MetaDataDescriptor;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorException;
import com.sap.ide.ws.proxygenerator.SeiDescriptor;
import com.sap.ide.ws.proxygenerator.WsdlDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ProxyGeneratorWrapper {
    public static String META_INF_SUBDIR = "META-INF" + File.separatorChar + "ws-clients-descriptors";
    public static String PROXY_PACKAGE = "package";
    public static String LAST_WSDL = "wsdl";
    public static String RPC_STYLE = "rpc_style";
    public static String RPC_INTERFACES = "rpc_interfaces";
    public static String MAPPINGS_FILE = "mappings";
    public static String ID = "id";
    public static String CURRENT_WSDL = "current_wsdl";
    private String targetDirectory;
    private String metaInfSubDir;
    private String rootProjectDir;
    private String id;
    private String lportsFileName;
    private String packageMappingFileName;
    private String mappingsFileName;
    private String rootWSDLName;

    private void init(boolean standalone, String sourceSubFolderName) {
        new File(this.targetDirectory).mkdirs();
        if (!standalone) {
            String full = this.targetDirectory.replace('\\', '/');
            String relative = sourceSubFolderName.replace('\\', '/');
            if (!relative.endsWith("/")) {
                relative = relative + "/";
            }
            this.rootProjectDir = full.substring(0, full.length() - relative.length());
            this.metaInfSubDir = this.rootProjectDir + META_INF_SUBDIR + File.separatorChar;
            new File(this.metaInfSubDir).mkdirs();
            this.id = InternalHelperFunctions.getNextID(this.metaInfSubDir);
        } else {
            this.rootProjectDir = this.targetDirectory;
            this.id = InternalHelperFunctions.getNextID(this.targetDirectory);
        }
        this.lportsFileName = "lports_" + this.id + ".xml";
        this.packageMappingFileName = "package_mapping_" + this.id + ".properties";
    }

    private File saveWSDeploymentDescr(String jndiName, String serviceInterface, String packageName) throws Exception {
        WSClientDeploymentDescriptor descr = new WSClientDeploymentDescriptor();
        ServiceRefDescriptor service = new ServiceRefDescriptor();
        service.setLogicalPortsFile(this.lportsFileName);
        service.setWsdlFile(this.rootWSDLName);
        service.setServiceRefName(jndiName);
        service.setServiceInterface(serviceInterface);
        service.setPackageName(packageName);
        service.setUriMappingFile(this.mappingsFileName);
        if (this.packageMappingFileName != null) {
            service.setPackageMappingFile(this.packageMappingFileName);
        }
        ServiceRefDescriptor[] services = new ServiceRefDescriptor[]{service};
        descr.setServiceRef(services);
        descr.setVersion("6.30.1");
        String descriptorLocation = this.metaInfSubDir + "ws-clients-deployment-descriptor_" + this.id + ".xml";
        WSClientsParser.saveWSClientsDeploymentDescriptor((WSClientDeploymentDescriptor)descr, (String)descriptorLocation);
        return new File(descriptorLocation);
    }

    public static void addSEIsToVector(String srcDir, ProxyGeneratorConfig config, Vector fdvect) {
        int targetDirLength = srcDir.length();
        File[] seis = config.getGeneratedSEIFiles();
        int i = 0;
        while (i < seis.length) {
            File sei = seis[i];
            String path = sei.getParent().substring(targetDirLength);
            String name = sei.getName();
            String qualifiedName = (config.getOutputPackage() + File.separatorChar + name).replace('\\', '.');
            qualifiedName = qualifiedName.replace('/', '.');
            qualifiedName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            ProxyGeneratorWrapper.addDescriptor(fdvect, new SeiDescriptor(path, name, qualifiedName));
            ++i;
        }
    }

    public static String addSIsToVector(String srcDir, ProxyGeneratorConfig config, Vector fdvect) {
        int targetDirLength = srcDir.length();
        String serviceInterface = null;
        File[] sis = config.getGeneratedServices();
        int i = 0;
        while (i < sis.length) {
            File si = sis[i];
            String path = si.getParent().substring(targetDirLength);
            String name = si.getName();
            String qualifiedName = (config.getOutputPackage() + File.separatorChar + name).replace('\\', '.');
            qualifiedName = qualifiedName.replace('/', '.');
            if ((qualifiedName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."))).startsWith(".")) {
                qualifiedName = qualifiedName.substring(1);
            }
            ProxyGeneratorWrapper.addDescriptor(fdvect, new SeiDescriptor(path, name, qualifiedName));
            serviceInterface = qualifiedName;
            ++i;
        }
        return serviceInterface;
    }

    private static String getRelativeToProjectPath(String srcDirName) {
        String relativeToProject = "../";
        srcDirName = srcDirName.replace('\\', '/');
        int index = srcDirName.indexOf("/");
        while (index != -1) {
            relativeToProject = relativeToProject + "../";
            index = srcDirName.indexOf("/", index + 1);
        }
        return relativeToProject.replace('/', File.separatorChar);
    }

    public static void addWSDLsToVector(String projectRootDir, String srcDirName, File[] wsdlFiles, Vector fdvect) throws IOException {
        String relativeToProject = ProxyGeneratorWrapper.getRelativeToProjectPath(srcDirName);
        int targetDirLength = projectRootDir.length();
        if (!projectRootDir.endsWith("/") && !projectRootDir.endsWith("\\")) {
            ++targetDirLength;
        }
        if (wsdlFiles.length > 0) {
            String wsdlsDir = wsdlFiles[0].getParentFile().getCanonicalPath().substring(targetDirLength);
            String dirName = "wsdls".equalsIgnoreCase(wsdlsDir) ? wsdlsDir : relativeToProject + wsdlsDir;
            WsdlDescriptor rootWSDL = new WsdlDescriptor(dirName, wsdlFiles[0].getName());
            int i = 0;
            while (i < wsdlFiles.length) {
                File wsdl = wsdlFiles[i];
                rootWSDL.addChildWSDL(new WsdlDescriptor(relativeToProject + wsdl.getParent().substring(targetDirLength), wsdl.getName()));
                ++i;
            }
            ProxyGeneratorWrapper.addDescriptor(fdvect, rootWSDL);
        }
    }

    private static boolean added(String relativePath, String name, Vector fdvect) {
        int i = 0;
        while (i < fdvect.size()) {
            FileDescriptor fd = (FileDescriptor)fdvect.elementAt(i);
            if (fd.name.equals(name) && fd.path.equals(relativePath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addHelperFilesToVector(String srcDir, ProxyGeneratorConfig config, Vector fdvect) {
        int targetDirLength = srcDir.length();
        File[] files = config.getAllGeneratedFiles();
        int i = 0;
        while (i < files.length) {
            String name;
            File file = files[i];
            String relativePath = file.getParent().substring(targetDirLength);
            if (relativePath.replace('\\', '/').startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (InternalHelperFunctions.getExtension(name = file.getName()).equals("java")) {
                if (!ProxyGeneratorWrapper.added(relativePath, name, fdvect)) {
                    String qualifiedName = (relativePath + File.separatorChar + name).replace('\\', '.');
                    qualifiedName = qualifiedName.replace('/', '.');
                    qualifiedName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                    ProxyGeneratorWrapper.addDescriptor(fdvect, new HelperClassDescriptor(relativePath, name, qualifiedName));
                }
            } else if (!(file.getAbsolutePath().indexOf("META-INF\\ws-clients-descriptors") != -1 || file.getAbsolutePath().indexOf("META-INF/ws-clients-descriptors") != -1 || name.startsWith("lports") && name.indexOf("tmp") != -1)) {
                ProxyGeneratorWrapper.addDescriptor(fdvect, new HelperMetaDescriptor(relativePath, name));
            }
            ++i;
        }
    }

    public static void addMetaFileToVector(String projectRootDir, String srcDirName, File file, Vector fdvect) {
        String path;
        int targetDirLength = projectRootDir.length();
        if (!projectRootDir.endsWith("/") && !projectRootDir.endsWith("\\")) {
            ++targetDirLength;
        }
        if ((path = file.getParent().substring(targetDirLength)).toUpperCase().startsWith("META-INF/") || path.toUpperCase().startsWith("META-INF\\")) {
            ProxyGeneratorWrapper.addDescriptor(fdvect, new MetaDataDescriptor(ProxyGeneratorWrapper.getRelativeToProjectPath(srcDirName) + path, file.getName()));
        } else {
            ProxyGeneratorWrapper.addDescriptor(fdvect, new HelperMetaDescriptor(path, file.getName()));
        }
    }

    static void addDescriptor(Vector vector, FileDescriptor desc) {
        if (!vector.contains(desc)) {
            vector.addElement(desc);
        }
    }

    private void addMetaDataToVector(File[] files, Vector fdvect, String srcDirName) {
        int targetDirLength = this.rootProjectDir.length();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String path = file.getParent().substring(targetDirLength);
            if (path.toUpperCase().startsWith("META-INF/") || path.toUpperCase().startsWith("META-INF\\")) {
                MetaDataDescriptor metaDataDescriptor = new MetaDataDescriptor(ProxyGeneratorWrapper.getRelativeToProjectPath(srcDirName) + path, file.getName());
                ProxyGeneratorWrapper.addDescriptor(fdvect, metaDataDescriptor);
            } else {
                path = file.getParent().substring(this.targetDirectory.length());
                HelperMetaDescriptor helperMetaDescriptor = new HelperMetaDescriptor(path, file.getName());
                ProxyGeneratorWrapper.addDescriptor(fdvect, helperMetaDescriptor);
            }
            ++i;
        }
    }

    public File saveProxyDefinitionInfoFile(String directory, String packageName, boolean rpcStyle, boolean rpcInterfaces) throws IOException {
        File fileLocation = new File(directory, "info_" + this.id + ".properties");
        Properties props = new Properties();
        props.setProperty(PROXY_PACKAGE, packageName);
        props.setProperty(RPC_STYLE, rpcStyle ? "1" : "0");
        props.setProperty(RPC_INTERFACES, rpcInterfaces ? "1" : "0");
        if (this.mappingsFileName != null) {
            props.setProperty(MAPPINGS_FILE, this.mappingsFileName);
        }
        props.setProperty(ID, this.id);
        props.setProperty(CURRENT_WSDL, this.rootWSDLName);
        props.store(new FileOutputStream(fileLocation), "Please do not edit this file!");
        return fileLocation;
    }

    private File savePackageMapping(Properties uriMapping) throws IOException {
        File mapping = new File(this.metaInfSubDir, this.packageMappingFileName);
        FileOutputStream out = new FileOutputStream(mapping);
        uriMapping.store(out, "Please do not edit this file!");
        out.close();
        return mapping;
    }

    public synchronized FileDescriptor[] generateStandAlone(String wsdlName, String targetPackage, String targetDirectory, String sourceFolderName, boolean style, boolean jaxrpcServiceInterfaces) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, sourceFolderName, style, null, jaxrpcServiceInterfaces, true, null);
    }

    public synchronized FileDescriptor[] generateStandAlone(String wsdlName, String targetPackage, String targetDirectory, boolean style, boolean jaxrpcServiceInterfaces) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, null, style, null, jaxrpcServiceInterfaces, true, null);
    }

    public synchronized FileDescriptor[] generateStandAlone(String wsdlName, String targetPackage, String targetDirectory, String sourceFolderName, boolean style, boolean jaxrpcServiceInterfaces, Properties uriMapping) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, sourceFolderName, style, sourceFolderName, jaxrpcServiceInterfaces, true, uriMapping);
    }

    public synchronized FileDescriptor[] generateStandAlone(String wsdlName, String targetPackage, String targetDirectory, boolean style, boolean jaxrpcServiceInterfaces, Properties uriMapping) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, null, style, null, jaxrpcServiceInterfaces, true, uriMapping);
    }

    public synchronized FileDescriptor[] generate(String wsdlName, String targetPackage, String targetDirectory, String sourceFolderName, boolean style, String jndiName, boolean jaxrpcServiceInterfaces) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, sourceFolderName, style, jndiName, jaxrpcServiceInterfaces, false, null);
    }

    public synchronized FileDescriptor[] generate(String wsdlName, String targetPackage, String targetDirectory, boolean style, String jndiName, boolean jaxrpcServiceInterfaces) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, null, style, jndiName, jaxrpcServiceInterfaces, false, null);
    }

    public synchronized FileDescriptor[] generate(String wsdlName, String targetPackage, String targetDirectory, String sourceFolderName, boolean style, String jndiName, boolean jaxrpcServiceInterfaces, Properties uriMapping) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, sourceFolderName, style, jndiName, jaxrpcServiceInterfaces, false, uriMapping);
    }

    public synchronized FileDescriptor[] generate(String wsdlName, String targetPackage, String targetDirectory, boolean style, String jndiName, boolean jaxrpcServiceInterfaces, Properties uriMapping) throws ProxyGeneratorException {
        return this.generateProxy(wsdlName, targetPackage, targetDirectory, null, style, jndiName, jaxrpcServiceInterfaces, false, uriMapping);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized FileDescriptor[] generateProxy(String wsdlName, String targetPackage, String targetDirectory, String sourceFolderName, boolean style, String jndiName, boolean jaxrpcServiceInterfaces, boolean standalone, Properties uriMapping) throws ProxyGeneratorException {
        proxyHost = System.getProperty("proxyHost");
        proxyPort = System.getProperty("proxyPort");
        nonProxyHosts = System.getProperty("http.nonProxyHosts");
        fdvect = new Vector<E>();
        try {
            this.targetDirectory = targetDirectory.replace('\\', '/');
            this.targetDirectory = targetDirectory.replace('/', File.separatorChar);
            if (this.targetDirectory.length() > 0 && this.targetDirectory.charAt(this.targetDirectory.length() - 1) != File.separatorChar) {
                this.targetDirectory = this.targetDirectory + File.separator;
            }
            this.init(standalone, sourceFolderName);
            idMapping = new Properties();
            mappingsFile = new StringBuffer();
            directoryToSave = standalone != false ? new File(targetDirectory, "wsdls").getCanonicalPath() : this.metaInfSubDir;
            new File(directoryToSave).mkdirs();
            wsdlFiles = InternalHelperFunctions.downloadWSDL(wsdlName, targetDirectory, sourceFolderName, this.rootProjectDir, directoryToSave, this.id, idMapping, mappingsFile, fdvect, proxyHost, proxyPort);
            this.mappingsFileName = mappingsFile.toString();
            this.rootWSDLName = wsdlFiles[0].getName();
            serviceInterface = standalone == false ? InternalHelperFunctions.generateInterfaces(targetDirectory, this.rootProjectDir, this.metaInfSubDir, this.lportsFileName, wsdlFiles[0].getAbsolutePath(), idMapping, targetPackage, style, jaxrpcServiceInterfaces, fdvect, standalone, uriMapping) : InternalHelperFunctions.generateInterfaces(targetDirectory, this.rootProjectDir, null, this.lportsFileName, wsdlName, null, targetPackage, style, jaxrpcServiceInterfaces, fdvect, standalone, uriMapping);
            InternalHelperFunctions.addLPorts(targetDirectory, this.rootProjectDir, this.metaInfSubDir, this.lportsFileName, this.id, targetPackage, fdvect, standalone);
            if (!standalone) {
                if (uriMapping != null) {
                    others = new File[4];
                    others[3] = this.savePackageMapping(uriMapping);
                } else {
                    others = new File[3];
                    this.packageMappingFileName = null;
                }
                others[0] = new File(this.metaInfSubDir, this.lportsFileName);
                others[1] = this.saveWSDeploymentDescr(jndiName, serviceInterface, targetPackage);
                others[2] = this.saveProxyDefinitionInfoFile(this.metaInfSubDir, targetPackage, style, jaxrpcServiceInterfaces);
            } else {
                others = new File[1];
                genDir = new File(this.targetDirectory, targetPackage.replace('.', File.separatorChar));
                others[0] = this.saveProxyDefinitionInfoFile(genDir.getAbsolutePath(), targetPackage, style, jaxrpcServiceInterfaces);
            }
            this.addMetaDataToVector(others, fdvect, sourceFolderName);
            fd = new FileDescriptor[fdvect.size()];
            fdvect.copyInto(fd);
            return fd;
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            i = 0;
            ** while (i < fdvect.size())
        }
lbl-1000:
        // 1 sources

        {
            desc = (FileDescriptor)fdvect.elementAt(i);
            dir = new File(targetDirectory, desc.path);
            f = new File(dir, desc.name);
            f.delete();
            ++i;
            continue;
        }
lbl50:
        // 1 sources

        throw new ProxyGeneratorException("Problems while generating the Proxy Definition!", e);
    }

    public static void log(Throwable e) {
        Plugin plugin = Platform.getPlugin((String)"com.sap.ide.ws.proxygenerator");
        Status status = new Status(4, "com.sap.ide.ws.proxygenerator", -1, e.toString(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static void main(String[] arfs) throws Exception {
        ProxyGeneratorWrapper pw = new ProxyGeneratorWrapper();
        FileDescriptor[] fd = pw.generateStandAlone("http://localhost:52000/EchoService/EchoServiceSoap?wsdl", "test.test", "d:/opit/webservices/testWS/gen", false, false);
        int i = 0;
        while (i < fd.length) {
            System.out.println(fd[i]);
            ++i;
        }
        System.out.println("..........");
    }
}

