/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.proxygenerator;

import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ComponentScopedRefsDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ServiceRefDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.InternalHelperFunctions;
import com.sap.ide.ws.proxygenerator.MetaDataDescriptor;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorException;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorWrapper;
import com.sap.ide.ws.proxygenerator.TypeMappingHandler;
import com.sap.ide.ws.proxygenerator.WsdlDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.helpers.DefaultHandler;

public class LogicalPortsAppender {
    private String srcDir;
    private String metaInfDir;
    private String rootProjectDir;
    private String srcDirName;
    private String newWsdlURL;
    private FileDescriptor[] oldDescriptors;
    private String proxyHost;
    private String proxyPort;
    private boolean rpcStyle;
    private boolean rpcServiceInterfaces;
    private boolean sapWSDL = false;
    private String oldMappingsFile;
    private String proxyDefinitionID;
    private String oldRootWSDL;
    private String proxyPackageName;
    private String wsClientsDeploymentDescrFileName;
    private String mappingsFileName;
    private String oldLPortsFileName;
    private String newLPortsFileName;
    private File newRootWSDL;
    private Properties newWSDLMapping;
    private Vector newFileDescriptors = new Vector();

    public LogicalPortsAppender(String srcDir, String srcDirName, String rootProjectDir, String metaInfDir, String newWsdlURL, FileDescriptor[] oldDescriptors, String proxyHost, String proxyPort) throws ProxyGeneratorException {
        try {
            this.srcDir = srcDir;
            this.srcDirName = srcDirName;
            this.metaInfDir = metaInfDir;
            this.rootProjectDir = rootProjectDir;
            this.newWsdlURL = newWsdlURL;
            this.oldDescriptors = oldDescriptors;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            Properties infoProperties = this.getProxyDefinitionProperties();
            this.oldMappingsFile = infoProperties.getProperty(ProxyGeneratorWrapper.MAPPINGS_FILE);
            this.proxyDefinitionID = infoProperties.getProperty(ProxyGeneratorWrapper.ID);
            this.oldRootWSDL = infoProperties.getProperty(ProxyGeneratorWrapper.CURRENT_WSDL);
            this.proxyPackageName = infoProperties.getProperty(ProxyGeneratorWrapper.PROXY_PACKAGE);
            String rpcStyleString = infoProperties.getProperty(ProxyGeneratorWrapper.RPC_STYLE);
            String rpcServiceInterfacesString = infoProperties.getProperty(ProxyGeneratorWrapper.RPC_INTERFACES);
            if (this.oldMappingsFile == null || this.proxyDefinitionID == null || this.oldRootWSDL == null || this.proxyPackageName == null || rpcStyleString == null || rpcServiceInterfacesString == null) {
                throw new ProxyGeneratorException("Invalid Info properties file! You have to regenerate the Proxy Definition!");
            }
            this.rpcStyle = rpcStyleString.trim().equals("1");
            this.rpcServiceInterfaces = rpcServiceInterfacesString.trim().equals("1");
            this.oldLPortsFileName = "lports_" + this.proxyDefinitionID + ".xml";
            this.newLPortsFileName = "lports_" + this.proxyDefinitionID + "_tmp.xml";
            this.wsClientsDeploymentDescrFileName = "ws-clients-deployment-descriptor_" + this.proxyDefinitionID + ".xml";
        }
        catch (ProxyGeneratorException pgE) {
            throw pgE;
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("Problems while initializing the Logical Ports Appender!", e);
        }
    }

    private Properties getProxyDefinitionProperties() throws ProxyGeneratorException, IOException {
        int i = 0;
        while (i < this.oldDescriptors.length) {
            FileDescriptor descriptor = this.oldDescriptors[i];
            if (descriptor instanceof MetaDataDescriptor && descriptor.name.startsWith("info") && descriptor.name.endsWith(".properties")) {
                File infoFile = new File(this.metaInfDir, descriptor.name);
                if (!infoFile.exists()) {
                    File packageDir = new File(this.srcDir, descriptor.path);
                    infoFile = new File(packageDir, descriptor.name);
                }
                Properties props = new Properties();
                props.load(new FileInputStream(infoFile));
                return props;
            }
            ++i;
        }
        throw new ProxyGeneratorException("Cannot load proxy definition properties file! You have to regenerate the Proxy Definition!");
    }

    public FileDescriptor[] createNewLPs(boolean sldMode) throws ProxyGeneratorException {
        try {
            MessageDialog dlg;
            if (!this.checkPortTypes() && (dlg = new MessageDialog(Display.getCurrent().getActiveShell(), "Warning", null, "The new WSDL is not the same as the old one. The proxy definition will be regenerated, continue?", 4, new String[]{"Yes", "No"}, 0)).open() != 0) {
                return null;
            }
            boolean standalone = this.regenerateInterfaces();
            this.addWSDLToDeploymentDescriptor();
            this.uniteNewLPsWithOldOnes(sldMode, standalone);
            this.addOldMetaFiles();
            Object[] descriptors = new FileDescriptor[this.newFileDescriptors.size()];
            this.newFileDescriptors.copyInto(descriptors);
            return descriptors;
        }
        catch (ProxyGeneratorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProxyGeneratorException("Problems while creating new logical ports!", e);
        }
    }

    private void addOldMetaFiles() {
        int i = 0;
        while (i < this.oldDescriptors.length) {
            String name;
            FileDescriptor desc = this.oldDescriptors[i];
            String path = desc.path.toUpperCase().replace('\\', '/');
            if (path.endsWith("META-INF/WS-CLIENTS-DESCRIPTORS") && !(name = desc.name).startsWith("lports")) {
                ProxyGeneratorWrapper.addDescriptor(this.newFileDescriptors, desc);
            }
            ++i;
        }
    }

    private ServiceRefDescriptor[] getServiceReferences(WSClientDeploymentDescriptor descr) throws ProxyGeneratorException {
        ComponentScopedRefsDescriptor[] components = descr.getComponentScopedRefs();
        ServiceRefDescriptor[] refs = components.length > 0 ? components[0].getServiceRef() : descr.getServiceRef();
        if (refs.length <= 0) {
            throw new ProxyGeneratorException("Invalid deployment descriptor. Cannot find any Service References.");
        }
        return refs;
    }

    private void addWSDLToDeploymentDescriptor() throws Exception {
        File dd = new File(this.metaInfDir, this.wsClientsDeploymentDescrFileName);
        if (dd.exists()) {
            WSClientDeploymentDescriptor descr = WSClientsParser.loadWSClientsDeploymentDescriptor((String)dd.getAbsolutePath());
            ServiceRefDescriptor serviceRef = this.getServiceReferences(descr)[0];
            String newWSDLFile = serviceRef.getWsdlFile() + ";" + this.newRootWSDL.getName();
            String newMappingsFile = serviceRef.getUriMappingFile() + ";" + this.mappingsFileName;
            serviceRef.setWsdlFile(newWSDLFile);
            serviceRef.setUriMappingFile(newMappingsFile);
            WSClientsParser.saveWSClientsDeploymentDescriptor((WSClientDeploymentDescriptor)descr, (String)dd.getAbsolutePath());
        }
    }

    private boolean checkPortTypes() throws Exception {
        Properties oldWsdlFileMapping = new Properties();
        oldWsdlFileMapping.load(new FileInputStream(new File(this.metaInfDir, this.oldMappingsFile)));
        this.newWSDLMapping = new Properties();
        StringBuffer mappingsFile = new StringBuffer();
        File[] downloadedWSDLs = InternalHelperFunctions.downloadWSDL(this.newWsdlURL, this.srcDir, this.srcDirName, this.rootProjectDir, this.metaInfDir, this.proxyDefinitionID, this.newWSDLMapping, mappingsFile, this.newFileDescriptors, this.proxyHost, this.proxyPort);
        this.mappingsFileName = mappingsFile.toString();
        this.newRootWSDL = downloadedWSDLs[0];
        ArrayList oldPortTypes = this.getPortTypes(new File(this.metaInfDir, this.oldRootWSDL), oldWsdlFileMapping, false);
        ArrayList newPortTypes = this.getPortTypes(this.newRootWSDL, this.newWSDLMapping, true);
        int i = 0;
        while (i < oldPortTypes.size()) {
            WSDLPortType oldType = (WSDLPortType)oldPortTypes.get(i);
            boolean found = false;
            int j = 0;
            while (j < newPortTypes.size()) {
                WSDLPortType newType = (WSDLPortType)newPortTypes.get(i);
                if (this.comparePortTypes(oldType, newType)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean comparePortTypes(WSDLPortType oldType, WSDLPortType newType) {
        if (!oldType.getQName().equals((Object)newType.getQName())) {
            return false;
        }
        ArrayList oldOperations = oldType.getOperations();
        ArrayList newOperations = newType.getOperations();
        if (oldOperations == null || newOperations == null) {
            return oldOperations == null && newOperations == null;
        }
        if (oldOperations.size() != newOperations.size()) {
            return false;
        }
        int i = 0;
        while (i < oldOperations.size()) {
            WSDLOperation oldOperation = (WSDLOperation)oldOperations.get(i);
            QName oldOperationName = oldOperation.getQName();
            boolean found = false;
            int j = 0;
            while (j < newOperations.size()) {
                WSDLOperation newOperation = (WSDLOperation)newOperations.get(j);
                if (oldOperationName.equals((Object)newOperation.getQName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ArrayList getPortTypes(File rootWSDL, Hashtable wsdlFileMapping, boolean updateSapWSDLStatus) throws WSDLException {
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = loader.loadMirrorWSDLDocument(rootWSDL.getAbsolutePath(), wsdlFileMapping);
        if (updateSapWSDLStatus && definitions.isSapWsdl()) {
            this.sapWSDL = true;
        }
        return definitions.getPortTypes();
    }

    private void deleteOldGeneratedFiles() {
        int i = 0;
        while (i < this.oldDescriptors.length) {
            FileDescriptor desc = this.oldDescriptors[i];
            if (!(desc instanceof WsdlDescriptor) && !(desc instanceof MetaDataDescriptor)) {
                String path = desc.path.toUpperCase().replace('\\', '/');
                File dir = new File(this.srcDir, desc.path);
                File file = new File(dir, desc.name);
                file.delete();
            } else {
                ProxyGeneratorWrapper.addDescriptor(this.newFileDescriptors, desc);
            }
            ++i;
        }
    }

    private boolean regenerateInterfaces() throws Exception {
        File dd = new File(this.metaInfDir, this.wsClientsDeploymentDescrFileName);
        Properties uriMapping = null;
        if (dd.exists()) {
            WSClientDeploymentDescriptor descr = WSClientsParser.loadWSClientsDeploymentDescriptor((String)dd.getAbsolutePath());
            ServiceRefDescriptor serviceRef = this.getServiceReferences(descr)[0];
            File mappingsFile = new File(this.metaInfDir, serviceRef.getPackageMappingFile());
            if (mappingsFile.exists()) {
                uriMapping = new Properties();
                FileInputStream in = new FileInputStream(mappingsFile);
                uriMapping.load(in);
                in.close();
            }
        } else {
            int i = 0;
            while (i < this.oldDescriptors.length) {
                File packageDir;
                File typesXML;
                if (this.oldDescriptors[i] instanceof MetaDataDescriptor && "types.xml".equalsIgnoreCase(this.oldDescriptors[i].name) && (typesXML = new File(packageDir = new File(this.srcDir, this.oldDescriptors[i].path), this.oldDescriptors[i].name)).exists()) {
                    SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
                    SAXParser parser = factory.newSAXParser();
                    TypeMappingHandler handler = new TypeMappingHandler();
                    parser.parse(typesXML, (DefaultHandler)handler);
                    uriMapping = handler.getMapping();
                }
                ++i;
            }
        }
        this.deleteOldGeneratedFiles();
        boolean standalone = this.metaInfDir.toUpperCase().endsWith("WSDLS") || this.metaInfDir.toUpperCase().endsWith("WSDLS" + File.separator);
        InternalHelperFunctions.generateInterfaces(this.srcDir, this.rootProjectDir, this.metaInfDir, this.newLPortsFileName, this.newRootWSDL.getAbsolutePath(), this.newWSDLMapping, this.proxyPackageName, this.rpcStyle, this.rpcServiceInterfaces, this.newFileDescriptors, standalone, uriMapping);
        return standalone;
    }

    private void uniteNewLPsWithOldOnes(boolean sldMode, boolean standalone) throws Exception {
        File lpsDir = standalone ? new File(this.srcDir, this.proxyPackageName.replace('.', File.separatorChar)) : new File(this.metaInfDir);
        LogicalPorts oldPorts = this.getLPorts(this.oldLPortsFileName, lpsDir);
        LogicalPortType[] oldLPs = oldPorts.getLogicalPort();
        LogicalPorts newPorts = this.getLPorts(this.newLPortsFileName, lpsDir);
        LogicalPortType[] newLPs = newPorts.getLogicalPort();
        Vector<LogicalPortType> unitedLPs = new Vector<LogicalPortType>(oldLPs.length + newLPs.length);
        Vector<String> unitedLPsNames = new Vector<String>(oldLPs.length + newLPs.length);
        int i = 0;
        while (i < oldLPs.length) {
            LogicalPortType oldLP = oldLPs[i];
            unitedLPs.addElement(oldLP);
            unitedLPsNames.addElement(oldLP.getName());
            ++i;
        }
        int i2 = 0;
        while (i2 < newLPs.length) {
            LogicalPortType newLP = newLPs[i2];
            if (sldMode) {
                newLP.setSLDWS("");
                newLP.setSLDWSPort("");
                newLP.setSystemName("");
            }
            int id = 2;
            String originalName = newLP.getName();
            while (unitedLPsNames.contains(newLP.getName())) {
                newLP.setName(originalName + id++);
            }
            unitedLPs.addElement(newLP);
            ++i2;
        }
        Object[] unitedLogicalPorts = new LogicalPortType[unitedLPs.size()];
        unitedLPs.copyInto(unitedLogicalPorts);
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts ports = oldPorts;
        if (ports.getInterfaceName() == null) {
            ports = newPorts;
        }
        ports.setLogicalPort((LogicalPortType[])unitedLogicalPorts);
        File lportsXMLFile = new File(lpsDir, this.oldLPortsFileName);
        factory.saveLogicalPorts(ports, lportsXMLFile);
        new File(lpsDir, this.newLPortsFileName).delete();
        InternalHelperFunctions.addLPorts(this.srcDir, this.rootProjectDir, this.metaInfDir, this.oldLPortsFileName, this.proxyDefinitionID, this.proxyPackageName, this.newFileDescriptors, standalone);
        ProxyGeneratorWrapper.addMetaFileToVector(this.rootProjectDir, this.srcDirName, lportsXMLFile, this.newFileDescriptors);
    }

    private LogicalPorts getLPorts(String lportsFileName, File lpsDir) throws Exception {
        File lportsFile = new File(lpsDir, lportsFileName);
        if (!lportsFile.exists()) {
            return new LogicalPorts();
        }
        LogicalPortFactory factory = new LogicalPortFactory();
        FileInputStream in = new FileInputStream(lportsFile);
        LogicalPorts ports = factory.loadLogicalPorts((InputStream)in);
        ((InputStream)in).close();
        return ports;
    }
}

