/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.proxygenerator;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.services.webservices.jaxrpc.exceptions.LogicalPortException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.engine.services.webservices.wsdl.WSDLImportTool;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.IDEProxyResolver;
import com.sap.ide.ws.proxygenerator.LpDescriptor;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorException;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorWrapper;
import com.sap.ide.ws.proxygenerator.ProxyHelperFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class InternalHelperFunctions {
    public static final String NAME_PROP = "name";
    public static final String ID_PROP = "id";
    public static final String META_INF_SUB_DIR_PROP = "metaInfSubDir";
    public static final String LPORTS_NAME_PROP = "lports";

    public static Vector getLibrariesFromPlugin(String pluginID) {
        Plugin plugin = Platform.getPlugin((String)pluginID);
        ILibrary[] libraries = plugin.getDescriptor().getRuntimeLibraries();
        Vector<String> librariesVect = new Vector<String>();
        int i = 0;
        while (i < libraries.length) {
            URL url = plugin.find(libraries[i].getPath());
            if (url != null) {
                librariesVect.addElement(url.getFile());
            }
            ++i;
        }
        return librariesVect;
    }

    public static Properties getLPProperties(String lpFile) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(lpFile);
        props.load(in);
        ((InputStream)in).close();
        return props;
    }

    public static File getLportsXML(Properties lpProperties, String lpPath) throws Exception {
        String path = lpProperties.getProperty(META_INF_SUB_DIR_PROP);
        String name = lpProperties.getProperty(LPORTS_NAME_PROP);
        if (path == null || name == null) {
            throw new Exception("Incorrect LP file is passed!");
        }
        File lpFile = new File(lpPath);
        File metaInfDir = new File(lpFile.getParentFile(), path);
        File lpsXMLFile = new File(metaInfDir, name);
        return lpsXMLFile;
    }

    private static LogicalPortType[] getLogicalPorts(Properties lpProperties, String lpPath) throws Exception {
        File lportsXML = InternalHelperFunctions.getLportsXML(lpProperties, lpPath);
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts lpPorts = factory.loadLogicalPorts(lportsXML);
        return lpPorts.getLogicalPort();
    }

    public static LogicalPortType getLPType(String lpFile) throws Exception {
        Properties props = InternalHelperFunctions.getLPProperties(lpFile);
        String name = props.getProperty(NAME_PROP);
        if (name == null) {
            throw new Exception("Incorrect LP file is passed: " + lpFile);
        }
        LogicalPortType[] ports = InternalHelperFunctions.getLogicalPorts(props, lpFile);
        int i = 0;
        while (i < ports.length) {
            if (name.equals(ports[i].getName())) {
                return ports[i];
            }
            ++i;
        }
        return null;
    }

    public static void saveLogicalPort(LogicalPortType lp, String lpFile, String oldLpName) throws Exception {
        Properties props = InternalHelperFunctions.getLPProperties(lpFile);
        File lportsXML = InternalHelperFunctions.getLportsXML(props, lpFile);
        boolean defaultStatusIsChanged = lp.getDefault();
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts ports = factory.loadLogicalPorts(lportsXML);
        LogicalPortType[] portTypes = ports.getLogicalPort();
        Vector<LogicalPortType> newPortTypesVector = new Vector<LogicalPortType>(portTypes.length + 1);
        int i = 0;
        while (i < portTypes.length) {
            LogicalPortType port = portTypes[i];
            if (!oldLpName.equals(port.getName())) {
                if (defaultStatusIsChanged) {
                    port.setDefault(false);
                }
                newPortTypesVector.addElement(port);
            }
            ++i;
        }
        newPortTypesVector.addElement(lp);
        LogicalPortType[] newPortTypes = new LogicalPortType[newPortTypesVector.size()];
        int i2 = 0;
        while (i2 < newPortTypesVector.size()) {
            newPortTypes[i2] = (LogicalPortType)newPortTypesVector.elementAt(i2);
            ++i2;
        }
        ports.setLogicalPort(newPortTypes);
        factory.saveLogicalPorts(ports, lportsXML);
        if (!lp.getName().equals(props.getProperty(NAME_PROP))) {
            props.setProperty(NAME_PROP, lp.getName());
            FileOutputStream out = new FileOutputStream(lpFile);
            props.store(out, "Please, do not edit this file!");
            ((OutputStream)out).close();
        }
    }

    public static void removeLPType(String lpFile) throws Exception {
        Properties props = InternalHelperFunctions.getLPProperties(lpFile);
        String name = props.getProperty(NAME_PROP);
        File lportsXML = InternalHelperFunctions.getLportsXML(props, lpFile);
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts ports = factory.loadLogicalPorts(lportsXML);
        LogicalPortType[] portTypes = ports.getLogicalPort();
        Vector<LogicalPortType> newPortTypesVector = new Vector<LogicalPortType>(portTypes.length);
        boolean isDefault = false;
        int i = 0;
        while (i < portTypes.length) {
            LogicalPortType port = portTypes[i];
            if (!name.equals(port.getName())) {
                newPortTypesVector.addElement(port);
            } else {
                isDefault = port.getDefault();
            }
            ++i;
        }
        Object[] newPortTypes = new LogicalPortType[newPortTypesVector.size()];
        newPortTypesVector.copyInto(newPortTypes);
        if (isDefault && newPortTypes.length > 0) {
            newPortTypes[0].setDefault(true);
        }
        ports.setLogicalPort((LogicalPortType[])newPortTypes);
        factory.saveLogicalPorts(ports, lportsXML);
    }

    public static LpDescriptor newLPFromExisting(String lpFile) throws Exception {
        File f;
        Properties props = InternalHelperFunctions.getLPProperties(lpFile);
        String name = props.getProperty(NAME_PROP);
        String id = props.getProperty(ID_PROP);
        File lportsXML = InternalHelperFunctions.getLportsXML(props, lpFile);
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts ports = factory.loadLogicalPorts(lportsXML);
        LogicalPortType[] portTypes = ports.getLogicalPort();
        Vector<LogicalPortType> newPortTypesVector = new Vector<LogicalPortType>(portTypes.length);
        Vector<String> portTypeNames = new Vector<String>();
        LogicalPortType portToClone = null;
        int i = 0;
        while (i < portTypes.length) {
            LogicalPortType port = portTypes[i];
            newPortTypesVector.addElement(port);
            portTypeNames.addElement(port.getName());
            if (name.equals(port.getName())) {
                portToClone = port;
            }
            ++i;
        }
        int n = 2;
        LogicalPortType newPort = null;
        while (portTypeNames.contains(name + n++)) {
        }
        newPort = new LogicalPortType();
        newPort.setName(name + (n - 1));
        newPort.setEndpoint(portToClone.getEndpoint());
        newPort.setBindingName(portToClone.getBindingName());
        newPort.setBindingUri(portToClone.getBindingUri());
        newPort.setBindingImplementation(portToClone.getBindingImplementation());
        newPort.setDefault(false);
        newPort.setInterfaceName(portToClone.getInterfaceName());
        newPort.setStubName(portToClone.getStubName());
        if (portToClone.hasGlobalFeatures()) {
            newPort.setGlobalFeatures(portToClone.getGlobalFeatures());
        }
        if (portToClone.hasLocalFeatures()) {
            newPort.setLocalFeatures(portToClone.getLocalFeatures());
        }
        newPortTypesVector.addElement(newPort);
        Object[] newPortTypes = new LogicalPortType[newPortTypesVector.size()];
        newPortTypesVector.copyInto(newPortTypes);
        ports.setLogicalPort((LogicalPortType[])newPortTypes);
        factory.saveLogicalPorts(ports, lportsXML);
        File oldLPFile = new File(lpFile);
        File newLPFile = null;
        n = 2;
        while ((f = new File(oldLPFile.getParent(), "lport" + id + "_" + n++ + ".lp")).exists()) {
        }
        newLPFile = f;
        InternalHelperFunctions.initLPFile(id, props.getProperty(LPORTS_NAME_PROP), props.getProperty(META_INF_SUB_DIR_PROP), newLPFile.getAbsolutePath(), newPort);
        String interfaceName = newPort.getInterfaceName();
        int index = interfaceName.lastIndexOf(".");
        String packageName = index != 1 ? interfaceName.substring(0, index) : "";
        String relativeDir = packageName.replace('.', File.separatorChar);
        return new LpDescriptor(relativeDir, newLPFile.getName(), newPort.getName());
    }

    public static File[] downloadWSDL(String wsdlURL, String srcDir, String srcDirName, String projectRootDir, String metaInfSubDir, String id, Properties mappings, StringBuffer mappingsFileName, Vector fdvector, String proxyHost, String proxyPort) throws Exception {
        File[] wsdlFiles;
        WSDLImportTool importTool = new WSDLImportTool();
        String subID = InternalHelperFunctions.getSubID(id, metaInfSubDir);
        importTool.setSufix("_" + id + "_" + subID + "_0");
        String sapWsdlURL = InternalHelperFunctions.getSapWsdlURL(wsdlURL);
        importTool.setHTTPProxyResolver((HTTPProxyResolver)new IDEProxyResolver());
        try {
            wsdlFiles = importTool.downloadWSDL(sapWsdlURL, new File(metaInfSubDir), (Hashtable)mappings);
        }
        catch (Exception e) {
            wsdlFiles = importTool.downloadWSDL(wsdlURL, new File(metaInfSubDir), (Hashtable)mappings);
        }
        ProxyGeneratorWrapper.addWSDLsToVector(projectRootDir, srcDirName, wsdlFiles, fdvector);
        String mappingsName = InternalHelperFunctions.getMappingsFileName(id, subID);
        if (mappingsFileName != null) {
            mappingsFileName.append(mappingsName);
        }
        File mappingsFileLocation = new File(metaInfSubDir, mappingsName);
        FileOutputStream out = new FileOutputStream(mappingsFileLocation);
        mappings.store(out, "Please, do not edit this file!");
        out.close();
        ProxyGeneratorWrapper.addMetaFileToVector(projectRootDir, srcDirName, mappingsFileLocation, fdvector);
        return wsdlFiles;
    }

    public static String getMappingsFileName(String id, String subID) {
        return "mappings_" + id + "_" + subID + ".properties";
    }

    public static String getNextID(String metaInfDir) {
        boolean found;
        File f = new File(metaInfDir);
        String[] files = f.list();
        int id = 1;
        do {
            found = false;
            int i = 0;
            while (i < files.length) {
                if (files[i].equals("wsdlroot_" + id + "_1_0.wsdl")) {
                    ++id;
                    found = true;
                }
                ++i;
            }
        } while (found);
        return "" + id;
    }

    public static String getSubID(String id, String metaInfDir) {
        boolean found;
        File f = new File(metaInfDir);
        String[] files = f.list();
        int wsdlID = 1;
        do {
            found = false;
            int i = 0;
            while (i < files.length) {
                if (files[i].equals("wsdlroot_" + id + "_" + wsdlID + "_0.wsdl")) {
                    ++wsdlID;
                    found = true;
                }
                ++i;
            }
        } while (found);
        return "" + wsdlID;
    }

    public static String getSapWsdlURL(String rootWsdl) {
        if (rootWsdl.startsWith("http://") || rootWsdl.startsWith("https://")) {
            int index = rootWsdl.indexOf("?");
            if (rootWsdl.indexOf("&mode=sap_wsdl") != -1 || rootWsdl.indexOf("?mode=sap_wsdl") != -1) {
                return rootWsdl;
            }
            if (index != -1) {
                return rootWsdl + "&mode=sap_wsdl";
            }
            return rootWsdl + "?mode=sap_wsdl";
        }
        return rootWsdl;
    }

    public static String generateInterfaces(String targetDirectory, String projectRootDir, String metaInfDir, String lportsFileName, String rootWsdl, Properties idMapping, String targetPackage, boolean rpcStyle, boolean rpcServiceInterfaces, Vector fdvector, boolean standalone, Properties uriMapping) throws Exception {
        ProxyGenerator pg = new ProxyGenerator();
        String sapWSDL = InternalHelperFunctions.getSapWsdlURL(rootWsdl);
        ProxyGeneratorConfig config = new ProxyGeneratorConfig(sapWSDL, targetDirectory, targetPackage);
        try {
            config.setLocationMap((Hashtable)idMapping);
            if (!standalone) {
                config.setLogicalPortPath(metaInfDir);
            }
            if (uriMapping != null) {
                config.setUriToPackageMapping(uriMapping);
            }
            config.setLogicalPortName(lportsFileName);
            config.setInterfacesOnly(!standalone);
            config.setAdditionalMethods(rpcStyle);
            config.setJaxRpcMethods(rpcServiceInterfaces);
            pg.generateProxy(config);
        }
        catch (Exception e) {
            ProxyGeneratorWrapper.log(e);
            config.setWsdlLocation(rootWsdl);
            pg.generateProxy(config);
        }
        ProxyGeneratorWrapper.addSEIsToVector(targetDirectory, config, fdvector);
        String serviceInterface = ProxyGeneratorWrapper.addSIsToVector(targetDirectory, config, fdvector);
        ProxyGeneratorWrapper.addHelperFilesToVector(targetDirectory, config, fdvector);
        return serviceInterface;
    }

    public static String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    public static File getMetaFile(String srcDir, String name) {
        File pathDir = new File(srcDir, ProxyGeneratorWrapper.META_INF_SUBDIR);
        return new File(pathDir, name);
    }

    private static FileDescriptor[] updateLPFiles(String srcDir, String rootProjectDir, String metaInfDir, String targetPackage, String lportsFileName, String id, boolean standalone) throws Exception {
        if (!srcDir.endsWith("/") && !srcDir.endsWith("\\")) {
            srcDir = srcDir + File.separator;
        }
        String relativeDir = targetPackage.replace('.', File.separatorChar);
        String fullDir = srcDir + relativeDir + File.separatorChar;
        String metaInfRelative = !standalone ? InternalHelperFunctions.getMetaInfDirRelativeFromLP(rootProjectDir, fullDir) : ".";
        LogicalPortFactory lpf = new LogicalPortFactory();
        File lportsXml = !standalone ? new File(metaInfDir, lportsFileName) : new File(fullDir, lportsFileName);
        if (!lportsXml.exists()) {
            return new LpDescriptor[0];
        }
        LogicalPorts lports = lpf.loadLogicalPorts(lportsXml);
        LogicalPortType[] lp = lports.getLogicalPort();
        if (standalone) {
            int i = 0;
            while (i < lp.length) {
                int hostEndInd;
                int hostStartInd;
                String host;
                HTTPProxy proxy;
                LogicalPortType lport = lp[i];
                String endpoint = lport.getEndpoint();
                if (endpoint != null && (endpoint.startsWith("http://") || endpoint.startsWith("https://")) && (proxy = new IDEProxyResolver().getHTTPProxyForHost(host = endpoint.substring(hostStartInd = endpoint.startsWith("http://") ? 7 : 8, hostEndInd = endpoint.indexOf("/", hostStartInd)))) != null) {
                    FeatureType proxyFeature;
                    GlobalFeatures features = lport.getGlobalFeatures();
                    if (features == null) {
                        features = new GlobalFeatures();
                        lport.setGlobalFeatures(features);
                    }
                    if ((proxyFeature = features.getFeature("http://www.sap.com/webas/630/soap/features/proxy")) == null) {
                        proxyFeature = new FeatureType();
                        proxyFeature.setName("http://www.sap.com/webas/630/soap/features/proxy");
                        features.addFeature(proxyFeature);
                    }
                    PropertyType[] properties = new PropertyType[]{InternalHelperFunctions.createProperty("proxyHost", proxy.getProxyHost()), InternalHelperFunctions.createProperty("proxyPort", "" + proxy.getProxyPort())};
                    proxyFeature.setProperty(properties);
                }
                ++i;
            }
            lpf.saveLogicalPorts(lports, lportsXml);
        }
        FileDescriptor[] lpfd = new LpDescriptor[lp.length];
        boolean foundDefault = false;
        int i = 0;
        while (i < lp.length) {
            if (lp[i].getDefault()) {
                foundDefault = true;
            }
            String name = "lport" + id + "_" + (i + 1) + ".lp";
            InternalHelperFunctions.initLPFile(id, lportsFileName, metaInfRelative, fullDir + name, lp[i]);
            lpfd[i] = new LpDescriptor(relativeDir, name, lp[i].getName());
            ++i;
        }
        if (!foundDefault && lp.length > 0) {
            ProxyHelperFunctions.makeDefault(new File(fullDir, "lport" + id + "_1.lp").getAbsolutePath());
        }
        return lpfd;
    }

    private static PropertyType createProperty(String name, String value) {
        PropertyType property = new PropertyType();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    private static String getMetaInfDirRelativeFromLP(String srcDir, String lpDir) throws ProxyGeneratorException {
        if (!(srcDir = srcDir.replace('\\', '/')).endsWith("/")) {
            srcDir = srcDir + "/";
        }
        lpDir = lpDir.replace('\\', '/');
        StringBuffer metaInfRelativePath = new StringBuffer();
        int separatorIndex = srcDir.length() - 1;
        while ((separatorIndex = lpDir.indexOf("/", separatorIndex + 1)) != -1) {
            metaInfRelativePath.append("../");
        }
        metaInfRelativePath.append(ProxyGeneratorWrapper.META_INF_SUBDIR);
        String metaInfRelative = metaInfRelativePath.toString().replace('/', File.separatorChar);
        return metaInfRelative;
    }

    private static void initLPFile(String id, String lportsFileName, String relativeMetaInf, String absolutePath, LogicalPortType lport) throws IOException {
        Properties props = new Properties();
        props.setProperty(NAME_PROP, lport.getName());
        props.setProperty(ID_PROP, id);
        props.setProperty(META_INF_SUB_DIR_PROP, relativeMetaInf);
        props.setProperty(LPORTS_NAME_PROP, lportsFileName);
        FileOutputStream out = new FileOutputStream(absolutePath);
        props.store(out, "Please do not edit or remove this file!");
        out.close();
    }

    public static void addLPorts(String srcDir, String rootProjectDir, String metaInfDir, String lportsFileName, String id, String targetPackage, Vector fdvect, boolean standalone) throws Exception {
        FileDescriptor[] ports = InternalHelperFunctions.updateLPFiles(srcDir, rootProjectDir, metaInfDir, targetPackage, lportsFileName, id, standalone);
        int i = 0;
        while (i < ports.length) {
            ProxyGeneratorWrapper.addDescriptor(fdvect, ports[i]);
            ++i;
        }
    }

    public static LogicalPortType getLogicalPortType(File lpFile) throws IOException, LogicalPortException {
        Properties props = InternalHelperFunctions.getLPProperties(lpFile.getAbsolutePath());
        String metaInfProp = props.getProperty(META_INF_SUB_DIR_PROP);
        String lportsProp = props.getProperty(LPORTS_NAME_PROP);
        String nameProp = props.getProperty(NAME_PROP);
        File metaInfDir = new File(lpFile.getParent(), metaInfProp);
        File lportsXML = new File(metaInfDir, lportsProp);
        LogicalPorts lports = new LogicalPortFactory().loadLogicalPorts(lportsXML);
        LogicalPortType[] lportTypes = lports.getLogicalPort();
        int i = 0;
        while (i < lportTypes.length) {
            LogicalPortType lp = lportTypes[i];
            if (nameProp.equals(lp.getName())) {
                return lp;
            }
            ++i;
        }
        return null;
    }

    public static boolean isSLDLogicalPort(LogicalPortType lport) {
        return lport.getSLDWS() != null && lport.getSLDWSPort() != null;
    }
}

