/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.startup;

import com.sap.ide.eclipse.startup.SwtClassLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected String rootLocation = null;
    protected static File workspaceMetadataFolder = null;
    protected String application;
    protected String feature;
    protected String configuration;
    protected URL pluginPathLocation;
    protected String location;
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private String showSplash = null;
    private String endSplash = null;
    private boolean cmdInitialize = false;
    private boolean cmdFirstUse = false;
    private Process showProcess = null;
    private boolean splashDown = false;
    private final Runnable endSplashHandler = new Runnable(){

        public void run() {
            Main.this.takeDownSplash();
        }
    };
    private Properties props = new Properties();
    private HashMap featureIndex = new HashMap();
    private static String baseLocation = null;
    private String CommandLine = null;
    private boolean isSapImage = false;
    private static final String APPLICATION = "-application";
    private static final String BOOT = "-boot";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String DATA = "-data";
    private static final String CONFIGURATION = "-configuration";
    private static final String FEATURE = "-feature";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String ENDSPLASH = "-endsplash";
    private static final String FIRST_USE = "-firstuse";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String PI_BOOT = "org.eclipse.core.boot";
    private static final String BOOTLOADER = "org.eclipse.core.boot.BootLoader";
    private static final String BOOTJAR = "boot.jar";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String CONFIG_FILE = "platform.cfg";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ARG_USER_DIR = "user.dir";
    private static final String CFG_CORE_BOOT = "bootstrap.org.eclipse.core.boot";
    private static final String CFG_FEATURE_ENTRY = "feature";
    private static final String CFG_FEATURE_ENTRY_DEFAULT = "feature.default.id";
    private static final String CFG_FEATURE_ENTRY_ID = "id";
    private static final String CFG_FEATURE_ENTRY_ROOT = "root";
    private static final String CFG_EOF = "eof";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.core.launcher";
    protected static File logFile = null;
    protected static BufferedWriter log = null;
    protected static String[] arguments;
    protected static boolean newSession;
    private static Main launcher;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$net$URLDecoder;

    public Main() {
        String allUserDir = System.getProperty("allUserDir");
        if (allUserDir.startsWith("'") || allUserDir.startsWith("\"")) {
            allUserDir = allUserDir.substring(1);
        }
        if (allUserDir.endsWith("'") || allUserDir.endsWith("\"")) {
            allUserDir = allUserDir.substring(0, allUserDir.length() - 1);
        }
        System.setProperty("allUserDir", allUserDir);
    }

    protected Object basicRun(String[] args) throws Exception {
        URL[] bootPath = this.getBootPath(this.bootLocation);
        this.handleSplash(bootPath);
        Class clazz = this.getBootLoader(bootPath);
        Method method = clazz.getDeclaredMethod("run", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String, class$java$net$URL == null ? (class$java$net$URL = Main.class$("java.net.URL")) : class$java$net$URL, class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Main.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Main.class$("java.lang.Runnable")) : class$java$lang$Runnable);
        try {
            return method.invoke((Object)clazz, this.application, this.pluginPathLocation, this.location, args, this.endSplashHandler);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
    }

    protected String decode(String urlString) {
        try {
            Object result;
            Class clazz = class$java$net$URLDecoder == null ? (class$java$net$URLDecoder = Main.class$("java.net.URLDecoder")) : class$java$net$URLDecoder;
            Method method = clazz.getDeclaredMethod("decode", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((this.hexToByte(enc1) << 4) + this.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    public Class getBootLoader(URL[] path) throws Exception {
        URLClassLoader loader = new URLClassLoader(path, null);
        return loader.loadClass(BOOTLOADER);
    }

    protected URL[] getDevPath(URL base) throws MalformedURLException {
        URL url2;
        String devBase = base.toExternalForm();
        if (!this.inDevelopmentMode) {
            URL url2 = new URL(devBase + BOOTJAR);
            return new URL[]{url2};
        }
        String[] locations = this.getArrayFromList(this.devClassPath);
        ArrayList<URL> result = new ArrayList<URL>(locations.length);
        int i = 0;
        while (i < locations.length) {
            String spec = devBase + locations[i];
            char lastChar = spec.charAt(spec.length() - 1);
            url2 = spec.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(spec) : new URL(spec + "/");
            if (new File(url2.getFile()).exists()) {
                result.add(url2);
            }
            ++i;
        }
        url2 = new URL(devBase + BOOTJAR);
        if (new File(url2.getFile()).exists()) {
            result.add(url2);
        }
        return result.toArray(new URL[result.size()]);
    }

    protected URL[] getBootPath(String base) throws MalformedURLException {
        URL url = null;
        if (base != null) {
            url = new URL(base);
            if (this.debug) {
                System.out.println("Boot URL: " + url.toExternalForm());
            }
            return new URL[]{url};
        }
        URL[] result = null;
        url = new URL(this.rootLocation);
        String path = url.getFile();
        path = this.searchForBoot(path);
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Boot URL:");
            int i = 0;
            while (i < result.length) {
                System.out.println("    " + result[i].toExternalForm());
                ++i;
            }
        }
        return result;
    }

    protected String searchForBoot(String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.isDirectory() && (candidate.getName().equals(Main.PI_BOOT) || candidate.getName().startsWith("org.eclipse.core.boot_"));
            }
        };
        File[] boots = new File(start, "plugins").listFiles(filter);
        if (boots == null) {
            throw new RuntimeException("Could not find bootstrap code. Check location of boot plug-in or specify -boot.");
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < boots.length) {
            String name = boots[i].getName();
            int index = name.indexOf(95);
            String version = index == -1 ? "" : name.substring(index + 1);
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = boots[i].getAbsolutePath();
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = boots[i].getAbsolutePath();
                maxVersion = currentVersion;
            }
            ++i;
        }
        if (result == null) {
            throw new RuntimeException("Could not find bootstrap code. Check location of boot plug-in or specify -boot.");
        }
        return result.replace(File.separatorChar, '/') + "/";
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    public static void main(String[] args) {
        Object result = null;
        arguments = args;
        if (!Main.isCompatible()) {
            System.exit(14);
        }
        launcher = new Main();
        if (Main.isAlreadyRunning()) {
            System.exit(15);
        }
        try {
            result = launcher.run(args);
        }
        catch (Throwable e) {
            launcher.takeDownSplash();
            Main.log("Exception launching the Eclipse Platform:");
            Main.log(e);
            System.exit(13);
        }
        int exitCode = result instanceof Integer ? (Integer)result : 0;
        System.exit(exitCode);
    }

    public static void main(String argString) throws Exception {
        Vector<String> list = new Vector<String>(5);
        StringTokenizer tokens = new StringTokenizer(argString, " ");
        while (tokens.hasMoreElements()) {
            list.addElement((String)tokens.nextElement());
        }
        Main.main(list.toArray(new String[list.size()]));
    }

    protected String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else if (args[i].equalsIgnoreCase(INITIALIZE)) {
                this.cmdInitialize = true;
            } else if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                this.inDevelopmentMode = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(BOOT)) {
                    this.bootLocation = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                    this.rootLocation = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    this.inDevelopmentMode = true;
                    this.devClassPath = arg;
                } else if (args[i - 1].equalsIgnoreCase(DATA)) {
                    baseLocation = arg;
                } else {
                    if (args[i - 1].equalsIgnoreCase(APPLICATION)) {
                        this.application = arg;
                        found = true;
                    }
                    if (args[i - 1].equalsIgnoreCase(FEATURE)) {
                        this.feature = arg;
                    } else {
                        if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                            this.configuration = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(SHOWSPLASH)) {
                            this.showSplash = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                            this.endSplash = arg;
                            found = true;
                        }
                        if (found) {
                            configArgs[configArgIndex++] = i - 1;
                            configArgs[configArgIndex++] = i;
                        }
                    }
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    public Object run(String[] args) throws Exception {
        File javaHome = new File(System.getProperties().getProperty("java.home"));
        File javaRoot = javaHome.getParentFile();
        System.setProperty("JDK1.3.1_HOME", javaRoot.getAbsolutePath());
        System.setProperty("JDK1.4_HOME", javaRoot.getAbsolutePath());
        System.setProperty("file.encoding", "UTF-8");
        String[] passThruArgs = this.processCommandLine(args);
        passThruArgs = this.processConfiguration(passThruArgs);
        return this.basicRun(passThruArgs);
    }

    private String[] processConfiguration(String[] passThruArgs) throws MalformedURLException {
        String urlString;
        if (this.rootLocation == null) {
            this.rootLocation = this.getRootURL().toExternalForm();
        }
        URL configURL = null;
        if (this.configuration != null && !this.configuration.trim().equals("")) {
            this.configuration = this.configuration.replace(File.separatorChar, '/');
            if (this.configuration.equalsIgnoreCase(ARG_USER_DIR)) {
                String tmp = System.getProperty(ARG_USER_DIR);
                if (!tmp.endsWith(File.separator)) {
                    tmp = tmp + File.separator;
                }
                configURL = new URL("file:" + tmp.replace(File.separatorChar, '/') + CONFIG_FILE);
            } else {
                configURL = this.configuration.endsWith("/") ? new URL(this.configuration + CONFIG_FILE) : new URL(this.configuration);
            }
        }
        this.loadConfiguration(configURL);
        if (this.bootLocation == null && (urlString = this.loadAttribute(this.props, CFG_CORE_BOOT, null)) != null) {
            try {
                urlString = this.resolve(urlString);
                URL bootDir = new URL(urlString);
                URL bootURL = new URL(bootDir, BOOTJAR);
                if (bootDir.getProtocol().equals("file")) {
                    File jar = new File(bootURL.getFile());
                    if (jar.exists()) {
                        this.bootLocation = bootURL.toExternalForm();
                    } else {
                        this.cmdFirstUse = true;
                    }
                } else {
                    this.bootLocation = bootURL.toExternalForm();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (configURL == null && this.rootLocation == null) {
            return passThruArgs;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(passThruArgs));
        if (configURL != null) {
            args.add(CONFIGURATION);
            args.add(this.decode(configURL.toExternalForm()));
        }
        if (this.cmdFirstUse) {
            args.add(FIRST_USE);
        }
        if (baseLocation != null) {
            args.add(DATA);
            args.add(baseLocation);
        }
        if (this.rootLocation != null) {
            args.add(INSTALL);
            args.add(this.rootLocation);
        }
        return args.toArray(new String[0]);
    }

    private URL getRootURL() throws MalformedURLException {
        if (this.rootLocation != null) {
            return new URL(this.rootLocation);
        }
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String path = this.decode(url.getFile());
        if ((path = new File(path).getAbsolutePath().replace(File.separatorChar, '/')).endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        this.rootLocation = url.toExternalForm();
        return url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConfiguration(URL url) {
        if (url == null) {
            String base = baseLocation;
            if (!base.endsWith(File.separator)) {
                base = base + File.separator;
            }
            File cfg = null;
            try {
                cfg = new File(base + ".metadata" + File.separator + ".config" + File.separator + CONFIG_FILE);
                url = new URL("file", null, 0, cfg.getAbsolutePath());
                this.props = this.loadProperties(url);
                if (!this.debug) return;
                System.out.println("Startup: using configuration " + url.toString());
                return;
            }
            catch (IOException e) {
                try {
                    String install = this.getRootURL().getFile().replace('/', File.separatorChar);
                    if (!install.endsWith(File.separator)) {
                        install = install + File.separator;
                    }
                    cfg = new File(install + ".config" + File.separator + CONFIG_FILE);
                    url = new URL("file", null, 0, cfg.getAbsolutePath());
                    this.props = this.loadProperties(url);
                    if (!this.debug) return;
                    System.out.println("Startup: using configuration " + url.toString());
                    return;
                }
                catch (IOException e2) {
                    if (!this.debug) return;
                    System.out.println("Startup: unable to load configuration\n" + e2);
                }
                return;
            }
        }
        try {
            this.props = this.loadProperties(url);
            if (!this.debug) return;
            System.out.println("Startup: using configuration " + url.toString());
            return;
        }
        catch (IOException e) {
            if (!this.debug) return;
            System.out.println("Startup: unable to load configuration\n" + e);
        }
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties props = null;
        IOException originalException = null;
        try {
            props = this.load(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                props = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException e2) {
                try {
                    props = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException e3) {
                    throw originalException;
                }
            }
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties load(URL url, String suffix) throws IOException {
        Properties props;
        block9: {
            if (suffix != null && !suffix.equals("")) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + suffix);
            }
            props = new Properties();
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
                if (!CFG_EOF.equals(props.getProperty(CFG_EOF))) {
                    throw new IOException();
                }
                Object var6_5 = null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            is.close();
        }
        if (props == null) return props;
        String id = props.getProperty("feature.0.id");
        int i = 1;
        while (id != null) {
            this.featureIndex.put(id, Integer.toString(i - 1));
            id = props.getProperty("feature." + i + "." + CFG_FEATURE_ENTRY_ID);
            ++i;
        }
        return props;
    }

    private String loadAttribute(Properties props, String name, String dflt) {
        if (props == null) {
            return dflt;
        }
        String prop = props.getProperty(name);
        if (prop == null) {
            return dflt;
        }
        return prop.trim();
    }

    private void handleSplash(URL[] bootPath) {
        if (this.cmdInitialize) {
            this.showSplash = null;
            this.endSplash = null;
            return;
        }
        if (this.endSplash != null) {
            this.showSplash = null;
            return;
        }
        if (this.showSplash == null) {
            return;
        }
        String path = this.getSplashPath(bootPath);
        if (this.debug && path != null) {
            System.out.println("Startup: splash path = " + path);
        }
        String[] cmd = new String[path != null ? (this.isSapImage ? 5 : 4) : 3];
        int sIndex = 0;
        int eIndex = this.showSplash.indexOf(" -show");
        if (eIndex == -1) {
            return;
        }
        cmd[0] = this.showSplash.substring(sIndex, eIndex);
        sIndex = eIndex + 1;
        if ((eIndex = this.showSplash.indexOf(" ", sIndex)) == -1) {
            return;
        }
        cmd[1] = this.showSplash.substring(sIndex, eIndex);
        cmd[2] = this.showSplash.substring(eIndex + 1);
        if (path != null) {
            cmd[3] = path;
        }
        if (this.isSapImage) {
            cmd[4] = "-isSapImage";
        }
        try {
            this.showProcess = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            Main.log("Exception showing splash screen.");
            Main.log(e);
        }
    }

    private void takeDownSplash() {
        if (this.splashDown) {
            return;
        }
        if (this.endSplash != null) {
            try {
                Runtime.getRuntime().exec(this.endSplash);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.showProcess != null) {
            this.showProcess.destroy();
            this.showProcess = null;
        }
        this.splashDown = true;
    }

    private String getSplashPath(URL[] bootPath) {
        int pix;
        String[] featurePath = this.getFeatureRoot();
        String path = this.lookupSplash(featurePath);
        if (path != null) {
            if (this.feature.equals("com.sap.java.ide")) {
                this.isSapImage = true;
            }
            return path;
        }
        String temp = bootPath[0].getFile();
        int ix = (temp = temp.replace('/', File.separatorChar)).lastIndexOf("plugins" + File.separator);
        if (ix != -1 && (pix = temp.indexOf(File.separator, ix + 8)) != -1) {
            temp = temp.substring(0, pix);
            path = this.lookupSplash(new String[]{temp});
            return path;
        }
        return null;
    }

    private String lookupSplash(String[] searchPath) {
        if (searchPath == null) {
            return null;
        }
        String localePath = Locale.getDefault().toString().replace('_', File.separatorChar);
        while (localePath != null) {
            int ix;
            String suffix = localePath.equals("") ? SPLASH_IMAGE : "nl" + File.separator + localePath + File.separator + SPLASH_IMAGE;
            int i = 0;
            while (i < searchPath.length) {
                File splash;
                String path = searchPath[i];
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if ((splash = new File(path = path + suffix)).exists()) {
                    return splash.getAbsolutePath();
                }
                ++i;
            }
            localePath = localePath.equals("") ? null : ((ix = localePath.lastIndexOf(File.separator)) == -1 ? "" : localePath.substring(0, ix));
        }
        return null;
    }

    private String getFeatureIdentifier() {
        if (this.feature != null) {
            return this.feature;
        }
        String dflt = this.props.getProperty(CFG_FEATURE_ENTRY_DEFAULT);
        if (dflt != null) {
            return dflt;
        }
        return null;
    }

    private String[] getFeatureRoot() {
        String ix = this.featureIndex(this.getFeatureIdentifier());
        String urlString = this.props.getProperty("feature." + ix + "." + CFG_FEATURE_ENTRY_ROOT + ".0");
        if (urlString == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        URL url = null;
        int i = 1;
        while (urlString != null) {
            block5: {
                try {
                    urlString = this.resolve(urlString);
                    url = new URL(urlString);
                    if (!url.getProtocol().equals("file")) break block5;
                    result.add(url.getFile().replace('/', File.separatorChar));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                urlString = this.props.getProperty("feature." + ix + "." + CFG_FEATURE_ENTRY_ROOT + "." + i);
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new String[0]);
        }
        return null;
    }

    private String resolve(String urlString) throws MalformedURLException {
        if (urlString.startsWith(PLATFORM_URL)) {
            String root = this.getRootURL().toExternalForm();
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            String path = urlString.substring(PLATFORM_URL.length());
            return root + path;
        }
        return urlString;
    }

    private String featureIndex(String id) {
        if (id == null) {
            return null;
        }
        return (String)this.featureIndex.get(id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void log(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            try {
                block14: {
                    block13: {
                        Main.openLogFile();
                        try {
                            if (newSession) {
                                log.write(SESSION);
                                log.write(32);
                                int i = SESSION.length();
                                while (true) {
                                    if (i >= 78) {
                                        log.newLine();
                                        newSession = false;
                                        break;
                                    }
                                    log.write(45);
                                    ++i;
                                }
                            }
                            Main.write(obj);
                            Object var3_3 = null;
                            if (logFile != null) break block13;
                            if (log == null) break block14;
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            if (logFile == null) {
                                if (log == null) throw throwable;
                                log.flush();
                                throw throwable;
                            }
                            Main.closeLogFile();
                            throw throwable;
                        }
                        log.flush();
                        break block14;
                    }
                    Main.closeLogFile();
                }
                Object var5_7 = null;
                log = null;
                return;
            }
            catch (Exception e) {
                System.err.println("An exception occurred while writing to the platform log:");
                e.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    log = Main.logForStream(System.err);
                    Main.write(obj);
                    log.flush();
                }
                catch (Exception e2) {
                    System.err.println("An exception occurred while logging to the console:");
                    e2.printStackTrace(System.err);
                }
                Object var5_8 = null;
                log = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            log = null;
            throw throwable;
        }
    }

    private static void write(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Throwable) {
            log.write(STACK);
            log.newLine();
            ((Throwable)obj).printStackTrace(new PrintWriter(log));
        } else {
            log.write(ENTRY);
            log.write(32);
            log.write(PLUGIN_ID);
            log.write(32);
            log.write(String.valueOf(4));
            log.write(32);
            log.write(String.valueOf(0));
            log.write(32);
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
                log.write(formatter.format(new Date()));
            }
            catch (Exception e) {
                log.write(Long.toString(System.currentTimeMillis()));
            }
            log.newLine();
            log.write(MESSAGE);
            log.write(32);
            log.write(String.valueOf(obj));
        }
        log.newLine();
    }

    private static void computeLogFileLocation() {
        if (logFile != null) {
            return;
        }
        File base = Main.computeMetadataLocation();
        logFile = new File(base, ".log");
        logFile.getParentFile().mkdirs();
    }

    private static File computeLockFileLocation() {
        File base = Main.computeMetadataLocation();
        File result = new File(base, ".lock");
        result.getParentFile().mkdirs();
        return result;
    }

    private static File computeMetadataLocation() {
        File result = null;
        int i = 0;
        while (arguments != null && result == null && i < arguments.length) {
            if (arguments[i].equalsIgnoreCase(DATA) && i + 1 < arguments.length) {
                result = new File(arguments[i + 1]);
            }
            ++i;
        }
        if (result == null) {
            result = Main.getUserDefaultWorkspace();
        }
        baseLocation = result.getAbsolutePath();
        if (result != null) {
            System.setProperty("user.workspace", result.getAbsolutePath());
        }
        return new File(result, ".metadata");
    }

    private int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private static void openLogFile() throws IOException {
        Main.computeLogFileLocation();
        try {
            log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException e) {
            logFile = null;
            throw e;
        }
    }

    private static BufferedWriter logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    private static void closeLogFile() throws IOException {
        try {
            if (log != null) {
                log.flush();
                log.close();
            }
            Object var1 = null;
            log = null;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            log = null;
            throw throwable;
        }
    }

    private static boolean isCompatible() {
        try {
            String vmVersionString = System.getProperty("java.version");
            Identifier minimum = new Identifier(1, 3, 0);
            Identifier version = new Identifier(vmVersionString);
            return version.isGreaterEqualTo(minimum);
        }
        catch (SecurityException e) {
            return true;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private static boolean isAlreadyRunning() {
        File lockFile = Main.computeLockFileLocation();
        if (lockFile.exists()) {
            lockFile.delete();
        }
        return lockFile.exists();
    }

    /*
     * Unable to fully structure code
     */
    private static File getUserDefaultWorkspace() {
        block12: {
            block13: {
                user = System.getProperty("user.name");
                userHomeDir = System.getProperty("user.home");
                allUserDir = System.getProperty("allUserDir");
                if (allUserDir == null || allUserDir.equals("")) {
                    parent = new File(userHomeDir).getParentFile();
                    allUserDir = new File(parent, "All Users").getAbsolutePath();
                }
                workspaceMetadataFolder = new File(allUserDir, "SAP");
                workspaceMetadataFile = new File(workspaceMetadataFolder, "workspace.properties");
                workspaceDir = null;
                result = null;
                if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    user = user.toLowerCase();
                }
                props = new Properties();
                try {
                    stream = new FileInputStream(workspaceMetadataFile);
                    props.load(stream);
                    stream.close();
                    workspaceDir = props.getProperty(user);
                    if (workspaceDir == null || workspaceDir.equals("")) {
                        throw new Exception();
                    }
                    result = new File(workspaceDir);
                    break block12;
                }
                catch (Exception e) {
                    defaultPath = new File(userHomeDir, "Documents/SAP/workspace");
                    delFolder = null;
                    if (defaultPath.exists()) break block13;
                    delFolder = defaultPath;
                    ** while (delFolder != null && !delFolder.exists())
                }
lbl-1000:
                // 1 sources

                {
                    delFolder = delFolder.getParentFile();
                    continue;
                }
            }
            defaultPath.mkdirs();
            selectedPath = Main.launcher.showWSCreateMessage(defaultPath.getAbsolutePath());
            if (!defaultPath.equals(selectedPath)) {
                while (delFolder != null && !defaultPath.equals(delFolder)) {
                    defaultPath.delete();
                    defaultPath = defaultPath.getParentFile();
                }
            }
            if (selectedPath == null) {
                System.exit(0);
            }
            props.setProperty(user, selectedPath.getAbsolutePath());
            workspaceMetadataFolder.mkdirs();
            try {
                stream = new FileOutputStream(workspaceMetadataFile);
                props.store(stream, "User Workspace definition");
                stream.close();
                if (selectedPath.list().length > 0) {
                    System.exit(23);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            result = selectedPath;
        }
        return result;
    }

    public File showWSCreateMessage(String workspaceDir) {
        String dirPath = null;
        URL[] swtURL = new URL[1];
        String ws = null;
        int i = 0;
        while (arguments != null && ws == null && i < arguments.length) {
            if (arguments[i].equalsIgnoreCase("-ws") && i + 1 < arguments.length) {
                ws = arguments[i + 1];
            }
            ++i;
        }
        try {
            String installDir = this.getRootURL().getFile();
            final String pluginSearch = "org.eclipse.swt." + ws;
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(pluginSearch);
                }
            };
            File[] list = new File(installDir, "plugins").listFiles(filter);
            File swtFile = null;
            if (list.length <= 0) {
                throw new Exception("Can't find SWT jar file");
            }
            swtFile = new File(list[0], "ws/" + ws + "/swt.jar");
            swtURL[0] = new URL("file", null, 0, swtFile.getAbsolutePath());
            SwtClassLoader loader = new SwtClassLoader(swtURL, null);
            Class<?> shellClass = loader.loadClass("org.eclipse.swt.widgets.Shell");
            Class<?> displayClass = loader.loadClass("org.eclipse.swt.widgets.Display");
            Class<?> directoryDialogClass = loader.loadClass("org.eclipse.swt.widgets.DirectoryDialog");
            Class<?> dialogClass = loader.loadClass("org.eclipse.swt.widgets.Dialog");
            Class<?> messageBoxClass = loader.loadClass("org.eclipse.swt.widgets.MessageBox");
            Class<?> swtClass = loader.loadClass("org.eclipse.swt.SWT");
            Method method = null;
            Constructor<?> constr = null;
            method = displayClass.getDeclaredMethod("getDefault", null);
            Object display = method.invoke(displayClass, null);
            constr = shellClass.getConstructor(displayClass);
            Object shell = constr.newInstance(display);
            constr = directoryDialogClass.getConstructor(shellClass);
            Object directoryDialog = constr.newInstance(shell);
            method = directoryDialogClass.getDeclaredMethod("setFilterPath", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(directoryDialog, workspaceDir);
            method = directoryDialogClass.getDeclaredMethod("setMessage", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(directoryDialog, "Please select your default workspace...");
            Field yes = swtClass.getDeclaredField("YES");
            int y = yes.getInt(null);
            Field no = swtClass.getDeclaredField("NO");
            int n = no.getInt(null);
            constr = messageBoxClass.getConstructor(shellClass, Integer.TYPE);
            Object messageBox = constr.newInstance(shell, new Integer(y | n));
            method = dialogClass.getDeclaredMethod("setText", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(messageBox, "Question");
            method = messageBoxClass.getDeclaredMethod("setMessage", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(messageBox, "Do you want use the folder \"" + workspaceDir + "\"\n as your default workspace?");
            method = directoryDialogClass.getDeclaredMethod("open", null);
            dirPath = (String)method.invoke(directoryDialog, null);
            if ((dirPath == null || dirPath.equals("")) && (Integer)(method = messageBoxClass.getDeclaredMethod("open", null)).invoke(messageBox, null) == y) {
                dirPath = workspaceDir;
            }
            method = shellClass.getDeclaredMethod("dispose", null);
            method.invoke(shell, null);
        }
        catch (Exception e) {
            dirPath = workspaceDir;
        }
        if (dirPath == null) {
            return null;
        }
        return new File(dirPath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        newSession = true;
    }

    static class Identifier {
        private static final String DELIM = ". ";
        private int major;
        private int minor;
        private int service;

        private Identifier(int major, int minor, int service) {
            this.major = major;
            this.minor = minor;
            this.service = service;
        }

        private Identifier(String versionString) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, DELIM);
            if (tokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.service = Integer.parseInt(tokenizer.nextToken());
            }
        }

        private boolean isGreaterEqualTo(Identifier minimum) {
            if (this.major < minimum.major) {
                return false;
            }
            if (this.major > minimum.major) {
                return true;
            }
            if (this.minor < minimum.minor) {
                return false;
            }
            if (this.minor > minimum.minor) {
                return true;
            }
            return this.service >= minimum.service;
        }
    }
}

