/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends Thread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;

    public GVTTreeBuilder(SVGDocument sVGDocument, BridgeContext bridgeContext) {
        this.svgDocument = sVGDocument;
        this.bridgeContext = bridgeContext;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            Object object = null;
            object = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
            GraphicsNode graphicsNode = object.build(this.bridgeContext, (Document)this.svgDocument);
            this.fireCompletedEvent(graphicsNode);
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            this.fireCancelledEvent();
        }
        catch (BridgeException bridgeException) {
            this.exception = bridgeException;
            this.fireFailedEvent(bridgeException.getGraphicsNode());
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireFailedEvent(null);
        }
        this.bridgeContext.getDocumentLoader().dispose();
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.remove(gVTTreeBuilderListener);
    }

    protected void fireStartedEvent() throws InterruptedException {
        block5: {
            final Object[] objectArray = this.listeners.toArray();
            if (objectArray.length <= 0) break block5;
            final GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                    gVTTreeBuilderListener.gvtBuildStarted(gVTTreeBuilderEvent);
                    ++n;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int n = 0;
                            while (n < objectArray.length) {
                                GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                                gVTTreeBuilderListener.gvtBuildStarted(gVTTreeBuilderEvent);
                                ++n;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCompletedEvent(GraphicsNode graphicsNode) {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, graphicsNode);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                    gVTTreeBuilderListener.gvtBuildCompleted(gVTTreeBuilderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                            gVTTreeBuilderListener.gvtBuildCompleted(gVTTreeBuilderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent(GraphicsNode graphicsNode) {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, graphicsNode);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                    gVTTreeBuilderListener.gvtBuildFailed(gVTTreeBuilderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                            gVTTreeBuilderListener.gvtBuildFailed(gVTTreeBuilderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                    gVTTreeBuilderListener.gvtBuildCancelled(gVTTreeBuilderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            GVTTreeBuilderListener gVTTreeBuilderListener = (GVTTreeBuilderListener)objectArray[n];
                            gVTTreeBuilderListener.gvtBuildCancelled(gVTTreeBuilderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }
}

