/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import iaik.security.jsse.net.IAIKSSLServerSocketWrapper;
import iaik.security.jsse.net.JSSEChainVerifier;
import iaik.security.jsse.net.JSSEServerContext;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.jsse.utils.Debug;
import iaik.security.jsse.utils.Util;
import iaik.security.ssl.CipherSuiteList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;

public class IAIKSSLServerSocketFactory
extends SSLServerSocketFactory {
    private X509TrustManager a = null;
    private SecureRandom b = null;
    private X509KeyManager c = null;
    private static Debug e = Debug.getInstance();
    private static JSSEServerContext d;

    public void setVersion(int n) {
        switch (n) {
            case 0: {
                d.setAllowedProtocolVersions(2, 769);
                break;
            }
            case 1: {
                d.setAllowedProtocolVersions(2, 2);
                break;
            }
            case 2: {
                d.setAllowedProtocolVersions(768, 768);
                break;
            }
            case 4: {
                d.setAllowedProtocolVersions(768, 769);
                break;
            }
            case 3: {
                d.setAllowedProtocolVersions(769, 769);
                break;
            }
        }
    }

    private void a(String string) {
        if (this.c == null) {
            return;
        }
        String[] stringArray = this.c.getServerAliases(string, null);
        int n = 0;
        while (n < stringArray.length) {
            X509Certificate[] x509CertificateArray = this.c.getCertificateChain(stringArray[n]);
            PrivateKey privateKey = this.c.getPrivateKey(stringArray[n]);
            d.addServerCredentials(x509CertificateArray, privateKey);
            ++n;
        }
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList cipherSuiteList = new CipherSuiteList(3);
        String[] stringArray = new String[cipherSuiteList.size()];
        int n = 0;
        while (n < cipherSuiteList.size()) {
            stringArray[n] = cipherSuiteList.elementAt(n).getName();
            ++n;
        }
        return stringArray;
    }

    public String[] getDefaultCipherSuites() {
        CipherSuiteList cipherSuiteList = d.getEnabledCipherSuiteList();
        String[] stringArray = new String[cipherSuiteList.size()];
        int n = 0;
        while (n < cipherSuiteList.size()) {
            stringArray[n] = cipherSuiteList.elementAt(n).getName();
            ++n;
        }
        return stringArray;
    }

    public static ServerSocketFactory getDefault() {
        return new IAIKSSLServerSocketFactory();
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new IAIKSSLServerSocketWrapper(n, n2, inetAddress, (JSSEServerContext)((Object)d.clone()));
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return new IAIKSSLServerSocketWrapper(n, n2, (JSSEServerContext)((Object)d.clone()));
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new IAIKSSLServerSocketWrapper(n, (JSSEServerContext)((Object)d.clone()));
    }

    public IAIKSSLServerSocketFactory(X509TrustManager x509TrustManager, X509KeyManager x509KeyManager, SecureRandom secureRandom) {
        this.a = x509TrustManager;
        this.c = x509KeyManager;
        this.b = secureRandom;
        d = this.b != null ? new JSSEServerContext(this.b) : new JSSEServerContext();
        d.setJSSEKeyManager(x509KeyManager);
        d.setEnabledCipherSuiteList(new CipherSuiteList(3));
        d.setSessionManager(new JSSESessionManager());
        d.setDebugStream(null);
        if (this.c != null) {
            this.a("RSA");
            this.a("DSA");
            this.a("DH");
        } else {
            e.println("No KeyManager present, no ServerCredentials added");
        }
        d.updateCipherSuites();
        if (this.a != null) {
            d.setChainVerifier(new JSSEChainVerifier(this.a));
        } else {
            d.setChainVerifier(null);
            e.println("No TrustManager present, ChainVerifier disabled, all Certificates will be accepted");
        }
    }

    public IAIKSSLServerSocketFactory() {
        this(Util.getDefaultTrustManager(), Util.getDefaultKeyManager(), null);
        e.println("Default Factory");
    }
}

