/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.viewdesigner.wizards;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Table;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TableColumn;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.viewdesigner.TextPool;
import com.sap.ide.webdynpro.viewdesigner.service.Service;
import com.sap.ide.webdynpro.viewdesigner.wizards.TableColumnsWizardPage;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class TableWizardData {
    private TableColumnsWizardPage mPage = null;
    private Table mTable = null;
    private ContextNode mContextNode = null;
    private ContextNode mOriginalContextNode = null;
    private ArrayList mRowElements = new ArrayList();
    private String[] mEditorTypes = null;
    private TableViewer mTableViewer = null;

    public TableWizardData(DevelopmentObject object, String[] editorTypes, TableColumnsWizardPage page, TableViewer tableViewer) {
        this.mEditorTypes = editorTypes;
        this.mPage = page;
        this.mTableViewer = tableViewer;
        if (object instanceof Table) {
            ContextElement element;
            this.mTable = (Table)object;
            UIElementContextBinding binding = this.mTable.getContextBinding("dataSource");
            if (binding != null && (element = binding.getBoundContextElement()) instanceof ContextNode) {
                this.mContextNode = (ContextNode)element;
                this.mOriginalContextNode = (ContextNode)element;
            }
        }
    }

    public Object[] getRowElements() {
        if (this.mRowElements.size() > 0) {
            return this.mRowElements.toArray();
        }
        this.mRowElements.clear();
        if (null != this.mContextNode) {
            this.updateExistingBinding();
        }
        return this.mRowElements.toArray();
    }

    private void updateExistingBinding() {
        String editor = "";
        String originalContextElemPath = ContextService.getAbsoluteContextElementPath((ContextElement)this.mOriginalContextNode);
        String currentContextElemPath = ContextService.getAbsoluteContextElementPath((ContextElement)this.mContextNode);
        ContextAttribute[] attributes = this.mContextNode.getAttributes();
        int colIndex = 0;
        while (colIndex < this.mTable.getColumnCount()) {
            TableColumn column = this.mTable.getColumn(colIndex);
            if (column.getTableCellEditor() != null) {
                UIElementContextBinding[] bindings = column.getTableCellEditor().getContextBindings();
                int bindIndex = 0;
                while (bindIndex < bindings.length) {
                    ContextElement element = bindings[bindIndex].getBoundContextElement();
                    if (null != element) {
                        boolean found = false;
                        int i = 0;
                        while (i < attributes.length) {
                            if (element.equals(attributes[i])) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (found) {
                            TableWizardRowItem rowItem = new TableWizardRowItem((ContextAttribute)element, this, this.mTable, column);
                            this.mRowElements.add(rowItem);
                        }
                    }
                    ++bindIndex;
                }
            }
            ++colIndex;
        }
        int i = 0;
        while (i < attributes.length) {
            ContextAttribute attribute = attributes[i];
            boolean found = false;
            int j = 0;
            while (j < this.mRowElements.size()) {
                TableWizardRowItem rowItem = (TableWizardRowItem)this.mRowElements.get(j);
                if (rowItem.getBoundElement().equals(attribute)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                TableWizardRowItem rowItem = new TableWizardRowItem(attribute, this, this.mTable, null);
                this.mRowElements.add(rowItem);
            }
            ++i;
        }
    }

    public void contextNodeChanged() {
        this.mContextNode = (ContextNode)this.mPage.getMElement();
        this.mRowElements.clear();
    }

    protected void moveColumnDown() {
        if (this.mTableViewer.getTable().getSelectionCount() > 0) {
            int selectionIndex = this.mTableViewer.getTable().getSelectionIndex();
            if (-1 == selectionIndex) {
                return;
            }
            TableItem[] items = this.mTableViewer.getTable().getItems();
            TableItem selectedItem = items[selectionIndex];
            Object data = selectedItem.getData();
            if (data instanceof TableWizardRowItem && this.mRowElements.contains(data)) {
                int index = this.mRowElements.indexOf(data);
                if (index >= this.mRowElements.size() - 1) {
                    return;
                }
                Object nextItem = this.mRowElements.get(index + 1);
                this.mRowElements.set(index + 1, data);
                this.mRowElements.set(index, nextItem);
                this.mTableViewer.refresh();
            }
        }
    }

    protected void moveColumnUp() {
        if (this.mTableViewer.getTable().getSelectionCount() > 0) {
            int selectionIndex = this.mTableViewer.getTable().getSelectionIndex();
            if (-1 == selectionIndex) {
                return;
            }
            TableItem[] items = this.mTableViewer.getTable().getItems();
            TableItem selectedItem = items[selectionIndex];
            Object data = selectedItem.getData();
            if (data instanceof TableWizardRowItem && this.mRowElements.contains(data)) {
                int index = this.mRowElements.indexOf(data);
                if (index <= 0 || this.mRowElements.size() <= 1) {
                    return;
                }
                Object prevItem = this.mRowElements.get(index - 1);
                this.mRowElements.set(index - 1, data);
                this.mRowElements.set(index, prevItem);
                this.mTableViewer.refresh();
            }
        }
    }

    public void bindAll() {
        if (this.mRowElements == null) {
            return;
        }
        int i = 0;
        while (i < this.mRowElements.size()) {
            TableWizardRowItem rowItem = (TableWizardRowItem)this.mRowElements.get(i);
            rowItem.setBind("true");
            ++i;
        }
        this.mTableViewer.refresh();
    }

    public void unBindAll() {
        if (this.mRowElements == null) {
            return;
        }
        int i = 0;
        while (i < this.mRowElements.size()) {
            TableWizardRowItem rowItem = (TableWizardRowItem)this.mRowElements.get(i);
            rowItem.setBind("false");
            ++i;
        }
        this.mTableViewer.refresh();
    }

    public static class DataTypeEnum {
        public static String STRING = "string";
        public static String BOOLEAN = "boolean";
        public static String BOOLEANOBJECT = "booleanObject";
        public static String BINARY = "binary";
    }

    public static class EditorTypeEnum {
        public static String INPUTFIELD = "InputField";
        public static String CHECKBOX = "CheckBox";
        public static String IMAGE = "Image";
        public static String BUTTON = "Button";
        public static String LINKTOACTION = "LinkToAction";
        public static String LINKTOURL = "LinkToURL";
        public static String TEXTVIEW = "TextView";
        public static String CAPTION = "Caption";
        public static String DROPDOWNBYINDEX = "DropDownByIndex";
        public static String DROPDOWNBYKEY = "DropDownByKey";
        public static String RADIOBUTTON = "RadioButton";
    }

    public class TableWizardRowItem {
        private ContextAttribute mContextAttribute = null;
        private TableWizardData mParent = null;
        private Table mTable = null;
        private String mBind = "false";
        private int mEditorIndex = 6;
        private int mPropertyIndex = 0;
        private Vector mProperties = new Vector();
        private String mDefaultProperty = "";
        private TableColumn mBoundColumn = null;
        static /* synthetic */ Class class$java$lang$Boolean;

        public TableWizardRowItem(ContextAttribute contextAttribute, TableWizardData parent, Table table, TableColumn boundColumn) {
            this.mContextAttribute = contextAttribute;
            this.mParent = parent;
            this.mTable = table;
            this.mBoundColumn = boundColumn;
            this.updateExistingBinding();
        }

        public ContextAttribute getBoundElement() {
            return this.mContextAttribute;
        }

        public void setData(String property, Object value) {
            if (property.equals(TextPool.getInstance().getText(1102))) {
                int bindIndex = (Integer)value;
                this.mBind = 0 == bindIndex ? "false" : "true";
            } else if (property.equals(TextPool.getInstance().getText(1103))) {
                this.mEditorIndex = (Integer)value;
                String activeEditor = this.getEditorTextFromIndex(this.mEditorIndex);
                this.mProperties.clear();
                this.setDefaultProperty();
            } else if (property.equals(TextPool.getInstance().getText(1106))) {
                this.mPropertyIndex = (Integer)value;
                this.mDefaultProperty = (String)this.mProperties.elementAt(this.mPropertyIndex);
                String activeEditor = this.getEditorTextFromIndex(this.mEditorIndex);
                String[] uiElements = this.getPropertiesForEditor(activeEditor);
                TableWizardData.this.mPage.updatePropertyCellEditor(uiElements);
            }
        }

        public Object getData(String property) {
            Object data = null;
            if (property.equals(TextPool.getInstance().getText(1102))) {
                data = this.mBind.equals("false") ? new Integer(0) : new Integer(1);
            } else if (property.equals(TextPool.getInstance().getText(1103))) {
                data = new Integer(this.mEditorIndex);
            } else if (property.equals(TextPool.getInstance().getText(1101))) {
                data = this.mContextAttribute.getName();
            } else if (property.equals(TextPool.getInstance().getText(1106))) {
                data = new Integer(this.mPropertyIndex);
            }
            return data;
        }

        public String getColumnText(int columnIndex) {
            String columnText = null;
            switch (columnIndex) {
                case 0: {
                    columnText = this.mContextAttribute.getName();
                    break;
                }
                case 1: {
                    columnText = this.mBind;
                    break;
                }
                case 2: {
                    columnText = this.getEditorTextFromIndex(this.mEditorIndex);
                    break;
                }
                case 3: {
                    columnText = this.getPropertyTextFromIndex(this.mPropertyIndex);
                }
            }
            return columnText;
        }

        public Image getImage(int columnIndex) {
            return null;
        }

        public boolean canModify(String property) {
            boolean modify = false;
            if (property.equals(TextPool.getInstance().getText(1102))) {
                modify = true;
            } else if (property.equals(TextPool.getInstance().getText(1103))) {
                modify = true;
            } else if (property.equals(TextPool.getInstance().getText(1101))) {
                modify = false;
            } else if (property.equals(TextPool.getInstance().getText(1106))) {
                String activeEditor = this.getEditorTextFromIndex(this.mEditorIndex);
                String[] uiElements = this.getPropertiesForEditor(activeEditor);
                this.setActiveProperty();
                TableWizardData.this.mPage.updatePropertyCellEditor(uiElements);
                modify = true;
            }
            return modify;
        }

        private void setActiveProperty() {
            this.mDefaultProperty = (String)this.mProperties.elementAt(this.mPropertyIndex);
        }

        private void setDefaultPropertyIndex() {
            int i = 0;
            while (i < this.mProperties.size()) {
                if (this.mProperties.elementAt(i).equals(this.mDefaultProperty)) {
                    this.mPropertyIndex = i;
                }
                ++i;
            }
        }

        private void updateExistingBinding() {
            TableColumn column = null;
            String editor = "";
            this.setDefaultEditor();
            this.setDefaultProperty();
            String originalContextElemPath = ContextService.getAbsoluteContextElementPath((ContextElement)TableWizardData.this.mOriginalContextNode);
            String currentContextElemPath = ContextService.getAbsoluteContextElementPath((ContextElement)TableWizardData.this.mContextNode);
            if (!originalContextElemPath.equals(currentContextElemPath)) {
                this.mBind = "true";
                return;
            }
            column = this.mBoundColumn;
            if (null == column) {
                return;
            }
            if (column.getTableCellEditor() != null) {
                UIElementContextBinding[] bindings = column.getTableCellEditor().getContextBindings();
                int bindIndex = 0;
                while (bindIndex < bindings.length) {
                    if (bindings[bindIndex].getBoundContextElement() == this.mContextAttribute) {
                        this.mBind = "true";
                        boolean set = false;
                        Object fallbackProperty = null;
                        UIElement element = column.getTableCellEditor();
                        String name = null;
                        name = null != element.getDefinition() ? element.getDefinition().getName() : element.getMetaClass().getName();
                        name = name.substring(name.lastIndexOf(".") + 1, name.length());
                        this.setEditorIndex(name);
                        int l = 0;
                        while (l < bindings.length) {
                            if (this.isPrimary(element, bindings[bindIndex].getName())) {
                                this.mDefaultProperty = bindings[bindIndex].getName();
                                set = true;
                                break;
                            }
                            ++l;
                        }
                        if (!set) {
                            String elementName = element.getMetaClass().getName();
                            elementName = elementName.substring(elementName.lastIndexOf(".") + 1);
                            ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)elementName);
                            Object lPrimary = null;
                            AbstractViewElementPropertyDef[] lProperties = null;
                            while (lDefinition != null && !set) {
                                lProperties = lDefinition.getProperties();
                                int m = 0;
                                while (m < lProperties.length) {
                                    if (lProperties[m].getPrimary()) {
                                        this.mDefaultProperty = lProperties[m].getName();
                                        set = true;
                                    }
                                    ++m;
                                }
                                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
                            }
                        }
                        if (!set && bindings.length > 0) {
                            this.mDefaultProperty = bindings[0].getName();
                            set = true;
                        }
                    }
                    ++bindIndex;
                }
            }
        }

        private void setEditorIndex(String name) {
            int index = 0;
            while (index < TableWizardData.this.mEditorTypes.length) {
                if (TableWizardData.this.mEditorTypes[index].equals(name)) {
                    this.mEditorIndex = index;
                    break;
                }
                ++index;
            }
        }

        private void setDefaultProperty() {
            String editorType = TableWizardData.this.mEditorTypes[this.mEditorIndex];
            this.mDefaultProperty = this.getDefaultPropertyForEditor(editorType);
        }

        private void setDefaultEditor() {
            try {
                DevelopmentObject elementType = CheckLayerHelper.getType((ContextAttribute)this.mContextAttribute);
                String defaultEditor = this.getDefaultEditorForElementType(elementType);
                this.setEditorIndex(defaultEditor);
            }
            catch (Exception ex) {
                System.out.println("Inside error");
            }
        }

        private String getDefaultEditorForElementType(DevelopmentObject elementType) {
            int enumCount;
            DtSimpleType simpleType;
            String defaultEditor = EditorTypeEnum.INPUTFIELD;
            String typeName = elementType.getName();
            if (null == typeName) {
                return defaultEditor;
            }
            if (this.mContextAttribute.getReadOnly()) {
                defaultEditor = EditorTypeEnum.TEXTVIEW;
            }
            if (elementType instanceof DtSimpleType && null != (simpleType = (DtSimpleType)elementType).getSchemaType() && (enumCount = simpleType.getSchemaType().getEnumerationValueCount()) > 0) {
                return EditorTypeEnum.DROPDOWNBYKEY;
            }
            if (typeName.equals(DataTypeEnum.BOOLEAN)) {
                defaultEditor = EditorTypeEnum.CHECKBOX;
            } else if (typeName.equals(DataTypeEnum.BINARY)) {
                defaultEditor = EditorTypeEnum.CHECKBOX;
            } else if (typeName.equals(DataTypeEnum.BOOLEANOBJECT)) {
                defaultEditor = EditorTypeEnum.CHECKBOX;
            } else if (typeName.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableWizardRowItem.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                defaultEditor = EditorTypeEnum.CHECKBOX;
            }
            return defaultEditor;
        }

        private String getDefaultPropertyForEditor(String editorType) {
            String defaultProperty = "";
            ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)editorType);
            AbstractViewElementPropertyDef[] lProperties = null;
            while (lDefinition != null) {
                lProperties = lDefinition.getProperties();
                int j = 0;
                while (j < lProperties.length) {
                    if (lProperties[j].getPrimary()) {
                        defaultProperty = lProperties[j].getName();
                    }
                    ++j;
                }
                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
            }
            return defaultProperty;
        }

        private String getEditorTextFromIndex(int index) {
            return TableWizardData.this.mEditorTypes[index];
        }

        private String getPropertyTextFromIndex(int index) {
            if (0 == this.mProperties.size()) {
                return this.mDefaultProperty;
            }
            return (String)this.mProperties.elementAt(index);
        }

        private String[] getPropertiesForEditor(String editorType) {
            ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)editorType);
            this.mProperties.clear();
            AbstractViewElementPropertyDef[] lProperties = null;
            while (lDefinition != null) {
                lProperties = lDefinition.getProperties();
                int j = 0;
                while (j < lProperties.length) {
                    this.mProperties.add(lProperties[j].getName());
                    ++j;
                }
                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
            }
            String[] objProperties = Service.sort(this.mProperties);
            String[] uiElementProperties = new String[objProperties.length];
            this.mProperties.clear();
            int i = 0;
            while (i < objProperties.length) {
                this.mProperties.add(objProperties[i]);
                uiElementProperties[i] = objProperties[i];
                if (objProperties[i].equals(this.mDefaultProperty)) {
                    this.mPropertyIndex = i;
                }
                ++i;
            }
            return uiElementProperties;
        }

        public String getEditorText() {
            return TableWizardData.this.mEditorTypes[this.mEditorIndex];
        }

        public String getPropertyText() {
            if (0 == this.mProperties.size()) {
                return this.mDefaultProperty;
            }
            return (String)this.mProperties.elementAt(this.mPropertyIndex);
        }

        public boolean getBind() {
            return this.mBind.equals("true");
        }

        public String getName() {
            return this.mContextAttribute.getName();
        }

        private boolean isPrimary(UIElement element, String property) {
            String elementName = element.getMetaClass().getName();
            elementName = elementName.substring(elementName.lastIndexOf(".") + 1);
            ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)elementName);
            Object lPrimary = null;
            AbstractViewElementPropertyDef[] lProperties = null;
            while (lDefinition != null) {
                lProperties = lDefinition.getProperties();
                int j = 0;
                while (j < lProperties.length) {
                    if (property.equals(lProperties[j].getName())) {
                        return true;
                    }
                    ++j;
                }
                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
            }
            return false;
        }

        public void setBind(String string) {
            this.mBind = string;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

