/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.viewdesigner.ur;

import com.sap.ide.metamodel.webdynpro.component.view.uielement.CSSSizeUnit;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Group;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.RasterData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.RasterLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TabStrip;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Table;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TableColumn;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ToolBar;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Tray;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.webdynpro.viewdesigner.metainfo.ContextDefinition;
import com.sap.ide.webdynpro.viewdesigner.metainfo.ContextDefinitionService;
import com.sap.ide.webdynpro.viewdesigner.reflection.ReflectionHelper;
import java.io.PrintWriter;

public class RendererJS {
    protected RendererJS() {
    }

    public static void render(UIElement element, PrintWriter writer) {
        writer.write("<script id=\"_vdscript\" language=\"JavaScript\">");
        writer.write("function wdp_construct() {");
        writer.write("_dropobjects = new Array();");
        writer.write("_objcount = 0;");
        writer.write("_dropcontainers = new Array();");
        writer.write("_containercount = 0;");
        writer.write("_levelobjects = new Array();");
        writer.write("_levelcount = 0;");
        writer.write("_menuobjects = new Array();");
        writer.write("_menucount = 0;");
        writer.write("_rastercontainers = new Array();");
        writer.write("_rastercont = 0;");
        writer.write("_rasterobjects = new Array();");
        writer.write("_rastercount = 0;");
        writer.write("document.getElementById(\"_vdresptargetdesignRootUIElementContainer\").className = \"vdbackground\";");
        RendererJS.renderRek(element, writer, 1);
        writer.write("}");
        writer.write("</script>");
    }

    public static void renderRek(UIElement element, PrintWriter writer, int level) {
        if (element instanceof UIElementContainer) {
            Tray tray;
            ViewElement[] items;
            Group group;
            UIElementContainer lContainer = (UIElementContainer)element;
            if (!(lContainer.getLayout() instanceof RasterLayout)) {
                int i = 1;
                while (i <= lContainer.getChildCount()) {
                    writer.write("_dropobjects[_objcount++] = \"_" + lContainer.getName() + "cont" + i + "\";");
                    writer.write("document.getElementById(\"_" + lContainer.getName() + "cont" + i + "div\").style.zIndex = " + level + ";");
                    RendererJS.renderRek(lContainer.getChild(i - 1), writer, level + 2);
                    ++i;
                }
                writer.write("_dropcontainers[_containercount++] = \"_" + lContainer.getName() + "cont\";");
                if (lContainer.getName().equals("RootUIElementContainer")) {
                    writer.write("document.getElementById(\"_" + lContainer.getName() + "contdiv\").style.zIndex = 1000;");
                } else {
                    writer.write("document.getElementById(\"_" + lContainer.getName() + "contdiv\").style.zIndex = " + level + ";");
                }
            } else {
                RasterLayout rasterLayout = (RasterLayout)lContainer.getLayout();
                double rasterHeight = rasterLayout.getRasterHeight();
                double rasterWidth = rasterLayout.getRasterWidth();
                CSSSizeUnit unitHeight = rasterLayout.getRasterHeightUnit();
                String unitHeightString = "";
                if (unitHeight == CSSSizeUnit.EM) {
                    unitHeightString = "em";
                } else if (unitHeight == CSSSizeUnit.EX) {
                    unitHeightString = "ex";
                } else if (unitHeight == CSSSizeUnit.PX) {
                    unitHeightString = "px";
                } else if (unitHeight == CSSSizeUnit.PERCENT) {
                    unitHeightString = "%";
                }
                CSSSizeUnit unitWidth = rasterLayout.getRasterWidthUnit();
                String unitWidthString = "";
                if (unitWidth == CSSSizeUnit.EM) {
                    unitWidthString = "em";
                } else if (unitWidth == CSSSizeUnit.EX) {
                    unitWidthString = "ex";
                } else if (unitWidth == CSSSizeUnit.PX) {
                    unitWidthString = "px";
                } else if (unitWidth == CSSSizeUnit.PERCENT) {
                    unitWidthString = "%";
                }
                writer.write("_rastercontainers[_rastercont++] = new RasterCont('" + lContainer.getName() + "','" + rasterHeight + "','" + rasterWidth + "','" + unitHeightString + "','" + unitWidthString + "');");
                int i = 1;
                while (i <= lContainer.getChildCount()) {
                    RasterData rasterData = (RasterData)lContainer.getChild(i - 1).getLayoutData();
                    int top = rasterData.getTop();
                    int left = rasterData.getLeft();
                    writer.write("_rasterobjects[_rastercount++] = new RasterItem('" + lContainer.getChild(i - 1).getName() + "','" + lContainer.getName() + "','" + top + "','" + left + "');");
                    ++i;
                }
            }
            if (element instanceof Group && (group = (Group)element).getToolBar() != null) {
                ToolBar toolbar = group.getToolBar();
                items = toolbar.getToolBarItems();
                int j = 0;
                while (j < items.length) {
                    writer.write("wdp_toolbar_drop('" + toolbar.getName() + "','" + j + "');");
                    ++j;
                }
            }
            if (element instanceof Tray && (tray = (Tray)element).getToolBar() != null) {
                ToolBar toolbar = tray.getToolBar();
                items = toolbar.getToolBarItems();
                int j = 0;
                while (j < items.length) {
                    writer.write("wdp_toolbar_drop('" + toolbar.getName() + "','" + j + "');");
                    ++j;
                }
            }
        } else if (element instanceof TabStrip) {
            TabStrip tabstrip = (TabStrip)element;
            int i = 1;
            while (i <= tabstrip.getTabCount()) {
                RendererJS.renderRek(tabstrip.getTab(i - 1).getContent(), writer, level + 1);
                ++i;
            }
        } else if (element instanceof Table) {
            Table table = (Table)element;
            if (table.getToolBar() != null) {
                ToolBar toolbar = table.getToolBar();
                ViewElement[] items = toolbar.getToolBarItems();
                int j = 0;
                while (j < items.length) {
                    writer.write("wdp_toolbar_drop('" + toolbar.getName() + "','" + j + "');");
                    ++j;
                }
            }
            TableColumn[] columns = table.getColumns();
            int j = 0;
            while (j < columns.length) {
                writer.write("wdp_table_drop('" + table.getName() + "','" + columns[j].getName() + "','" + j + "');");
                ++j;
            }
        }
        RendererJS.insertMenuItems(element, writer);
    }

    private static void insertMenuItems(UIElement element, PrintWriter writer) {
        ContextDefinition lDefinition = null;
        int i = 0;
        while (i < ContextDefinitionService.getDefinitionCount()) {
            lDefinition = ContextDefinitionService.getDefinition(i);
            if (ReflectionHelper.isInstanceOf(lDefinition.getTargetClass(), element)) {
                writer.write("_menuobjects[_menucount++] = new MenuItem('" + element.getName() + "','" + lDefinition.getText() + "','" + lDefinition.getAction() + "');");
            }
            ++i;
        }
    }
}

