/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.viewdesigner.leftbar;

import com.sap.ide.webdynpro.viewdesigner.leftbar.ITrayItemListener;
import com.sap.ide.webdynpro.viewdesigner.leftbar.SelectableTrayItem;
import com.sap.ide.webdynpro.viewdesigner.leftbar.TrayItem;
import com.sap.ide.webdynpro.viewdesigner.leftbar.TrayItemEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TrayViewer
implements ISelectionProvider {
    protected List mTrayItems;
    private TrayItem mActiveTray;
    private Composite mComposite;
    private ListenerList mTrayItemSelectionListeners = new ListenerList();
    private ListenerList mSelectionChangedListeners = new ListenerList();
    private ITrayItemListener mTrayItemListener = new ITrayItemListener(){

        public void expanded(TrayItemEvent e) {
            if (e.getSource() instanceof TrayItem && TrayViewer.this.mActiveTray != null && !TrayViewer.this.mActiveTray.equals(e.getSource())) {
                TrayViewer.this.aboutToExpand((TrayItem)e.getSource());
                TrayViewer.this.mActiveTray.isCollapsed(true);
                TrayViewer.this.mActiveTray = (TrayItem)e.getSource();
                TrayViewer.this.mActiveTray.isCollapsed(false);
                TrayViewer.this.mComposite.layout(true);
                TrayViewer.this.expanded((TrayItem)e.getSource());
            }
        }

        public void collapsed(TrayItemEvent e) {
        }
    };
    private ISelectionChangedListener mSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TrayViewer.this.fireSelectionChangedEvent(event);
        }
    };

    public TrayViewer(int hintTrayItemCount) {
        this.mTrayItems = new ArrayList(hintTrayItemCount);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        ISelectionProvider provider;
        TrayItem item = this.getActiveTrayItem();
        if (item != null && item instanceof SelectableTrayItem && (provider = ((SelectableTrayItem)item).getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return Selection.NOT_SELECTED;
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider provider;
        TrayItem item = this.getActiveTrayItem();
        if (item != null && item instanceof SelectableTrayItem && (provider = ((SelectableTrayItem)item).getSelectionProvider()) != null) {
            provider.setSelection(selection);
        }
    }

    public void init(Composite parent) {
        this.mComposite = new Composite(parent, 0);
        GridData lGridData = new GridData(1808);
        this.mComposite.setLayoutData((Object)lGridData);
        lGridData.widthHint = 100;
        this.mComposite.setLayout((Layout)new ExpandableLayout());
        this.initClientArea(this.mComposite);
    }

    public void dispose() {
        this.mComposite.dispose();
    }

    public void addTrayItem(TrayItem trayItem, boolean update) {
        if (trayItem != null) {
            ISelectionProvider provider;
            this.mTrayItems.add(trayItem);
            if (this.mActiveTray != null) {
                this.mActiveTray.isCollapsed(true);
            }
            trayItem.init(this.mComposite);
            this.mActiveTray = trayItem;
            trayItem.isCollapsed(false);
            trayItem.addTrayItemListener(this.mTrayItemListener);
            if (trayItem instanceof SelectableTrayItem && (provider = ((SelectableTrayItem)trayItem).getSelectionProvider()) != null) {
                provider.addSelectionChangedListener(this.mSelectionChangedListener);
            }
        }
        if (update) {
            this.mComposite.layout(true);
        }
    }

    public TrayItem removeTrayItem(int idx, boolean update) {
        TrayItem item = null;
        if (idx >= 0 && idx < this.mTrayItems.size()) {
            item = (TrayItem)this.mTrayItems.remove(idx);
            if (item != null) {
                ISelectionProvider provider;
                if (this.mActiveTray == item && this.mTrayItems.size() > 0) {
                    this.mActiveTray = (TrayItem)this.mTrayItems.get(0);
                    this.mActiveTray.isCollapsed(false);
                }
                if (item instanceof SelectableTrayItem && (provider = ((SelectableTrayItem)item).getSelectionProvider()) != null) {
                    provider.removeSelectionChangedListener(this.mSelectionChangedListener);
                }
            }
            if (update) {
                this.mComposite.layout(true);
            }
        }
        return item;
    }

    public TrayItem removeTrayItem(TrayItem item, boolean update) {
        return this.removeTrayItem(this.mTrayItems.indexOf(item), update);
    }

    public TrayItem getTray(int idx) {
        return (TrayItem)this.mTrayItems.get(idx);
    }

    public int indexOf(TrayItem tray) {
        return this.mTrayItems.indexOf(tray);
    }

    protected void initClientArea(Composite parent) {
    }

    protected void aboutToExpand(TrayItem trayItem) {
    }

    protected void expanded(TrayItem trayItem) {
    }

    protected TrayItem getActiveTrayItem() {
        return this.mActiveTray;
    }

    public void setActiveTrayItem(TrayItem item) {
        this.mActiveTray = item;
    }

    protected Composite getComposite() {
        return this.mComposite;
    }

    public void setVisible(boolean visible) {
        this.mComposite.setVisible(visible);
    }

    private void fireSelectionChangedEvent(SelectionChangedEvent event) {
        Object[] listeners = this.mSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    static class Selection
    implements ISelection {
        public static final Selection SELECTED = new Selection(true);
        public static final Selection NOT_SELECTED = new Selection(false);
        private boolean mIsEmpty;

        public Selection(boolean isEmpty) {
            this.mIsEmpty = isEmpty;
        }

        public boolean isEmpty() {
            return this.mIsEmpty;
        }
    }

    class ExpandableLayout
    extends Layout {
        static final int MIN_EXPANSION_HEIGHT = 100;

        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            if (TrayViewer.this.mTrayItems.size() > 0) {
                Rectangle rectParent = parent.getClientArea();
                Point buttonSize = ((TrayItem)TrayViewer.this.mTrayItems.get(0)).getButton().computeSize(rectParent.width, -1, changed);
                int y = 0;
                int i = 0;
                while (i < TrayViewer.this.mTrayItems.size()) {
                    TrayItem trayItem = (TrayItem)TrayViewer.this.mTrayItems.get(i);
                    trayItem.getButton().setBounds(0, y, buttonSize.x, buttonSize.y);
                    y += buttonSize.y;
                    if (trayItem.isCollapsed()) {
                        trayItem.getExpansion().setBounds(0, y, 0, 0);
                    } else {
                        int height = rectParent.height - TrayViewer.this.mTrayItems.size() * buttonSize.y;
                        height = Math.max(height, 100);
                        trayItem.getExpansion().setBounds(0, y, buttonSize.x, height);
                        y += height;
                    }
                    ++i;
                }
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Point size = null;
            if (TrayViewer.this.mTrayItems.size() > 0) {
                Point buttonSize = ((TrayItem)TrayViewer.this.mTrayItems.get(0)).getButton().computeSize(wHint, -1, changed);
                size = new Point(wHint, buttonSize.x * TrayViewer.this.mTrayItems.size() + 100);
            } else {
                size = new Point(wHint, hHint);
            }
            return size;
        }
    }
}

