/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.viewdesigner.leftbar;

import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.viewdesigner.ViewContentOutline;
import com.sap.ide.webdynpro.viewdesigner.ViewDesignerActions;
import com.sap.ide.webdynpro.viewdesigner.ViewPlugin;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolbarSelectionListener
implements Listener {
    private String mSelection = null;
    private ToolBar mToolbar = null;
    private String mProjectName = null;
    private ViewContentOutline mOutline = null;

    public ToolbarSelectionListener(ToolBar toolbar, String projectName) {
        this.mToolbar = toolbar;
        this.mProjectName = projectName;
    }

    public void handleEvent(Event e) {
        if (e.type == 3) {
            ToolItem item = this.findItem(e);
            if (item != null) {
                String text = item.getToolTipText();
                String library = text.substring(0, text.indexOf("~"));
                String element = text.substring(text.indexOf("~") + 1);
                ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mProjectName, (String)library, (String)element);
                if (e.button == 3) {
                    ViewDesignerActions.help(null, null, element, null);
                    return;
                }
                ViewPlugin.setControl(lDefinition);
            }
        } else if (e.type == 4) {
            ViewPlugin.setControl(null);
        }
    }

    private ToolItem findItem(Event e) {
        return this.mToolbar.getItem(new Point(e.x, e.y));
    }

    public String getSelection() {
        return this.mSelection;
    }

    public void setContent(ViewContentOutline content) {
        this.mOutline = content;
    }
}

