/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityConverter {
    private static VelocityEngine ve = null;

    public static void init(String templatesPath) throws CAFBaseException {
        try {
            Properties props = new Properties();
            props.setProperty("file.resource.loader.path", templatesPath);
            props.setProperty("velocimacro.permissions.allow.inline.local.scope", "true");
            ve = new VelocityEngine();
            ve.init(props);
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    public static synchronized void processTemplete(String outputFile, String templete, Map initContext, DTRContentHolder contentHolder, PrintWriter log) throws CAFBaseException {
        try {
            Template t = ve.getTemplate(templete);
            VelocityContext context = new VelocityContext();
            StringWriter contentWriter = new StringWriter();
            Iterator it = initContext.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = initContext.get(key);
                context.put(key, value);
            }
            t.merge((Context)context, (Writer)contentWriter);
            FileUtils.removePathFromMap(outputFile, contentHolder.getDeleteQueue(), contentHolder.getFileList());
            String newFileContent = contentWriter.toString();
            File f = new File(outputFile);
            if (f.exists()) {
                FileReader oldFileReader = new FileReader(f);
                String oldFileContent = "";
                int ch = -1;
                while ((ch = ((Reader)oldFileReader).read()) != -1) {
                    oldFileContent = oldFileContent + (char)ch;
                }
                if (!newFileContent.equals(oldFileContent)) {
                    log.println("      -> Content changed, marked for update");
                    contentHolder.getGeneratedContent().put(outputFile, newFileContent);
                    FileUtils.addPathToMap(outputFile, contentHolder.getUpdateQueue(), contentHolder.getFileList());
                } else {
                    log.println("      -> No changes");
                }
            } else {
                log.println("      -> NEW FILE");
                contentHolder.getGeneratedContent().put(outputFile, newFileContent);
                FileUtils.addPathToMap(outputFile, contentHolder.getCreateQueue(), contentHolder.getFileList());
            }
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }
}

