/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import java.io.File;

public class PackageGenerator {
    public static String getApplicationPackage(String appName, String providerName) throws CAFBaseException {
        if (appName == null || providerName == null) {
            throw new CAFBaseException("Application name or Provider name can not be null while generating ApplicationService package");
        }
        return PackageGenerator.revertDotString(providerName) + "." + appName.toLowerCase();
    }

    public static String getApplicationServicePackage(ApplicationInterface app) throws CAFBaseException {
        String appServiceName = app.getObjectName();
        String appName = app.getApplication().getObjectName();
        String providerName = app.getApplication().getProviderName();
        return PackageGenerator.getApplicationServicePackage(appServiceName, appName, providerName);
    }

    public static String getApplicationServicePackage(String appServiceName, String appName, String providerName) throws CAFBaseException {
        if (appServiceName == null || appName == null || providerName == null) {
            throw new CAFBaseException("Null attributes detected while generating ApplicationService package");
        }
        return PackageGenerator.revertDotString(providerName) + "." + appName.toLowerCase() + ".appsrv." + appServiceName.toLowerCase();
    }

    public static String getBeanAbsolutePath(BaseObject obj, ProjectLocations locations) throws CAFBaseException {
        if (obj instanceof ApplicationInterface) {
            return locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + PackageGenerator.getApplicationServicePackage((ApplicationInterface)obj);
        }
        if (obj instanceof BusinessEntityInterface) {
            return locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + PackageGenerator.getBusinessServicePackage((BusinessEntityInterface)obj, locations.getCoreName());
        }
        throw new CAFBaseException("Object type not supported: " + obj);
    }

    public static String getBusinessEntityPackage(String businessEntityName, String appName, String providerName, String coreName) throws CAFBaseException {
        if (businessEntityName == null || appName == null || providerName == null) {
            throw new CAFBaseException("Null attributes detected while generating DataObject package");
        }
        String temp = null;
        temp = providerName.equals(coreName) ? ".bos." : ".besrv.";
        return PackageGenerator.revertDotString(providerName) + "." + appName.toLowerCase() + temp + businessEntityName.toLowerCase();
    }

    public static String getBusinessServicePackage(BusinessEntityInterface bei, String coreName) throws CAFBaseException {
        String appName = bei.getApplication().getObjectName();
        String providerName = bei.getApplication().getProviderName();
        return PackageGenerator.getBusinessServicePackage(bei, appName, providerName, coreName);
    }

    public static String getBusinessServicePackage(BusinessEntityInterface bes, String appName, String providerName, String coreName) throws CAFBaseException {
        DataObject be = null;
        if (bes == null || appName == null || providerName == null || (be = bes.getBusinessEntity()) == null) {
            throw new CAFBaseException("Null attributes detected while generating BEService package");
        }
        return PackageGenerator.getBusinessEntityPackage(be.getObjectName(), appName, providerName, coreName);
    }

    public static String getDataStructurePackage(String appName, String providerName) throws CAFBaseException {
        if (appName == null || providerName == null) {
            throw new CAFBaseException("Null attributes detected while generating DataStructure package");
        }
        return PackageGenerator.revertDotString(providerName) + "." + appName.toLowerCase() + ".appsrv.datatypes";
    }

    public static String getExceptionName(FaultMessage fm) {
        String fmFullName = fm.getObjectName();
        return fmFullName.substring(fmFullName.lastIndexOf(47) + 1);
    }

    public static String getExceptionsPackage(FaultMessage fm, ProjectLocations locations) {
        String fmFullName = fm.getObjectName();
        int index1 = fmFullName.indexOf(47);
        int index2 = fmFullName.lastIndexOf(47);
        String providerName = fmFullName.substring(0, index1);
        String appName = fmFullName.substring(index1 + 1, index2).replace('/', '.');
        if (appName.equals(locations.getCoreName())) {
            appName = "caf.rt";
        }
        return PackageGenerator.getExceptionsPackage(appName, providerName);
    }

    public static String getExceptionsPackage(String appName, String providerName) {
        String retVal = PackageGenerator.revertDotString(providerName) + "." + appName;
        return retVal.toLowerCase() + ".exception";
    }

    public static String getExternalMessagesPackage(String className, ExternalInterface ei) throws CAFBaseException {
        if (ei == null) {
            throw new CAFBaseException("Null attributes detected while generating ExternalService package");
        }
        return PackageGenerator.getExternalServicePackage(ei.getName(), ei.getApplication().getObjectName(), ei.getApplication().getProviderName());
    }

    public static String getExternalMessagesPackage(String parameterClassName, String proxyClassName, String appName, String providerName, boolean input) throws CAFBaseException {
        if (proxyClassName == null) {
            throw new CAFBaseException("Null attributes detected while generating ExternalService package");
        }
        String result = PackageGenerator.getExternalServicePackage(proxyClassName, appName, providerName);
        result = input ? result + ".input" : result + ".output";
        if (parameterClassName != null) {
            return result + "." + NamingRestrictions.generateJavaClassName(parameterClassName);
        }
        return result;
    }

    public static String getExternalServicePackage(ExternalInterface ext) throws CAFBaseException {
        String proxyClassName = NamingRestrictions.constructJavaIdentifier(ext.getObjectName());
        String appName = ext.getApplication().getObjectName();
        String providerName = ext.getApplication().getProviderName();
        return PackageGenerator.getExternalServicePackage(proxyClassName, appName, providerName);
    }

    public static String getExternalServicePackage(String proxyClassName, String appName, String providerName) throws CAFBaseException {
        if (proxyClassName != null) {
            return PackageGenerator.getApplicationPackage(appName, providerName) + ".extsrv." + proxyClassName.toLowerCase();
        }
        return PackageGenerator.getApplicationPackage(appName, providerName) + ".extsrv";
    }

    public static String getFQExceptionName(FaultMessage fm, ProjectLocations locations) {
        String excPackage = PackageGenerator.getExceptionsPackage(fm, locations);
        String excName = PackageGenerator.getExceptionName(fm);
        return excPackage + "." + excName;
    }

    public static String getUtilsPackage(String appName, String providerName) throws CAFBaseException {
        if (appName == null || providerName == null) {
            throw new CAFBaseException("Null attributes detected while generating Utils package");
        }
        return PackageGenerator.revertDotString(providerName) + "." + appName.toLowerCase() + ".utils";
    }

    public static synchronized boolean existOutputFile(String generatorPath, String className, String extension, GenerationMonitor monitor) {
        boolean result = false;
        File packageDirs = new File(generatorPath);
        if (packageDirs.exists()) {
            File currentFile = new File(packageDirs.getPath() + "/" + className + "." + extension);
            result = currentFile.exists();
        }
        return result;
    }

    private static String revertDotString(String input) {
        String retVal = "";
        int pos1 = 0;
        int pos2 = -1;
        while ((pos2 = input.indexOf(46, pos1)) != -1) {
            retVal = input.substring(pos1, pos2) + retVal;
            pos1 = pos2 + 1;
        }
        retVal = input.substring(pos1) + "." + retVal;
        return retVal;
    }
}

