/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.tools.velocity.utils.StringUtils;

public class NamingRestrictions {
    private static final String[] methodNameRestrictions = new String[0];
    private static final String[] attributeNameRestrictions = new String[]{"key", "parentKey", "propList", "objectGuid", "notifEvent", "notifEnabled"};
    private static final String[] keywordRestrictions = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};

    public static boolean isValidAttributeName(String attributeName) {
        if (attributeName == null) {
            return false;
        }
        if (NamingRestrictions.isInsideTheArray(attributeName, attributeNameRestrictions)) {
            return false;
        }
        return !NamingRestrictions.isInsideTheArray(attributeName, keywordRestrictions);
    }

    public static boolean isValidMemberName(String memberName) {
        if (memberName == null) {
            return false;
        }
        return !NamingRestrictions.isInsideTheArray(memberName, keywordRestrictions);
    }

    private static String escapeJavaReservedWords(String param) {
        if (!NamingRestrictions.isValidMemberName(param)) {
            return "_" + param;
        }
        return param;
    }

    public static String constructJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (!Character.isJavaIdentifierStart(s.charAt(0)) || s.charAt(0) == '$' || s.charAt(0) == '_') {
            result.append(NamingRestrictions.escapeSequence(s.charAt(0)));
        } else {
            result.append(s.charAt(0));
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i)) || s.charAt(i) == '$' || s.charAt(i) == '_') {
                result.append(NamingRestrictions.escapeSequence(s.charAt(i)));
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return NamingRestrictions.escapeJavaReservedWords(result.toString());
    }

    public static String escapeSequence(char c) {
        switch (c) {
            case '_': {
                return "__";
            }
            case '$': {
                return "_dol_";
            }
            case '/': {
                return "_sh_";
            }
            case ':': {
                return "_";
            }
            case '.': {
                return "_dot_";
            }
            case '-': {
                return "_minus_";
            }
        }
        return "_" + String.valueOf((int)c) + "_";
    }

    private static boolean isInsideTheArray(String attribute, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(attribute)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String generateJavaClassName(String name) {
        return StringUtils.capitalize(NamingRestrictions.escapeJavaReservedWords(NamingRestrictions.constructJavaIdentifier(name)));
    }

    public static String generateJavaMemberName(String name) {
        return StringUtils.uncapitalize(NamingRestrictions.constructJavaIdentifier(name));
    }
}

