/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Property;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MMRReader {
    private static final String WORKSPACE_NAME = "Read";
    private IConnection connection = null;
    protected HashSet businessObjects = new HashSet();
    protected HashSet valueSets = new HashSet();
    protected PrintWriter log = null;

    public MMRReader(String pathName, PrintWriter log) throws CAFResourceException {
        this.log = log;
        this.init(pathName);
    }

    public int getBEBackendType(String beiID) {
        return 0;
    }

    public Collection queryObject(QueryFilters filters, String modelPackage, String objectType) throws CAFResourceException {
        try {
            Utilities utils = Utilities.getUtilities();
            List typeList = utils.decodeQualifiedName(modelPackage + "." + objectType);
            return this.connection.queryM1(typeList, filters, true);
        }
        catch (ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public Collection queryObject(String modelPackage, String objectType, String id) throws CAFResourceException {
        try {
            Utilities utils = Utilities.getUtilities();
            List typeList = utils.decodeQualifiedName(modelPackage + "." + objectType);
            QueryFilters filters = null;
            if (id != null) {
                filters = new QueryFilters();
                QueryFilter filter = new QueryFilter("objectID", 0, id);
                filters.add(filter);
            }
            return this.connection.queryM1(typeList, filters, true);
        }
        catch (ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public boolean readStructure(String modelPackage, String objectType, String id) {
        Collection c;
        if (this.connection == null) {
            return false;
        }
        try {
            c = this.queryObject(modelPackage, objectType, id);
            this.log.println("  MMRRead query executed.");
        }
        catch (CAFResourceException ex) {
            this.log.println("  MMRRead query failed:");
            ((Throwable)((Object)ex)).printStackTrace();
            c = null;
        }
        if (c == null) {
            this.log.println("  WARNING: Null connection detected!");
            return false;
        }
        if (c.size() == 0) {
            this.log.println("  WARNING: No Applications available!");
            return false;
        }
        Application application = null;
        Iterator appIt = c.iterator();
        while (appIt.hasNext()) {
            application = (Application)appIt.next();
            this.log.println("  Got application: ID: " + application.getObjectId() + ", MOF-id: " + application.refMofId());
            this.printApplicationDetails(application);
        }
        return true;
    }

    public Collection selectObject(String modelPackage, String objectType, String id) throws CAFResourceException {
        try {
            Utilities utils = Utilities.getUtilities();
            List typeList = utils.decodeQualifiedName(modelPackage + "." + objectType);
            QueryFilters filters = null;
            if (id != null) {
                ArrayList<String> col = new ArrayList<String>();
                col.add(id);
                return this.connection.selectM1(col, true);
            }
            return this.connection.queryM1(typeList, filters, true);
        }
        catch (ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    private void init(String pathName) throws CAFResourceException {
        try {
            this.log.println("  Init MMRReader start");
            ConnectionSpec connSpec = new ConnectionSpec();
            connSpec.setReadOnly(true);
            ConnectionFactory connFactory = new ConnectionFactory();
            this.connection = connFactory.getConnection((javax.resource.cci.ConnectionSpec)connSpec);
            Workspace ws = new Workspace(WORKSPACE_NAME);
            ws.setPath(pathName);
            ws.setReadOnly(true);
            connSpec.getWorkspacesM1().add(ws);
            RepositoryServer.getRepositoryServer().registerWorkspace(ws, 1);
            this.log.println("  Init MMRReader finished successful");
        }
        catch (ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    private void printApplicationDetails(Application application) {
        this.log.println("  Reading all objects from filesystem for application " + application.getObjectId() + ":");
        Iterator iter = application.getBaseObjects().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof DataObject) {
                DataObject dObj = (DataObject)obj;
                this.log.println("  " + dObj.getObjectId() + " is DataObject");
                this.businessObjects.add(dObj);
                continue;
            }
            if (obj instanceof Operation) {
                Operation operation = (Operation)obj;
                this.log.println("  " + operation.getObjectName() + " is Operation");
                continue;
            }
            if (obj instanceof Attribute) {
                Attribute attr = (Attribute)obj;
                if (obj instanceof Property) {
                    this.log.println("  " + attr.getObjectName() + " is Property");
                    continue;
                }
                this.log.println("  " + attr.getObjectName() + " is Atribute");
                continue;
            }
            if (!(obj instanceof MOFInterface)) continue;
            MOFInterface mofInt = (MOFInterface)obj;
            this.log.println("  " + mofInt.getObjectId() + " is MOFInterface");
        }
    }
}

