/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.utils.GeneratedFilesList;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileUtils {
    public static void addPathToMap(String[] dcPathAndType, Map map) {
        if (dcPathAndType != null && dcPathAndType.length == 2 && !"".equals(dcPathAndType[0]) && !"".equals(dcPathAndType[1])) {
            FileUtils.addSortedEntry(map, dcPathAndType[0], dcPathAndType[1]);
        }
    }

    public static void addPathToMap(String fullPath, Map map, GeneratedFilesList fileList) {
        String[] dcPathAndType = fileList.getDCPathAndType(fullPath);
        FileUtils.addPathToMap(dcPathAndType, map);
    }

    public static void addSortedEntry(Map storage, Object relativePath, Object projectID) {
        if (storage.containsKey(projectID)) {
            Set valuesCollection = (Set)storage.get(projectID);
            valuesCollection.add(relativePath);
        } else {
            HashSet<Object> valuesCollection = new HashSet<Object>();
            valuesCollection.add(relativePath);
            storage.put(projectID, valuesCollection);
        }
    }

    public static void cleanDir(String pathName, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        File file = new File(pathName);
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDir(files[i], log, map, generatedFilesList);
                } else {
                    String path = files[i].getAbsolutePath();
                    if (generatedFilesList != null && generatedFilesList.canDelete(path)) {
                        FileUtils.addPathToMap(generatedFilesList.getDCPathAndType(path), map);
                    }
                }
                ++i;
            }
        } else {
            log.println("      -> No content found, nothing was deleted");
        }
    }

    public static void cleanDirFromExt(String pathName, String ext, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        File file = new File(pathName);
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteFiles(files[i], ext, log, map, generatedFilesList);
                } else {
                    String path = files[i].getAbsolutePath();
                    if (generatedFilesList != null && generatedFilesList.canDelete(path) && files[i].getName().endsWith(ext)) {
                        FileUtils.addPathToMap(generatedFilesList.getDCPathAndType(path), map);
                    }
                }
                ++i;
            }
        } else {
            log.println("      -> No content found, nothing was deleted");
        }
    }

    public static void deleteDir(File dir, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        log.println("      -> Removing " + dir.getName());
        if (dir.isDirectory()) {
            String[] children2;
            String[] children = dir.list();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    FileUtils.deleteDir(new File(dir, children[i]), log, map, generatedFilesList);
                    ++i;
                }
            }
            if (((children2 = dir.list()) == null || children2.length == 0) && generatedFilesList != null && generatedFilesList.canDelete(dir.getAbsolutePath())) {
                FileUtils.addPathToMap(generatedFilesList.getDCPathAndType(dir.getAbsolutePath()), map);
            }
        }
        if (dir.isFile()) {
            String path = dir.getAbsolutePath();
            if (generatedFilesList != null && generatedFilesList.canDelete(path)) {
                FileUtils.addPathToMap(generatedFilesList.getDCPathAndType(path), map);
            }
        }
    }

    public static void deleteDir(String dirPath, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        File file = new File(dirPath);
        FileUtils.deleteDir(file, log, map, generatedFilesList);
    }

    public static void deleteFiles(File dir, String ext, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        boolean result = false;
        log.println("      -> Empty " + dir.getName());
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    FileUtils.deleteFiles(new File(dir, children[i]), ext, log, map, generatedFilesList);
                    ++i;
                }
            }
        } else {
            String path = dir.getAbsolutePath();
            if (generatedFilesList != null && generatedFilesList.canDelete(path) && dir.getName().endsWith(ext)) {
                FileUtils.addPathToMap(generatedFilesList.getDCPathAndType(path), map);
            }
        }
    }

    public static void deleteFiles(String dirPath, String ext, PrintWriter log, Map map, GeneratedFilesList generatedFilesList) {
        File file = new File(dirPath);
        FileUtils.deleteFiles(file, ext, log, map, generatedFilesList);
    }

    public static synchronized String generateOutputFileName(String packageName, String className) {
        return FileUtils.generateOutputFileName(packageName, className, "java");
    }

    public static synchronized String generateOutputFileName(String generatorPath, String className, String extension) {
        String result = generatorPath + "/" + className + "." + extension;
        return result;
    }

    public static synchronized void generatePackageStructure(String packageStructure) {
        File packageDirs = new File(packageStructure);
        packageDirs.mkdirs();
    }

    public static void removeFile(String fullPath, GenerationMonitor monitor, GeneratedFilesList fileList) {
        String[] dcPathAndType;
        if (fileList != null && (dcPathAndType = fileList.getDCPathAndType(fullPath)) != null && dcPathAndType.length == 2 && !"".equals(dcPathAndType[0]) && !"".equals(dcPathAndType[1])) {
            fileList.removeFilePath(dcPathAndType[0]);
        }
        File result = new File(fullPath);
        if (monitor != null) {
            monitor.registerGeneratedFile(result);
        }
        result.delete();
    }

    public static void removePathFromMap(String[] dcPathAndType, Map map) {
        if (dcPathAndType != null && dcPathAndType.length == 2 && !"".equals(dcPathAndType[0]) && !"".equals(dcPathAndType[1])) {
            FileUtils.removeSortedEntry(map, dcPathAndType[0], dcPathAndType[1]);
        }
    }

    public static void removePathFromMap(String fullPath, Map map, GeneratedFilesList fileList) {
        String[] dcPathAndType = fileList.getDCPathAndType(fullPath);
        FileUtils.removePathFromMap(dcPathAndType, map);
    }

    public static void removeSortedEntry(Map storage, Object relativePath, Object projectID) {
        if (storage.containsKey(projectID)) {
            Set valuesCollection = (Set)storage.get(projectID);
            valuesCollection.remove(relativePath);
            if (valuesCollection.size() == 0) {
                storage.remove(projectID);
            }
        }
    }

    public static synchronized void writeOutputFile(String path, String content, GenerationMonitor monitor, GeneratedFilesList fileList) throws CAFBaseException {
        try {
            int offset;
            if (fileList != null) {
                fileList.addFilePath(path);
            }
            if ((offset = path.lastIndexOf(47)) == -1) {
                throw new CAFBaseException("Invalid file path: " + path);
            }
            String dirsPath = path.substring(0, offset);
            File dirs = new File(dirsPath);
            dirs.mkdirs();
            File fileToCreate = new File(path);
            if (monitor != null) {
                monitor.registerGeneratedFile(fileToCreate);
            }
            if (!fileToCreate.canWrite()) {
                fileToCreate.delete();
                fileToCreate = new File(path);
            }
            FileWriter fw = new FileWriter(fileToCreate);
            fw.write(content);
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    private static String replacer(String str) {
        return str.replace('\\', '/');
    }
}

