/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity.utils;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.tc.logging.Location;

public class DDicConverter {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$tools$velocity$utils$DDicConverter == null ? (class$com$sap$caf$tools$velocity$utils$DDicConverter = DDicConverter.class$("com.sap.caf.tools.velocity.utils.DDicConverter")) : class$com$sap$caf$tools$velocity$utils$DDicConverter);
    static /* synthetic */ Class class$com$sap$caf$tools$velocity$utils$DDicConverter;

    public static String getAttributeJDBCType(Attribute currAttrib, ProjectLocations locations, String currPackageName) throws CAFBaseException {
        String result = null;
        String javaType = DDicConverter.getAttributeType(currAttrib, locations, currPackageName);
        result = javaType.equals("java.lang.String") ? "VARCHAR" : (javaType.equals("int") ? "INTEGER" : (javaType.equals("java.math.BigDecimal") ? "DECIMAL" : (javaType.equals("byte[]") ? "BLOB" : (javaType.equals("java.sql.Date") ? "TIMESTAMP" : (javaType.equals("java.sql.Time") ? "TIME" : (javaType.equals("java.util.Date") ? "TIMESTAMP" : (javaType.equals("short") ? "SMALLINT" : (javaType.equals("long") ? "BIGINT" : (javaType.equals("double") ? "DOUBLE" : (javaType.equals("float") ? "REAL" : (javaType.equals("java.util.ArrayList") || javaType.equals("java.util.HashSet") ? "Collection Type" : "Complex Type")))))))))));
        return result;
    }

    public static String getRemoteAttributeType(Attribute currAttrib, ProjectLocations locations, String currPackageName) throws CAFBaseException {
        String attribType = null;
        attribType = DDicConverter.getSingleAttributeType(currAttrib, locations, currPackageName);
        return attribType;
    }

    public static String getAttributeType(Attribute currAttrib, ProjectLocations locations, String currPackageName) throws CAFBaseException {
        String attribType = null;
        int maxOccurs = currAttrib.getMaxOccurs();
        if (maxOccurs == -1) {
            int listType = currAttrib.getListType();
            if (listType == 0) {
                attribType = "java.util.HashSet";
            } else if (listType == 1) {
                attribType = "java.util.ArrayList";
            }
        } else {
            attribType = DDicConverter.getSingleAttributeType(currAttrib, locations, currPackageName);
        }
        return attribType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSingleAttributeType(Attribute currAttrib, ProjectLocations locations, String currPackageName) throws CAFBaseException {
        String attribType = null;
        String ddicType = currAttrib.getTypeJavaDdic();
        if (ddicType == null) {
            DataStructure ref = currAttrib.getReferencedObject();
            Application appl = null;
            String providerName = null;
            String appName = null;
            if (ref instanceof DataObject) {
                DataObject dataO = (DataObject)ref;
                if (dataO.getBusinessEntityInterface() == null) {
                    return currPackageName + "." + dataO.getObjectName();
                }
                appl = dataO.getBusinessEntityInterface().getApplication();
                providerName = appl.getProviderName();
                appName = appl.getObjectName();
                return PackageGenerator.getBusinessEntityPackage(dataO.getObjectName(), appName, providerName, locations.getCoreName()) + "." + dataO.getObjectName();
            }
            if (!(ref instanceof DataStructure)) throw new CAFBaseException("Only DataStructure and DataObject are allowed as complex types. Type not supported: " + ref);
            appl = ref.getApplication();
            providerName = appl.getProviderName();
            appName = appl.getObjectName();
            return PackageGenerator.getDataStructurePackage(appName, providerName) + "." + ref.getObjectName();
        }
        String shortDDic = DDicConverter.getShortDDicType(ddicType, locations);
        return DDicConverter.getJavaType(shortDDic);
    }

    public static String getBuildInType(DtSimpleType baseTypeParent) throws CAFBaseException {
        String ret = baseTypeParent.getBuiltInType();
        DtSimpleType baseType = baseTypeParent.getBaseType();
        if (ret == null) {
            if (baseType != null) {
                ret = DDicConverter.getBuildInType(baseType);
            } else {
                throw new CAFBaseException("Cant' determinate build in type for type:" + baseTypeParent.getBaseTypeName());
            }
        }
        return ret;
    }

    public static String getJavaType(String ddicShortType) throws CAFBaseException {
        if (ddicShortType.equals("string")) {
            return "java.lang.String";
        }
        if (ddicShortType.equals("integer")) {
            return "int";
        }
        if (ddicShortType.equals("decimal")) {
            return "java.math.BigDecimal";
        }
        if (ddicShortType.equals("binary")) {
            return "byte[]";
        }
        if (ddicShortType.equals("date")) {
            return "java.sql.Date";
        }
        if (ddicShortType.equals("time")) {
            return "java.sql.Time";
        }
        if (ddicShortType.equals("timestamp")) {
            return "java.util.Date";
        }
        if (ddicShortType.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (ddicShortType.equals("short") || ddicShortType.equals("long") || ddicShortType.equals("float") || ddicShortType.equals("double") || ddicShortType.equals("boolean")) {
            return ddicShortType;
        }
        throw new CAFBaseException("Mapping for DDic type not found: " + ddicShortType);
    }

    public static String getJavaWrapper(String javaType) throws CAFBaseException {
        if (javaType.equals("java.lang.String")) {
            return null;
        }
        if (javaType.equals("byte[]")) {
            return null;
        }
        if (javaType.equals("int")) {
            return "java.lang.Integer";
        }
        if (javaType.equals("float")) {
            return "java.lang.Float";
        }
        if (javaType.equals("double")) {
            return "java.lang.Double";
        }
        if (javaType.equals("short")) {
            return "java.lang.Short";
        }
        if (javaType.equals("long")) {
            return "java.lang.Long";
        }
        if (javaType.equals("char")) {
            return "java.lang.Character";
        }
        if (javaType.equals("byte")) {
            return "java.lang.Byte";
        }
        if (javaType.equals("boolean")) {
            return "java.lang.Boolean";
        }
        throw new CAFBaseException("Wrapper for Java type not found: " + javaType);
    }

    public static String getShortDDicType(String fullQDDicType, ProjectLocations locations) throws CAFBaseException {
        DtDictionaryRoot dictRoot = locations.getDictionaryRoot();
        return DDicConverter.getShortDDicType(fullQDDicType, dictRoot);
    }

    public static String getShortDDicType(String fullQDDicType, DtDictionaryRoot dictRoot) throws CAFBaseException {
        if (dictRoot == null) {
            String name = fullQDDicType.substring(fullQDDicType.lastIndexOf(46) + 1);
            if (name.equals("int")) {
                return "integer";
            }
            return name;
        }
        int index = fullQDDicType.lastIndexOf(46);
        try {
            DtSimpleType dtst = dictRoot.getSimpleType(fullQDDicType.substring(0, index), fullQDDicType.substring(index + 1));
            return DDicConverter.getBuildInType(dtst);
        }
        catch (Exception e) {
            throw new CAFBaseException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSimpleAttributeType(Attribute currAttrib, ProjectLocations locations, String currProviderName, String currAppName) throws CAFBaseException {
        try {
            String attribType = null;
            String ddicType = currAttrib.getTypeJavaDdic();
            if (ddicType == null) {
                DataStructure ref = currAttrib.getReferencedObject();
                Application appl = null;
                String providerName = null;
                String appName = null;
                if (ref instanceof DataObject) {
                    DataObject dataO = (DataObject)ref;
                    if (dataO.getBusinessEntityInterface() == null) {
                        providerName = currProviderName;
                        appName = currAppName;
                        return PackageGenerator.getBusinessEntityPackage(dataO.getObjectName(), appName, providerName, locations.getCoreName()) + "." + dataO.getObjectName();
                    } else {
                        appl = dataO.getBusinessEntityInterface().getApplication();
                        providerName = appl.getProviderName();
                        appName = appl.getObjectName();
                    }
                    return PackageGenerator.getBusinessEntityPackage(dataO.getObjectName(), appName, providerName, locations.getCoreName()) + "." + dataO.getObjectName();
                }
                if (!(ref instanceof DataStructure)) throw new CAFBaseException("Only DataStructure and DataObject are allowed as complex types. Type not supported: " + ref);
                appl = ref.getApplication();
                providerName = appl.getProviderName();
                appName = appl.getObjectName();
                return PackageGenerator.getDataStructurePackage(appName, providerName) + "." + ref.getObjectName();
            }
            String shortDDic = DDicConverter.getShortDDicType(ddicType, locations);
            return DDicConverter.getJavaType(shortDDic);
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    public static String convertShortDDicType(String fullQDDicType, DtDictionaryRoot dictRoot) {
        try {
            return DDicConverter.getJavaType(DDicConverter.getShortDDicType(fullQDDicType, dictRoot));
        }
        catch (Exception e) {
            logger.errorT("Error occured while trying to convert from type " + fullQDDicType);
            return null;
        }
    }

    public static String replaceFirst(String replaceWhat, String replaceWith, String replaceInString) {
        if (replaceInString == null || replaceWhat == null || replaceWith == null) {
            return replaceInString;
        }
        if (replaceInString.length() < replaceWhat.length()) {
            return replaceInString;
        }
        if (replaceInString.startsWith(replaceWhat)) {
            return replaceWith + replaceInString.substring(replaceWhat.length());
        }
        return replaceInString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

