/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.webdynpro.MMRConverter;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class WDModelGenerator {
    private IProgressMonitor m_monitor;
    private IResourceChangeListener m_changeListener;
    private ProjectLocations m_locations = null;
    private static final Location logger = Logger.getLocation(class$com$sap$caf$tools$velocity$WDModelGenerator == null ? (class$com$sap$caf$tools$velocity$WDModelGenerator = WDModelGenerator.class$("com.sap.caf.tools.velocity.WDModelGenerator")) : class$com$sap$caf$tools$velocity$WDModelGenerator);
    static /* synthetic */ Class class$com$sap$caf$tools$velocity$WDModelGenerator;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;

    public WDModelGenerator(ProjectLocations locations, IProgressMonitor monitor, IResourceChangeListener changeListener) {
        this.m_locations = locations;
        this.m_monitor = monitor;
        this.m_changeListener = changeListener;
    }

    public ProjectLocations getProjectLocations() {
        return this.m_locations;
    }

    public void setProjectLocations(ProjectLocations locations) {
        this.m_locations = locations;
    }

    public IResourceChangeListener getChangeListener() {
        return this.m_changeListener;
    }

    public void setChangeListener(IResourceChangeListener changeListener) {
        this.m_changeListener = changeListener;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.m_monitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public synchronized void generateWDModel(String providerName, String appName) throws GeneratorException {
        try {
            boolean performChanges;
            boolean hasChanges;
            WebDynproRoot wdRoot;
            BOMSystem boms;
            String coreProjName;
            MMRConverter conv = new MMRConverter();
            String projName = BOMSystem.getProjectNameFromAppName(appName);
            conv.setProgressMonitor(this.m_monitor);
            conv.loadMetaData(BOMSystem.getBOMSystem(projName).getApplication());
            String coreAppName = this.m_locations.getCoreName();
            if (!conv.containsApplication(coreAppName) && (coreProjName = BOMSystem.getProjectNameFromAppName(coreAppName)) != null && (boms = BOMSystem.getBOMSystem(coreProjName)) != null) {
                conv.loadMetaData(boms.getApplication());
            }
            conv.setTemplatesPath(this.m_locations.getTemplatesPath());
            DtDictionaryRoot dictRoot = null;
            Metamodel mm = this.findProject(this.m_locations.getWdpProjectPath());
            if (mm != null) {
                dictRoot = (DtDictionaryRoot)mm.getRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = WDModelGenerator.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                if (dictRoot == null) {
                    dictRoot = (DtDictionaryRoot)mm.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = WDModelGenerator.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                }
            } else {
                dictRoot = this.m_locations.getDictionaryRoot();
                mm = dictRoot.getMetamodel();
            }
            if ((wdRoot = (WebDynproRoot)mm.getRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = WDModelGenerator.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot)) == null) {
                wdRoot = (WebDynproRoot)mm.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = WDModelGenerator.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            }
            HashMap<String, Model> mUsedModels = new HashMap<String, Model>();
            if (conv.containsApplication(coreAppName)) {
                mUsedModels.put(coreAppName, conv.doConvert(coreAppName, coreAppName.replace('.', '_'), wdRoot, dictRoot));
            }
            String modelName = appName.replace('.', '_');
            Model model = this.findModel(wdRoot, modelName);
            String outputPath = this.m_locations.getWdpProjectPath().replace('\\', '/');
            if (!outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            outputPath = outputPath + "src/packages/";
            HashMap emptyMap = new HashMap();
            model = conv.doConvert(appName, modelName, wdRoot, dictRoot, mUsedModels);
            if (model == null) {
                return;
            }
            MetamodelManager.saveAllMetaData((Metamodel)mm);
            Map changes = conv.generateJavaClasses(appName, modelName, outputPath, true);
            boolean bl = hasChanges = changes.size() > 0;
            if (this.m_changeListener != null && hasChanges && !(performChanges = this.m_changeListener.notifyResourceModifications(emptyMap, this.getChangesMap(changes), emptyMap))) {
                return;
            }
            Map newFiles = conv.generateJavaClasses(appName, modelName, outputPath, false);
            Iterator it = changes.keySet().iterator();
            while (it.hasNext()) {
                newFiles.remove(it.next());
            }
            if (this.m_changeListener != null) {
                boolean performChanges2;
                boolean hasNewFiles;
                boolean bl2 = hasNewFiles = newFiles.size() > 0;
                if (hasNewFiles && !(performChanges2 = this.m_changeListener.notifyResourceModifications(this.getChangesMap(newFiles), emptyMap, emptyMap))) {
                    return;
                }
                if (hasNewFiles || hasChanges) {
                    this.m_changeListener.finalizeModifications();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    private Map getChangesMap(Map javaClasses) {
        ArrayList<String> files = new ArrayList<String>();
        Iterator it = javaClasses.keySet().iterator();
        while (it.hasNext()) {
            String javaClass = (String)it.next();
            String fileName = "/src/packages/" + javaClass.replace('.', '/') + ".java";
            files.add(fileName);
        }
        HashMap<String, ArrayList<String>> retMap = new HashMap<String, ArrayList<String>>();
        retMap.put("WDP_PROJECT", files);
        return retMap;
    }

    private Metamodel findProject(String path) {
        IProject[] prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < prjs.length) {
            if (prjs[i].getLocation().toFile().equals(new File(path))) {
                return Metamodel.getInstance((String)prjs[i].getName());
            }
            ++i;
        }
        return null;
    }

    private Model findModel(WebDynproRoot wdRoot, String modelName) {
        try {
            Model[] models = wdRoot.getModels();
            int i = 0;
            while (i < models.length) {
                if (modelName.equals(models[i].getName())) {
                    return models[i];
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.errorT("Could not find a webdynpro model by name:" + modelName + ".The error is " + ex.getMessage());
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

