/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.ObjectRefactoredEvent;
import com.sap.ide.metamodel.general.event.PropertyChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectAddedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectMovedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRemovedEvent;
import com.sap.ide.metamodel.general.event.SubObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.SubObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.SubObjectMovedEvent;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class WDGeneratorObserver
implements DevelopmentObjectObserver {
    private Collection m_changedClasses = new ArrayList();
    private Collection m_deletedClasses = new ArrayList();
    private Collection m_addedClasses = new ArrayList();
    private Collection m_modelClasses = new ArrayList();

    public Collection getAddedClasses() {
        return this.m_addedClasses;
    }

    public Collection getChangedClasses() {
        return this.m_changedClasses;
    }

    public Collection getDeletedClasses() {
        return this.m_deletedClasses;
    }

    public Collection getOriginalClasses() {
        return this.m_modelClasses;
    }

    public void init(Model model) {
        this.m_modelClasses = Arrays.asList(model.getModelClasses());
    }

    public void update(MetamodelEvent event) {
        this.processEvent(event);
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.processEvent(events[i]);
            ++i;
        }
    }

    private String _getClassShortName(Object obj) {
        String className = obj.getClass().getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    private String _getDODesc(DevelopmentObject _do) {
        return _do.getMetaClass().getName() + "[" + this._getClassShortName(_do) + "] " + _do.getName();
    }

    private void addAddedClass(DevelopmentObject obj) {
        DevelopmentObject parent;
        if (!this.m_addedClasses.contains(obj)) {
            this.m_addedClasses.add(obj);
        }
        if ((parent = obj.getParent()) != null && parent instanceof Model) {
            this.addChangedClass(parent);
        }
    }

    private void addChangedClass(DevelopmentObject obj) {
        if (!(this.m_changedClasses.contains(obj) || this.m_addedClasses.contains(obj) || this.m_deletedClasses.contains(obj))) {
            this.m_changedClasses.add(obj);
        }
    }

    private void addDeletedClass(DevelopmentObject obj) {
        if (!this.m_deletedClasses.contains(obj)) {
            this.m_deletedClasses.add(obj);
        }
        this.m_changedClasses.remove(obj);
        this.m_addedClasses.remove(obj);
        DevelopmentObject parent = obj.getParent();
        if (parent != null && parent instanceof Model) {
            this.addChangedClass(parent);
        }
    }

    private void printEventInfo(MetamodelEvent event) {
        DevelopmentObject _do = event.getModifiedObject();
        if (event instanceof PropertyChangedEvent) {
            PropertyChangedEvent pce = (PropertyChangedEvent)event;
        } else if (event instanceof ObjectRefactoredEvent) {
            ObjectRefactoredEvent ore = (ObjectRefactoredEvent)event;
        } else if (event instanceof ReferencedObjectAddedEvent) {
            ReferencedObjectAddedEvent roae = (ReferencedObjectAddedEvent)event;
        } else if (event instanceof ReferencedObjectChangedEvent) {
            ReferencedObjectChangedEvent roce = (ReferencedObjectChangedEvent)event;
        } else if (event instanceof ReferencedObjectMovedEvent) {
            ReferencedObjectMovedEvent rome = (ReferencedObjectMovedEvent)event;
        } else if (event instanceof ReferencedObjectRemovedEvent) {
            ReferencedObjectRemovedEvent rore = (ReferencedObjectRemovedEvent)event;
        } else if (event instanceof SubObjectCreatedEvent) {
            SubObjectCreatedEvent soce = (SubObjectCreatedEvent)event;
        } else if (event instanceof SubObjectDeletedEvent) {
            SubObjectDeletedEvent sode = (SubObjectDeletedEvent)event;
        } else if (event instanceof SubObjectMovedEvent) {
            SubObjectMovedEvent subObjectMovedEvent = (SubObjectMovedEvent)event;
        }
    }

    private void processEvent(MetamodelEvent event) {
        DevelopmentObject obj = event.getModifiedObject();
        if (event instanceof ReferencedObjectChangedEvent) {
            ReferencedObjectChangedEvent roce = (ReferencedObjectChangedEvent)event;
            if ("Type".equals(roce.getRole())) {
                this.addChangedClass(obj.getParent());
            } else if ("ModelClass".equals(roce.getRole()) && obj instanceof ModelRelationRole) {
                this.addChangedClass(obj.getParent().getParent());
            }
        } else if (event instanceof ObjectCreatedEvent) {
            if (obj instanceof ModelClass) {
                this.addAddedClass(obj);
            } else if (obj instanceof ModelClassProperty || obj instanceof ModelRelation) {
                this.addChangedClass(obj.getParent());
            }
        } else if (event instanceof ObjectDeletedEvent) {
            if (obj instanceof ModelClass) {
                this.addDeletedClass(obj);
            } else if (obj instanceof ModelClassProperty || obj instanceof ModelRelation) {
                this.addChangedClass(obj.getParent());
            }
        } else if (event instanceof PropertyChangedEvent && obj instanceof ModelRelationRole) {
            this.addChangedClass(obj.getParent().getParent());
        }
    }
}

