/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;

public class UtilsGenerator {
    public static void generateUtils(String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        log.println("    Starting Utils generation");
        try {
            String packageName = PackageGenerator.getUtilsPackage(appName, providerName);
            HashMap initContext = UtilsGenerator.generateInitContext(packageName);
            String generatorPath = locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + packageName.replace('.', '/');
            log.println("      Generating HomeFactory");
            String hfFile = FileUtils.generateOutputFileName(generatorPath, "HomeFactory");
            String hfTemplateName = "Utils_HomeFactory_Template.vm";
            VelocityConverter.processTemplete(hfFile, hfTemplateName, initContext, contentHolder, log);
            log.println("      HomeFactory generated successful");
            log.println("      Generating ArraysUtils");
            String auFile = FileUtils.generateOutputFileName(generatorPath, "ArraysUtils");
            String auTemplateName = "Utils_ArraysUtils_Template.vm";
            VelocityConverter.processTemplete(auFile, auTemplateName, initContext, contentHolder, log);
            log.println("      ArraysUtils generated successful");
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        log.println("    Utils generated successful");
    }

    private static HashMap generateInitContext(String packageName) throws CAFBaseException {
        HashMap<String, String> initContext = new HashMap<String, String>();
        initContext.put("package", packageName);
        return initContext;
    }
}

