/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.utils.CustomCodeSnippet;
import com.sap.caf.designer.utils.CustomCodeTokenizer;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class UMEPermissionsGenerator {
    private static final String SNIPPET_START_MARK = "<!-- //@@custom code start -->";
    private static final String SNIPPET_END_MARK = "<!-- //@@custom code end -->";
    public static HashMap initContext = null;

    public static void clear(Application app, ProjectLocations locations, PrintWriter log) throws GeneratorException {
    }

    public static synchronized void generatePermissions(Application app, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        String appServName = null;
        if (app == null || appName == null) {
            throw new GeneratorException("Invalid Application object found: " + appServName + ". Aborting generation.");
        }
        log.println("    Starting UME Permissions generation for application: " + appName);
        try {
            String generatorPath = locations.getUMEPermissionsProjectPath() + "/src";
            String umeFile = FileUtils.generateOutputFileName(generatorPath, "actions", "xml");
            initContext = UMEPermissionsGenerator.generateInitContext(app, appName, providerName, umeFile, locations, log);
            String umeTemplateName = "UMEPermissions_Template.vm";
            VelocityConverter.processTemplete(umeFile, umeTemplateName, initContext, contentHolder, log);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        log.println("    UME Permissions generated successful");
    }

    private static HashMap generateInitContext(Application app, String appName, String providerName, String umeFileName, ProjectLocations locations, PrintWriter log) throws CAFBaseException {
        try {
            HashMap<String, Object> initContext = new HashMap<String, Object>();
            Vector<String> operations = new Vector<String>();
            String customCode = null;
            String descriptionValue = providerName + "/" + appName;
            File umeFile = new File(umeFileName);
            if (umeFile.exists()) {
                int bufferSize = (int)umeFile.length();
                char[] buffer = new char[bufferSize];
                FileReader reader = new FileReader(umeFile);
                reader.read(buffer, 0, bufferSize);
                String oldContent = new String(buffer);
                CustomCodeTokenizer customCodeTokenizer = new CustomCodeTokenizer(oldContent, SNIPPET_START_MARK, SNIPPET_END_MARK);
                int snippletsCount = customCodeTokenizer.getSnippetCount();
                if (snippletsCount == 0 || snippletsCount > 1) {
                    throw new CAFBaseException("        Invalid custom code section count: " + snippletsCount);
                }
                CustomCodeSnippet codeSnipplet = customCodeTokenizer.getSnippet(0);
                customCode = codeSnipplet.getBody();
            } else {
                log.println("        File actions.xml not found, no custom code will be extracted");
                customCode = "";
            }
            Iterator it = app.getBaseObjects().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof ApplicationInterface)) continue;
                ApplicationInterface appServ = (ApplicationInterface)o;
                String appServName = appServ.getObjectName();
                if (appServName == null) {
                    throw new CAFBaseException("        Invalid application service name: null");
                }
                List methods = appServ.getOperations();
                int i = 0;
                while (i < methods.size()) {
                    Operation op = (Operation)methods.get(i);
                    String opName = op.getObjectName();
                    if (opName == null) {
                        throw new CAFBaseException("        Invalid operation name: null");
                    }
                    String opID = providerName + "/" + appName + "/" + appServName + "/" + opName;
                    operations.addElement(opID);
                    ++i;
                }
            }
            initContext.put("customCode", customCode);
            initContext.put("operations", operations);
            initContext.put("descriptionValue", descriptionValue);
            return initContext;
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }
}

