/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class MetaInfGenerator {
    public static void generateServiceDescriptors(Vector services, String appName, String providerName, ProjectLocations locations, PrintWriter log, GenerationMonitor monitor, DTRContentHolder contentHolder) throws GeneratorException {
        try {
            if (services == null || services.size() == 0) {
                log.println("    Invalid META-INF collection found. Aborting generation.");
                return;
            }
            log.println("    Starting META-INF generation");
            HashMap initContext = MetaInfGenerator.generateInitContext(services, appName, providerName, locations);
            String generatorPath = locations.getApplicationServicesPath() + "/META-INF";
            log.println("      Generating ejb-jar.xml");
            String metaEJBJARFile = FileUtils.generateOutputFileName(generatorPath, "ejb-jar", "xml");
            String metaEJBJARTemplateName = "EJB_JAR.vm";
            VelocityConverter.processTemplete(metaEJBJARFile, metaEJBJARTemplateName, initContext, contentHolder, log);
            log.println("      ejb-jar.xml generated successful");
            log.println("      Generating ejb-j2ee-engine.xml");
            String metaEJBJ2EEFile = FileUtils.generateOutputFileName(generatorPath, "ejb-j2ee-engine", "xml");
            String metaEJBJ2EETemplateName = "EJB_J2EE.vm";
            VelocityConverter.processTemplete(metaEJBJ2EEFile, metaEJBJ2EETemplateName, initContext, contentHolder, log);
            log.println("      ejb-j2ee-engine.xml generated successful");
            log.println("    META-INF generated successful");
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    private static HashMap generateInitContext(Vector services, String appName, String providerName, ProjectLocations locations) throws CAFBaseException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Vector beans = new Vector();
        int i = 0;
        while (i < services.size()) {
            HashMap<String, Object> currBean = new HashMap<String, Object>();
            Vector methods = new Vector();
            MOFInterface serv = (MOFInterface)services.elementAt(i);
            String beanName = serv.getObjectName();
            String pck = null;
            if (serv instanceof BusinessEntityInterface) {
                BusinessEntityInterface bei = (BusinessEntityInterface)serv;
                pck = PackageGenerator.getBusinessServicePackage(bei, locations.getCoreName());
                currBean.put("INSTANCE_CHECKED", bei.getInstancePermission());
                currBean.put("entityService", "true");
            } else if (serv instanceof ApplicationInterface) {
                pck = PackageGenerator.getApplicationServicePackage((ApplicationInterface)serv);
                if (((ApplicationInterface)serv).isRemoteEnabled().booleanValue()) {
                    currBean.put("remoteEnabled", "true");
                }
            } else if (serv instanceof ExternalInterface) {
                pck = PackageGenerator.getExternalServicePackage((ExternalInterface)serv);
                beanName = NamingRestrictions.constructJavaIdentifier(serv.getObjectName());
            } else {
                throw new CAFBaseException("Invalid servie type: " + serv);
            }
            List operations = serv.getOperations();
            int opCount = 0;
            while (opCount < operations.size()) {
                Operation currOp = (Operation)operations.get(opCount);
                HashMap<String, String> method = new HashMap<String, String>();
                String transactionType = Constants.transactionTypes[currOp.getTransactionType()];
                if (serv instanceof ExternalInterface) {
                    method.put("META_INF_METHOD_NAME", NamingRestrictions.constructJavaIdentifier(currOp.getObjectName()));
                } else {
                    method.put("META_INF_METHOD_NAME", currOp.getObjectName());
                }
                method.put("META_INF_METHOD_TRANSACTION", transactionType);
                methods.addElement(method);
                ++opCount;
            }
            currBean.put("META_INF_BEAN_NAME", beanName);
            currBean.put("META_INF_BEAN_PACKAGE", pck);
            currBean.put("META_INF_APPLICATION_NAME", appName);
            currBean.put("META_INF_PROVIDER_NAME", providerName);
            currBean.put("META_INF_METHODS", methods);
            beans.addElement(currBean);
            ++i;
        }
        context.put("beans", beans);
        context.put("NAME", "META_INF_BEAN_NAME");
        context.put("PACKAGE", "META_INF_BEAN_PACKAGE");
        context.put("INSTANCE_CHECKED", "INSTANCE_CHECKED");
        context.put("APP_NAME", "META_INF_APPLICATION_NAME");
        context.put("PROVIDER", "META_INF_PROVIDER_NAME");
        context.put("METHODS", "META_INF_METHODS");
        context.put("METHOD_NAME", "META_INF_METHOD_NAME");
        context.put("METHOD_TRANSACTION", "META_INF_METHOD_TRANSACTION");
        return context;
    }
}

