/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.tools.velocity;

import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.designer.utils.ModifiedServicesList;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.ApplicationServiceGenerator;
import com.sap.caf.tools.velocity.BEIGenerator;
import com.sap.caf.tools.velocity.DTRContentHolder;
import com.sap.caf.tools.velocity.DataStructureGenerator;
import com.sap.caf.tools.velocity.EARMetadataGenerator;
import com.sap.caf.tools.velocity.ExceptionGenerator;
import com.sap.caf.tools.velocity.ExternalServiceGenerator;
import com.sap.caf.tools.velocity.MPConnectorGenerator;
import com.sap.caf.tools.velocity.MetaInfGenerator;
import com.sap.caf.tools.velocity.UMEPermissionsGenerator;
import com.sap.caf.tools.velocity.UtilsGenerator;
import com.sap.caf.tools.velocity.WDModelGenerator;
import com.sap.caf.tools.velocity.XAP_XAppName_EntityName_dtdbtableGenerator;
import com.sap.caf.tools.velocity.utils.Constants;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.sap.caf.tools.velocity.utils.MMRReader;
import com.sap.caf.tools.velocity.utils.PackageGenerator;
import com.sap.caf.tools.velocity.utils.ProjectLocations;
import com.sap.caf.tools.velocity.utils.VelocityConverter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;

public class MainGenerator {
    public static String defaultMMRPath = "C:/Projects/TestMetaData";
    public static String defaultModelPackage = "com.sap.caf.metamodel";
    private int warnings = 0;
    private PrintWriter log = null;
    private ProjectLocations locations = null;
    private GeneratedFilesList generatedFilesList = null;
    private ModifiedServicesList modifiedServicesList = null;
    private boolean clearBevoreGeneration = false;

    public MainGenerator(ProjectLocations locations, GeneratedFilesList generatedFilesList, ModifiedServicesList modifiedServicesList) throws GeneratorException {
        this(locations, generatedFilesList, modifiedServicesList, defaultMMRPath, defaultModelPackage);
    }

    public MainGenerator(ProjectLocations locations, GeneratedFilesList generatedFilesList, ModifiedServicesList modifiedServicesList, String mmrPath, String modelPackage) throws GeneratorException {
        try {
            defaultMMRPath = mmrPath;
            defaultModelPackage = modelPackage;
            this.locations = locations;
            this.generatedFilesList = generatedFilesList;
            this.modifiedServicesList = modifiedServicesList;
            VelocityConverter.init(locations.getTemplatesPath());
            this.log = new PrintWriter(System.out, true);
            this.log.println("\n\n ### " + new Date() + " ### \n\n");
            this.clearBevoreGeneration = true;
        }
        catch (Exception exc) {
            throw new GeneratorException(exc);
        }
    }

    public File getGeneratedImplementation(BaseObject bo) throws GeneratorException {
        File retVal;
        block7: {
            String appName = null;
            String providerName = null;
            try {
                appName = bo.getApplication().getObjectName();
                providerName = bo.getApplication().getProviderName();
                if (appName == null || providerName == null) {
                    throw new CAFBaseException("Invalid object data, aborting generaton: Null names not allowed.");
                }
            }
            catch (Exception e) {
                throw new GeneratorException(e);
            }
            retVal = null;
            try {
                if (bo instanceof BusinessEntityInterface) {
                    retVal = BEIGenerator.getGeneratedImplementation((BusinessEntityInterface)bo, appName, providerName, this.locations);
                    break block7;
                }
                if (bo instanceof ApplicationInterface) {
                    retVal = ApplicationServiceGenerator.getGeneratedImplementation((ApplicationInterface)bo, appName, providerName, this.locations);
                    break block7;
                }
                throw new CAFBaseException("Object type not supported: " + bo);
            }
            catch (Exception e) {
                throw new GeneratorException(e);
            }
        }
        return retVal;
    }

    public int getResourceCountToBeGenerated(Application app) throws GeneratorException {
        Iterator it = app.getBaseObjects().iterator();
        int result = 0;
        while (it.hasNext()) {
            BaseObject bo = (BaseObject)it.next();
            if (!(bo instanceof ApplicationInterface) && !(bo instanceof ExternalInterface) && !(bo instanceof BusinessEntityInterface) && !(bo instanceof DataStructure)) continue;
            ++result;
        }
        return result;
    }

    public void clearAll(Application app, IResourceChangeListener changeListener) throws GeneratorException {
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        this.clearAll(app, createResources, updateResources, deleteResources, genratedContent, changeListener, true);
    }

    public void clearAll(String appName, String providerName, IResourceChangeListener changeListener) throws GeneratorException {
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        this.clearAll(appName, providerName, createResources, updateResources, deleteResources, genratedContent, changeListener, true);
    }

    public void clearObject(BaseObject bo, IResourceChangeListener changeListener) throws GeneratorException {
        String appName = null;
        try {
            appName = bo.getApplication().getObjectName();
            if (appName == null) {
                throw new CAFBaseException("Invalid object data, aborting generaton: Null application name not allowed.");
            }
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        if (bo instanceof BusinessEntityInterface) {
            BEIGenerator.clear((BusinessEntityInterface)bo, this.locations, this.log, deleteResources, this.generatedFilesList);
        } else if (bo instanceof ApplicationInterface) {
            ApplicationServiceGenerator.clear((ApplicationInterface)bo, this.locations, this.log, deleteResources, this.generatedFilesList);
        } else {
            throw new GeneratorException("Object type not supported: " + bo);
        }
        try {
            this.integrateWithJDI(createResources, updateResources, deleteResources, genratedContent, appName, null, changeListener, this.log);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public synchronized void generateApplication(Application app, GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        String errorMsg;
        String appName = null;
        String providerName = null;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (app == null) {
            throw new GeneratorException("Invalid Application object found: null. Aborting generation.");
        }
        appName = app.getObjectName();
        if (appName == null) {
            throw new GeneratorException("Invalid Application object found: Application name is null. Aborting generation.");
        }
        providerName = app.getProviderName();
        if (providerName == null) {
            throw new GeneratorException("Invalid Application object found: " + appName + ": provider name is null. Aborting generation.");
        }
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        DTRContentHolder contentHolder = new DTRContentHolder(createResources, updateResources, deleteResources, genratedContent, this.generatedFilesList);
        this.log.println("\n  Generating Application " + appName);
        if (this.clearBevoreGeneration) {
            this.clearAll(appName, providerName, createResources, updateResources, deleteResources, genratedContent, changeListener, false);
        }
        UtilsGenerator.generateUtils(appName, providerName, this.locations, this.log, monitor, contentHolder);
        UMEPermissionsGenerator.generatePermissions(app, appName, providerName, this.locations, this.log, monitor, contentHolder);
        boolean hasFaults = this.containsFaults(app);
        Vector<Object> beans = new Vector<Object>();
        Collection baseObjects = app.getBaseObjects();
        Iterator it = baseObjects.iterator();
        boolean hasExternalInterfaces = false;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof ApplicationInterface) {
                ApplicationInterface appServ = (ApplicationInterface)o;
                try {
                    ApplicationServiceGenerator.generateClass(appServ, appName, providerName, this.locations, this.log, this.clearBevoreGeneration, hasFaults, monitor, contentHolder);
                    beans.addElement(appServ);
                    List usedInterfaces = appServ.getUsedInterfaces();
                    int i = 0;
                    while (i < usedInterfaces.size()) {
                        MOFInterface depInt = (MOFInterface)usedInterfaces.get(i);
                        if (depInt instanceof ExternalInterface) {
                            ExternalInterface extServ = (ExternalInterface)depInt;
                            beans.addElement(extServ);
                        }
                        ++i;
                    }
                }
                catch (GeneratorException ge) {
                    ++this.warnings;
                    String errorMsg2 = "    WARNING: ApplicationInterface generation failed: " + appServ.getObjectName() + ": " + ge.getMessage();
                    errorMessages.add(errorMsg2);
                    this.log.println(errorMsg2);
                }
                continue;
            }
            if (o instanceof ExternalInterface) {
                ExternalInterface extServ = (ExternalInterface)o;
                try {
                    ExternalServiceGenerator esg = new ExternalServiceGenerator(extServ, appName, providerName, this.locations, this.log, this.clearBevoreGeneration);
                    esg.generateClass(hasFaults, monitor, contentHolder);
                    hasExternalInterfaces = true;
                    beans.addElement(extServ);
                }
                catch (GeneratorException ge) {
                    ++this.warnings;
                    String errorMsg3 = "    WARNING: ExternalInterface generation failed: " + extServ.getObjectName() + ": " + ge.getMessage();
                    errorMessages.add(errorMsg3);
                    this.log.println(errorMsg3);
                }
                continue;
            }
            if (o instanceof BusinessEntityInterface) {
                BusinessEntityInterface bei = (BusinessEntityInterface)o;
                try {
                    try {
                        String packageName = PackageGenerator.getBusinessServicePackage(bei, this.locations.getCoreName());
                        XAP_XAppName_EntityName_dtdbtableGenerator.clear();
                        XAP_XAppName_EntityName_dtdbtableGenerator.getAllModifiedAndGeneratedFiles(bei.getBusinessEntity(), appName, packageName, this.locations, contentHolder, this.log);
                    }
                    catch (Exception e) {
                        throw new GeneratorException(e);
                    }
                    BEIGenerator.generateClass(bei, appName, providerName, this.locations, this.log, this.clearBevoreGeneration, monitor, contentHolder);
                    beans.addElement(bei);
                }
                catch (GeneratorException ge) {
                    ++this.warnings;
                    String errorMsg4 = "    WARNING: BusinessEntityInterface generation failed: " + bei.getObjectName() + ": " + ge.getMessage();
                    errorMessages.add(errorMsg4);
                    this.log.println(errorMsg4);
                }
                continue;
            }
            if (o instanceof DataStructure) {
                DataStructure ds = (DataStructure)o;
                try {
                    DataStructureGenerator.generateClass(ds, appName, providerName, this.locations, this.log, monitor, contentHolder);
                    if (monitor == null) continue;
                    monitor.registerGeneratedFileAndWork(null);
                }
                catch (GeneratorException ge) {
                    ++this.warnings;
                    String errorMsg5 = "    WARNING: DataStructure generation failed: " + ds.getObjectName() + ": " + ge.getMessage();
                    errorMessages.add(errorMsg5);
                    this.log.println(errorMsg5);
                }
                continue;
            }
            if (!(o instanceof FaultMessage)) continue;
            hasFaults = true;
            FaultMessage fm = (FaultMessage)o;
            try {
                ExceptionGenerator.generateClass(fm, appName, providerName, this.locations, this.log, monitor, contentHolder);
            }
            catch (GeneratorException ge) {
                ++this.warnings;
                String errorMsg6 = "    WARNING: FaultMessage generation failed: " + fm.getObjectName() + ": " + ge.getMessage();
                errorMessages.add(errorMsg6);
                this.log.println(errorMsg6);
            }
        }
        if (hasExternalInterfaces) {
            MPConnectorGenerator MPCG = new MPConnectorGenerator(appName, providerName, this.locations, this.log, this.clearBevoreGeneration);
            MPCG.generateClass(monitor, contentHolder);
        }
        try {
            MetaInfGenerator.generateServiceDescriptors(beans, appName, providerName, this.locations, this.log, monitor, contentHolder);
        }
        catch (GeneratorException ge) {
            ++this.warnings;
            errorMsg = "    WARNING: META-INF generation failed: " + ge.getMessage();
            errorMessages.add(errorMsg);
            this.log.println(errorMsg);
        }
        try {
            HashMap<String, String> extraInitContext = new HashMap<String, String>();
            if (hasExternalInterfaces) {
                extraInitContext.put("isMPRequired", "true");
            }
            EARMetadataGenerator.generateDescriptors(appName, providerName, this.locations, extraInitContext, this.log, monitor, contentHolder);
        }
        catch (GeneratorException ge) {
            ++this.warnings;
            errorMsg = "    WARNING: EAR META-INF generation failed: " + ge.getMessage();
            errorMessages.add(errorMsg);
            this.log.println(errorMsg);
        }
        if (monitor != null) {
            monitor.registerSubTask("Optimizing project resources.");
        }
        try {
            String metadataPath = this.locations.getMetadataPath() + "/src/MMR_M2";
            FileUtils.deleteDir(metadataPath, this.log, deleteResources, this.generatedFilesList);
        }
        catch (Exception e) {
            ++this.warnings;
            errorMsg = "    WARNING: MMR_M2 remove error: " + e.getMessage();
            errorMessages.add(errorMsg);
            this.log.println(errorMsg);
        }
        if (this.modifiedServicesList.getFileList().size() > 0) {
            this.modifiedServicesList.clearList();
        }
        if (errorMessages.size() > 0) {
            this.log.println("  Application " + app.getObjectName() + " generated with " + this.warnings + " ERROR" + (this.warnings == 1 ? "" : "S") + ": ");
            int i = 0;
            while (i < errorMessages.size()) {
                this.log.println(errorMessages.get(i));
                ++i;
            }
            monitor.getStatus().addErrorMessage("Internal generation failure", null);
            monitor.getStatus().addErrorMessage("Internal generation failure", null);
            throw new GeneratorNotificationException(errorMessages);
        }
        this.log.println("  Application " + app.getObjectName() + " generated successful");
        try {
            this.integrateWithJDI(createResources, updateResources, deleteResources, genratedContent, appName, monitor, changeListener, this.log);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public synchronized void generateWDModel(String providerName, String appName, IProgressMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException {
        WDModelGenerator generator = new WDModelGenerator(this.locations, monitor, changeListener);
        generator.generateWDModel(providerName, appName);
    }

    public synchronized void generateWDModel(Application app, IProgressMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException {
        String appName = null;
        String providerName = null;
        ArrayList errorMessages = new ArrayList();
        if (app == null) {
            throw new GeneratorException("Invalid Application object found: null. Aborting generation.");
        }
        appName = app.getObjectName();
        if (appName == null) {
            throw new GeneratorException("Invalid Application object found: Application name is null. Aborting generation.");
        }
        providerName = app.getProviderName();
        if (providerName == null) {
            throw new GeneratorException("Invalid Application object found: " + appName + ": provider name is null. Aborting generation.");
        }
        this.generateWDModel(providerName, appName, monitor, changeListener);
    }

    private void clearAll(Application app, Map createQueue, Map updateQueue, Map deleteQueue, Map generatedContent, IResourceChangeListener changeListener, boolean informChangeListener) throws GeneratorException {
        String appName = null;
        String providerName = null;
        if (app == null) {
            throw new GeneratorException("Invalid Application object found: null. Aborting deletion.");
        }
        appName = app.getObjectName();
        if (appName == null) {
            throw new GeneratorException("Invalid Application object found: Application name is null. Aborting deletion.");
        }
        providerName = app.getProviderName();
        if (providerName == null) {
            throw new GeneratorException("Invalid Application object found: " + appName + ": provider name is null. Aborting deletion.");
        }
        this.clearAll(appName, providerName, createQueue, updateQueue, deleteQueue, generatedContent, changeListener, informChangeListener);
    }

    private void clearAll(String appName, String providerName, Map createQueue, Map updateQueue, Map deleteQueue, Map generatedContent, IResourceChangeListener changeListener, boolean informChangeListener) throws GeneratorException {
        try {
            this.log.println("    -> Removing multiple content");
            this.log.println("      Removing data structures");
            String dataStructurePackageName = PackageGenerator.getDataStructurePackage(appName, providerName);
            String dataStructureGeneratorPath = this.locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + dataStructurePackageName.replace('.', '/');
            FileUtils.deleteDir(dataStructureGeneratorPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("      Removing exceptions");
            String exceptionsPackageName = PackageGenerator.getExceptionsPackage(appName, providerName);
            String exceptionsGeneratorPath = this.locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE + "/" + exceptionsPackageName.replace('.', '/');
            FileUtils.deleteDir(exceptionsGeneratorPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("      Removing META-INF entries");
            String metaInfGeneratorPath = this.locations.getApplicationServicesPath() + "/META-INF";
            FileUtils.cleanDir(metaInfGeneratorPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("      Removing BusinessEntity services");
            String beiGeneratorPath = this.locations.getBusinessEntityPath() + "/" + Constants.SUBDIR_EJBMODULE;
            FileUtils.deleteDir(beiGeneratorPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("      Removing Application services");
            String appServGeneratorPath = this.locations.getApplicationServicesPath() + "/" + Constants.SUBDIR_EJBMODULE;
            FileUtils.deleteDir(appServGeneratorPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("      Removing EAR Metadata");
            String earMetadataPath = this.locations.getEarProjectPath() + "/META-INF";
            FileUtils.cleanDir(earMetadataPath, this.log, deleteQueue, this.generatedFilesList);
            this.log.println("    -> Removing multiple content done");
            if (informChangeListener) {
                this.integrateWithJDI(createQueue, updateQueue, deleteQueue, generatedContent, appName, null, changeListener, this.log);
            }
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    private boolean containsFaults(Application app) {
        boolean hasFaults = false;
        Collection baseObjects = app.getBaseObjects();
        Iterator it = baseObjects.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof FaultMessage)) continue;
            hasFaults = true;
            break;
        }
        return hasFaults;
    }

    private synchronized void generateAll(GenerationMonitor monitor, IResourceChangeListener changeListener) {
        this.log.println("MainGenerator STARTED");
        try {
            MMRReader reader = new MMRReader(defaultMMRPath, this.log);
            Collection c = reader.queryObject(defaultModelPackage, "Application", null);
            if (c.size() == 0) {
                this.log.println("\nWARNING: No Applications found!");
            } else {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    try {
                        Application app = (Application)it.next();
                        this.generateApplication(app, monitor, changeListener);
                    }
                    catch (Exception e) {
                        this.log.println("  Application generation error.");
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.println("MainGenerator finisched with ERROR: ");
        }
        if (this.warnings == 0) {
            this.log.println("MainGenerator finisched SUCCESSFUL");
        } else {
            this.log.println("MainGenerator finisched with WARNINGS: " + this.warnings);
        }
    }

    public synchronized void generateModified(GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException {
        HashSet usedRelationsHolder = new HashSet();
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        DTRContentHolder contentHolder = new DTRContentHolder(createResources, updateResources, deleteResources, genratedContent, this.generatedFilesList);
        String appName = null;
        String providerName = null;
        HashSet dirtyObjects = new HashSet();
        Iterator it1 = this.modifiedServicesList.getFileList().iterator();
        while (it1.hasNext()) {
            dirtyObjects.add(it1.next());
        }
        Iterator it2 = dirtyObjects.iterator();
        while (it2.hasNext()) {
            BaseObject bo = (BaseObject)it2.next();
            if (appName == null && providerName == null) {
                try {
                    appName = bo.getApplication().getObjectName();
                    providerName = bo.getApplication().getProviderName();
                    if (appName == null || providerName == null) {
                        throw new CAFBaseException("Invalid object data, aborting generaton: Null names not allowed.");
                    }
                }
                catch (Exception e) {
                    throw new GeneratorException(e);
                }
            }
            this.generateSingleObject(bo, monitor, contentHolder, usedRelationsHolder, appName, providerName);
        }
        UtilsGenerator.generateUtils(appName, providerName, this.locations, this.log, monitor, contentHolder);
        try {
            this.integrateWithJDI(createResources, updateResources, deleteResources, genratedContent, appName, monitor, changeListener, this.log);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    public synchronized void generateObject(BaseObject bo, GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException {
        HashSet<BaseObject> usedRelationsHolder = new HashSet<BaseObject>();
        HashMap createResources = new HashMap();
        HashMap updateResources = new HashMap();
        HashMap deleteResources = new HashMap();
        HashMap genratedContent = new HashMap();
        DTRContentHolder contentHolder = new DTRContentHolder(createResources, updateResources, deleteResources, genratedContent, this.generatedFilesList);
        String appName = null;
        String providerName = null;
        try {
            appName = bo.getApplication().getObjectName();
            providerName = bo.getApplication().getProviderName();
            if (appName == null || providerName == null) {
                throw new CAFBaseException("Invalid object data, aborting generaton: Null names not allowed.");
            }
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        usedRelationsHolder.add(bo);
        this.generateSingleObject(bo, monitor, contentHolder, usedRelationsHolder, appName, providerName);
        if (!createResources.isEmpty()) {
            UtilsGenerator.generateUtils(appName, providerName, this.locations, this.log, monitor, contentHolder);
        }
        try {
            this.integrateWithJDI(createResources, updateResources, deleteResources, genratedContent, appName, monitor, changeListener, this.log);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    private void generateSingleObject(BaseObject bo, GenerationMonitor monitor, DTRContentHolder contentHolder, Set usedRelationsHolder, String appName, String providerName) throws GeneratorException {
        if (bo instanceof MOFInterface) {
            MOFInterface mofInt = (MOFInterface)bo;
            List dependencies = mofInt.getUsedInterfaces();
            int i = 0;
            while (i < dependencies.size()) {
                MOFInterface depInt = (MOFInterface)dependencies.get(i);
                if (!usedRelationsHolder.contains(depInt)) {
                    usedRelationsHolder.add(depInt);
                    this.generateSingleObject((BaseObject)depInt, monitor, contentHolder, usedRelationsHolder, appName, providerName);
                }
                ++i;
            }
            List operations = mofInt.getOperations();
            int i2 = 0;
            while (i2 < operations.size()) {
                FaultMessage fm;
                Operation op = (Operation)operations.get(i2);
                Iterator it = op.getFault().iterator();
                if (it.hasNext() && this.modifiedServicesList.contains((BaseObject)(fm = (FaultMessage)it.next()))) {
                    ExceptionGenerator.generateClass(fm, appName, providerName, this.locations, this.log, monitor, contentHolder);
                    this.modifiedServicesList.objectGenerated((BaseObject)fm);
                }
                this.generateSingleObjectDS(op.getInput(), monitor, contentHolder, appName, providerName);
                this.generateSingleObjectDS(op.getOutput(), monitor, contentHolder, appName, providerName);
                ++i2;
            }
            if (bo instanceof BusinessEntityInterface) {
                BusinessEntityInterface bei = (BusinessEntityInterface)bo;
                DataObject dObj = bei.getBusinessEntity();
                List attribs = dObj.getAttributes();
                int i3 = 0;
                while (i3 < attribs.size()) {
                    Attribute tempAttr = (Attribute)attribs.get(i3);
                    DataStructure ds = tempAttr.getReferencedObject();
                    if (ds != null && ds instanceof DataObject) {
                        DataObject dOb = (DataObject)ds;
                        BusinessEntityInterface beiRef = null;
                        beiRef = dObj.getBusinessEntityInterface();
                        if (beiRef != null && !usedRelationsHolder.contains(beiRef)) {
                            usedRelationsHolder.add(beiRef);
                            this.generateSingleObject((BaseObject)beiRef, monitor, contentHolder, usedRelationsHolder, appName, providerName);
                        }
                    }
                    ++i3;
                }
            }
        }
        if (!this.modifiedServicesList.contains(bo)) {
            return;
        }
        if (bo instanceof BusinessEntityInterface) {
            BusinessEntityInterface bei = (BusinessEntityInterface)bo;
            try {
                String packageName = PackageGenerator.getBusinessServicePackage(bei, this.locations.getCoreName());
                XAP_XAppName_EntityName_dtdbtableGenerator.clear();
                XAP_XAppName_EntityName_dtdbtableGenerator.getAllModifiedAndGeneratedFiles(bei.getBusinessEntity(), appName, packageName, this.locations, contentHolder, this.log);
            }
            catch (Exception e) {
                throw new GeneratorException(e);
            }
            BEIGenerator.generateClass(bei, appName, providerName, this.locations, this.log, this.clearBevoreGeneration, monitor, contentHolder);
            this.modifiedServicesList.objectGenerated(bo);
        } else if (bo instanceof ApplicationInterface) {
            boolean hasFaults = this.containsFaults(bo.getApplication());
            ApplicationServiceGenerator.generateClass((ApplicationInterface)bo, appName, providerName, this.locations, this.log, this.clearBevoreGeneration, hasFaults, monitor, contentHolder);
            this.modifiedServicesList.objectGenerated(bo);
        } else if (bo instanceof ExternalInterface) {
            boolean hasFaults = this.containsFaults(bo.getApplication());
            ExternalServiceGenerator esg = new ExternalServiceGenerator((ExternalInterface)bo, appName, providerName, this.locations, this.log, this.clearBevoreGeneration);
            esg.generateClass(hasFaults, monitor, contentHolder);
            this.modifiedServicesList.objectGenerated(bo);
        } else {
            throw new GeneratorException("Object type not supported: " + bo);
        }
    }

    private void generateSingleObjectDS(Message message, GenerationMonitor monitor, DTRContentHolder contentHolder, String appName, String providerName) throws GeneratorException {
        List list = null;
        if (message == null) {
            return;
        }
        list = message.getMessageParts();
        int i = 0;
        while (i < list.size()) {
            Attribute attr = (Attribute)list.get(i);
            DataStructure ds = attr.getReferencedObject();
            if (ds != null && !(ds instanceof DataObject) && this.modifiedServicesList.contains((BaseObject)ds)) {
                DataStructureGenerator.generateClass(ds, appName, providerName, this.locations, this.log, monitor, contentHolder);
                this.modifiedServicesList.objectGenerated((BaseObject)ds);
            }
            ++i;
        }
    }

    private void integrateWithJDI(Map createQueue, Map updateQueue, Map deleteQueue, Map generatedContent, String appName, GenerationMonitor monitor, IResourceChangeListener changeListener, PrintWriter log) throws CAFBaseException {
        boolean performChanges;
        if (createQueue.size() == 0 && updateQueue.size() == 0 && deleteQueue.size() == 0) {
            log.println("No changes, DTR integration will be canceled");
            return;
        }
        log.println("\ncreated size: " + createQueue.size());
        log.println("created content: " + createQueue);
        log.println("updated size: " + updateQueue.size());
        log.println("updated content: " + updateQueue);
        log.println("deleted size: " + deleteQueue.size());
        log.println("deleted content: " + deleteQueue);
        log.println("generated size: " + generatedContent.size());
        log.println("generated content: " + generatedContent.keySet() + "\n");
        if (createQueue != null && !createQueue.isEmpty() || deleteQueue != null && !deleteQueue.isEmpty()) {
            FileUtils.addSortedEntry(updateQueue, "/GeneratedFilesList.bckp", "ENTERPRISE_APPLICATION");
            FileUtils.addSortedEntry(updateQueue, "/GeneratedFilesList.orig", "ENTERPRISE_APPLICATION");
        }
        if (changeListener != null && !(performChanges = changeListener.notifyResourceModifications(createQueue, updateQueue, deleteQueue))) {
            log.println("DTR integration canceled, no changes will be performed");
            return;
        }
        this.writeFileContent(createQueue, monitor, generatedContent);
        this.writeFileContent(updateQueue, monitor, generatedContent);
        this.removeFileContent(deleteQueue, monitor);
        Iterator it = generatedContent.keySet().iterator();
        while (it.hasNext()) {
            Object nextKey = it.next();
            if (!(nextKey instanceof DataObject)) continue;
            Map parameters = (Map)generatedContent.get(nextKey);
            DataObject dObj = (DataObject)nextKey;
            String appNameParam = (String)parameters.get("PARAMETER_APP_NAME");
            String packageNameParam = (String)parameters.get("PARAMETER_PACKAGE_NAME");
            ProjectLocations locationsParam = (ProjectLocations)parameters.get("PARAMETER_LOCATIONS");
            XAP_XAppName_EntityName_dtdbtableGenerator.clear();
            XAP_XAppName_EntityName_dtdbtableGenerator.generateDtdbtable(dObj, appNameParam, packageNameParam, locationsParam, log);
        }
        if (changeListener != null) {
            changeListener.finalizeModifications();
        }
    }

    private void removeFileContent(Map queue, GenerationMonitor monitor) throws CAFBaseException {
        Iterator it = queue.keySet().iterator();
        while (it.hasNext()) {
            Object deletedKey = it.next();
            Iterator it2 = ((Set)queue.get(deletedKey)).iterator();
            while (it2.hasNext()) {
                String relPath = (String)it2.next();
                String fullPath = this.generatedFilesList.getFullPath(relPath, (String)deletedKey);
                FileUtils.removeFile(fullPath, monitor, this.generatedFilesList);
            }
        }
    }

    private void writeFileContent(Map queue, GenerationMonitor monitor, Map generatedContent) throws CAFBaseException {
        Iterator it = queue.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Iterator it2 = ((Set)queue.get(key)).iterator();
            while (it2.hasNext()) {
                String fullPath;
                Object genContent;
                String relPath = (String)it2.next();
                if ("/GeneratedFilesList.bckp".equals(relPath) || "/GeneratedFilesList.orig".equals(relPath) || (genContent = generatedContent.get(fullPath = this.generatedFilesList.getFullPath(relPath, (String)key))) == null || !(genContent instanceof String)) continue;
                String content = (String)genContent;
                FileUtils.writeOutputFile(fullPath, content, monitor, this.generatedFilesList);
            }
        }
    }
}

